/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.local.spi.IAttachedProjectVersionUpdaterInternal;
import com.nomagic.ci.persistence.local.spi.IAttachedProjectVersioningServiceInternal;
import com.nomagic.ci.persistence.local.spi.ProjectUpdateContext;
import com.nomagic.ci.persistence.local.spi.decomposition.IAttachedProjectResolver;
import com.nomagic.ci.persistence.spi.IAttachedProjectStateService;
import com.nomagic.ci.persistence.versioning.IVersionDescriptor;
import com.nomagic.ci.persistence.versioning.Versioning;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class AttachedProjectVersionUpdater
implements IAttachedProjectVersionUpdaterInternal {
    private final IAttachedProject project;

    public AttachedProjectVersionUpdater(IAttachedProject iAttachedProject) {
        this.project = iAttachedProject;
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public boolean update(IProject iProject, ProjectUsage projectUsage, ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
        boolean bl = this.scheduleUpdate(iProject, projectUsage);
        if (bl) {
            this.doUpdate(projectUpdateContext, iProgressMonitor);
        }
        return bl;
    }

    public boolean scheduleUpdate(IProject iProject, ProjectUsage projectUsage) throws PersistenceException {
        Object object;
        IVersionDescriptor iVersionDescriptor;
        block5: {
            iVersionDescriptor = null;
            if (!Versioning.isHistorical((IProject)iProject) && !projectUsage.isSticky()) break block5;
            object = (IAttachedProjectResolver)iProject.getService(IAttachedProjectResolver.class);
            iVersionDescriptor = object.getProjectVersion(projectUsage);
        }
        object = this.getVersioningService();
        IVersionDescriptor iVersionDescriptor2 = object.getVersionToLoad();
        if (!AttachedProjectVersionUpdater.versionsAreEqual(iVersionDescriptor2, iVersionDescriptor)) {
            object.setVersionToLoad(iVersionDescriptor, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        return false;
    }

    protected IAttachedProjectVersioningServiceInternal getVersioningService() {
        IAttachedProjectVersioningServiceInternal iAttachedProjectVersioningServiceInternal = (IAttachedProjectVersioningServiceInternal)this.project.getService(IAttachedProjectVersioningServiceInternal.class);
        return iAttachedProjectVersioningServiceInternal;
    }

    public void doUpdate(ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
        block8: {
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            try {
                block11: {
                    boolean bl;
                    IAttachedProjectStateService iAttachedProjectStateService;
                    block10: {
                        block9: {
                            iProgressMonitor.beginTask("", 800);
                            iProgressMonitor.subTask("Unloading poroject");
                            iAttachedProjectStateService = (IAttachedProjectStateService)this.project.getService(IAttachedProjectStateService.class);
                            if (iAttachedProjectStateService == null) break block8;
                            bl = iAttachedProjectStateService.isLoaded();
                            if (!bl) break block9;
                            iAttachedProjectStateService.unload((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
                            break block10;
                        }
                        iProgressMonitor.worked(400);
                    }
                    iProgressMonitor.subTask("Loading project");
                    if (!bl) break block11;
                    iAttachedProjectStateService.load((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
                    break block8;
                }
                iProgressMonitor.worked(400);
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    public static boolean versionsAreEqual(IVersionDescriptor iVersionDescriptor, IVersionDescriptor iVersionDescriptor2) {
        if (iVersionDescriptor == null) {
            return iVersionDescriptor2 == null;
        }
        if (iVersionDescriptor2 == null) {
            return false;
        }
        return iVersionDescriptor.getName().equals(iVersionDescriptor2.getName());
    }
}

