/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.metamodel.local.project.LocalDataSection;
import com.nomagic.ci.metamodel.project.ProjectFeature;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.ProjectDescriptor;
import com.nomagic.ci.persistence.ProjectEvent;
import com.nomagic.ci.persistence.ProjectEventType;
import com.nomagic.ci.persistence.ProjectListener;
import com.nomagic.ci.persistence.decomposition.IProjectExtractionService;
import com.nomagic.ci.persistence.events.IComplexOperationEventType;
import com.nomagic.ci.persistence.features.EObjectDataSetProvider;
import com.nomagic.ci.persistence.features.FeatureDataManager;
import com.nomagic.ci.persistence.features.FeatureDataSetFilter;
import com.nomagic.ci.persistence.features.FeatureDependencyException;
import com.nomagic.ci.persistence.features.IProjectFeature;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import com.nomagic.ci.persistence.features.IProjectFeatureHandler;
import com.nomagic.ci.persistence.features.IProjectFeatureHandlerService;
import com.nomagic.ci.persistence.local.CallbackEventType;
import com.nomagic.ci.persistence.local.ILocalProjectResourceManager;
import com.nomagic.ci.persistence.local.ILocalResourceDescriptor;
import com.nomagic.ci.persistence.local.IUpdateAdvisor;
import com.nomagic.ci.persistence.local.LocalProjectOptions;
import com.nomagic.ci.persistence.local.decomposition.IProjectJoiningService;
import com.nomagic.ci.persistence.local.importers.IProjectDataProvider;
import com.nomagic.ci.persistence.local.importers.ImportProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.local.importers.ProjectFeatureImportService;
import com.nomagic.ci.persistence.local.internal.A;
import com.nomagic.ci.persistence.local.internal.F;
import com.nomagic.ci.persistence.local.internal.H;
import com.nomagic.ci.persistence.local.internal.J;
import com.nomagic.ci.persistence.local.internal.M;
import com.nomagic.ci.persistence.local.internal.O;
import com.nomagic.ci.persistence.local.internal.P;
import com.nomagic.ci.persistence.local.internal.S;
import com.nomagic.ci.persistence.local.internal.T;
import com.nomagic.ci.persistence.local.internal.a.c;
import com.nomagic.ci.persistence.local.internal.c.k;
import com.nomagic.ci.persistence.local.internal.d.a;
import com.nomagic.ci.persistence.local.internal.e.a.b;
import com.nomagic.ci.persistence.local.internal.e.a.d;
import com.nomagic.ci.persistence.local.internal.f.f;
import com.nomagic.ci.persistence.local.internal.f.i;
import com.nomagic.ci.persistence.local.internal.f.j;
import com.nomagic.ci.persistence.local.internal.i.g;
import com.nomagic.ci.persistence.local.internal.l.e;
import com.nomagic.ci.persistence.local.internal.t;
import com.nomagic.ci.persistence.local.internal.w;
import com.nomagic.ci.persistence.local.internal.x;
import com.nomagic.ci.persistence.local.internal.y;
import com.nomagic.ci.persistence.local.mounting.IProjectMountingService;
import com.nomagic.ci.persistence.local.proxy.LocalProxyService;
import com.nomagic.ci.persistence.local.sharing.IObjectLevelSharingManagerFactory;
import com.nomagic.ci.persistence.local.sharing.IProjectSharingManager;
import com.nomagic.ci.persistence.local.spi.AbstractAttachedProject;
import com.nomagic.ci.persistence.local.spi.IDataSectionManager;
import com.nomagic.ci.persistence.local.spi.IPrimaryProjectInternal;
import com.nomagic.ci.persistence.local.spi.IProjectAccessModeController;
import com.nomagic.ci.persistence.local.spi.IProjectConfigurator;
import com.nomagic.ci.persistence.local.spi.IProjectInternal;
import com.nomagic.ci.persistence.local.spi.IProjectResourceURIFactory;
import com.nomagic.ci.persistence.local.spi.IProjectServiceDescriptor;
import com.nomagic.ci.persistence.local.spi.IProjectUpdateService;
import com.nomagic.ci.persistence.local.spi.IResourceUriMapper;
import com.nomagic.ci.persistence.local.spi.IResourceUriMapperService;
import com.nomagic.ci.persistence.local.spi.IRollbackExecutor;
import com.nomagic.ci.persistence.local.spi.ISaveExecutor;
import com.nomagic.ci.persistence.local.spi.InterceptorController;
import com.nomagic.ci.persistence.local.spi.PreUpdateProjectState;
import com.nomagic.ci.persistence.local.spi.ProjectDecompositionManager;
import com.nomagic.ci.persistence.local.spi.ProjectEventSupport;
import com.nomagic.ci.persistence.local.spi.ProjectFeatureResources;
import com.nomagic.ci.persistence.local.spi.ProjectServiceRegistry;
import com.nomagic.ci.persistence.local.spi.ProjectUpdateContext;
import com.nomagic.ci.persistence.local.spi.ServiceNewAndOldValue;
import com.nomagic.ci.persistence.local.spi.ServiceResourceManagerFactory;
import com.nomagic.ci.persistence.local.spi.binary.IBinarySynchronizationService;
import com.nomagic.ci.persistence.local.spi.callback.CallbackProjectSupport;
import com.nomagic.ci.persistence.local.spi.callback.ProjectCallbackEvent;
import com.nomagic.ci.persistence.local.spi.callback.ProjectCallbackEventImpl;
import com.nomagic.ci.persistence.local.spi.callback.ProjectCallbackListener;
import com.nomagic.ci.persistence.local.spi.decomposition.DecompositionModelService;
import com.nomagic.ci.persistence.local.spi.decomposition.IReverseProjectUsageManager;
import com.nomagic.ci.persistence.local.spi.decomposition.LocalDecompositionModelFactory;
import com.nomagic.ci.persistence.local.spi.decompositionversion.DecompositionVersionUtility;
import com.nomagic.ci.persistence.local.spi.events.LocalComplexOperationEventType;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusEventImpl;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusSupport;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusSupportImpl;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventType;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventTypeImpl;
import com.nomagic.ci.persistence.local.spi.features.LocalEObjectDataSetProvider;
import com.nomagic.ci.persistence.local.spi.features.LocalFeatureInitializer;
import com.nomagic.ci.persistence.local.spi.features.dependency.IProjectDependenciesPublisher;
import com.nomagic.ci.persistence.local.spi.features.dependency.SubscriptionType;
import com.nomagic.ci.persistence.local.spi.interceptor.IProjectInterceptor;
import com.nomagic.ci.persistence.local.spi.mounting.IMountingEventsDispatcher;
import com.nomagic.ci.persistence.local.spi.mounting.MountPointDependenciesProvider;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.local.spi.sharing.IProjectSharePointsTracker;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import com.nomagic.ci.persistence.resources.FeatureResourceFilter;
import com.nomagic.ci.persistence.spi.IProjectSaveService;
import com.nomagic.ci.persistence.spi.ProjectAvailabilityService;
import com.nomagic.ci.persistence.spi.ProjectState;
import com.nomagic.ci.persistence.spi.decomposition.DecompositionModelFactory;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.spi.decomposition.MultiProjectEventImpl;
import com.nomagic.ci.persistence.spi.decomposition.ProjectEventImpl;
import com.nomagic.ci.persistence.spi.events.ComplexOperationEventType;
import com.nomagic.ci.persistence.spi.events.IComplexOperationEvent;
import com.nomagic.ci.persistence.spi.events.IComplexOperationEventService;
import com.nomagic.ci.persistence.spi.features.AbstractFeatureInitializer;
import com.nomagic.ci.persistence.spi.features.DefaultProjectFeatureRegistry;
import com.nomagic.ci.persistence.spi.features.IProjectFeatureRegistry;
import com.nomagic.ci.persistence.util.ProjectUtil;
import com.nomagic.ci.persistence.versioning.Versioning;
import com.nomagic.ci.services.ServicesRegistry;
import com.nomagic.ci.services.SingletonServiceRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class AbstractProject
implements IProjectInternal {
    private static final Logger LOGGER = Logger.getLogger(AbstractProject.class);
    private InterceptorController<IProject, IProjectInterceptor.ProjectInterceptorType> projectInterceptorController = new InterceptorController();
    public static final ServiceEventType SERVICE_REGISTERED_EVENT_TYPE = new ServiceEventTypeImpl("SERVICE_REGISTERED", AbstractProject.class);
    public static final ServiceEventType RESOURCE_SET_EVENT_TYPE = new ServiceEventTypeImpl("RESOURCE_SET", AbstractProject.class);
    public static final ServiceEventType URI_MAPPER_EVENT_TYPE = new ServiceEventTypeImpl("URI_MAPPER", AbstractProject.class);
    public static final ServiceEventType FEATURE_RESOURCES_LOADED_EVENT_TYPE = new ServiceEventTypeImpl("FEATURE_RESOURCES_LOADED", AbstractProject.class);
    public static final ServiceEventType FEATURE_RESOURCES_UPDATED_EVENT_TYPE = new ServiceEventTypeImpl("FEATURE_RESOURCES_LOADED", AbstractProject.class);
    public static final ServiceEventType PROJECT_SAVE_DEPENDENCIES_PUBLISHED_EVENT_TYPE = new ServiceEventTypeImpl("PROJECT_SAVE_DEPENDENCIES_PUBLISHED", AbstractProject.class);
    public static final ServiceEventType PROJECT_ID_EVENT_TYPE = new ServiceEventTypeImpl("PROJECT_ID", AbstractProject.class);
    protected ProjectEventSupport projectEventSupport = new ProjectEventSupport();
    protected final IProjectFeatureRegistry featureRegistry = new DefaultProjectFeatureRegistry();
    protected final ProjectServiceRegistry projectServices = new ProjectServiceRegistry();
    protected final O<Object> globalServices = new O();
    private IProjectRepository projectRepository;
    private IResourceUriMapper uriMapper;
    private DecompositionModelService decompositionModel;
    private ProjectDecompositionManager projectManager;
    private ResourceSet resourceSet = null;
    private boolean projectAvailable;
    private boolean isNew;
    private IProjectConfigurator configurator;
    private boolean updating = false;
    private CallbackProjectSupport callbackSupport = new CallbackProjectSupport();
    protected ServiceBusSupportImpl serviceBusSupport = new ServiceBusSupportImpl();
    protected final IProjectAccessModeController accessController = new A(this, this.serviceBusSupport);

    protected AbstractProject(IProjectRepository iProjectRepository, boolean bl, IProjectConfigurator iProjectConfigurator) {
        if (iProjectRepository == null) {
            throw new NullPointerException("Project repository can not be null");
        }
        this.projectRepository = iProjectRepository;
        this.configurator = iProjectConfigurator;
        this.setNew(bl);
        this.registerProjectService(IProjectAccessModeController.class, this.accessController);
        this.initProjectEventDispatcher();
        this.initProjectUsageManager();
        this.initUriMapperService();
        this.initDecompositionModelSupport();
        this.initFeatureDecompositionManagement();
        this.initSharingSupport();
        this.initMountingSupport();
        this.initFeatureNotificationSupport();
        this.initResourceAccessTracker();
        this.initProjectDependenciesPublisher();
        this.initReferencedProjectsResharer();
        this.initEPackageEObjectService();
        this.registerSaveService();
        this.registerProjectUpdateService();
        this.initProjectFeatureImportService();
        this.initProjectResourceURIFactory();
        this.initAvailabilityService();
        this.registerProjectService(EObjectDataSetProvider.class, new LocalEObjectDataSetProvider(this));
    }

    private void initAvailabilityService() {
        this.registerProjectService(ProjectAvailabilityService.class, new ProjectAvailabilityService(){

            public IProject getProject() {
                return AbstractProject.this;
            }

            public boolean isProjectAvailable() {
                return AbstractProject.this.isProjectAvailable();
            }
        });
    }

    public void initProjectResourceURIFactory() {
        this.registerProjectService(IProjectResourceURIFactory.class, new IProjectResourceURIFactory(){

            @Override
            public URI getPersonalFeatureResourceURI(IProjectFeatureDescriptor iProjectFeatureDescriptor, String string) {
                String string2 = com.nomagic.ci.persistence.local.internal.h.c.a(AbstractProject.this.getProjectRepository());
                return AbstractProject.this.uriMapper.getPersonalResourceURI(string2, iProjectFeatureDescriptor.getNamespace(), string);
            }

            @Override
            public URI getFeatureResourceURI(IProjectFeatureDescriptor iProjectFeatureDescriptor, String string) {
                return AbstractProject.this.uriMapper.getResourceURI(iProjectFeatureDescriptor.getNamespace(), string);
            }
        });
    }

    protected void initProjectFeatureImportService() {
        this.registerProjectService(ProjectFeatureImportService.class, new ProjectFeatureImportService(){

            @Override
            public void importFeatures(IProjectDataProvider iProjectDataProvider, IProgressMonitor iProgressMonitor) throws PersistenceException {
                AbstractProject.this.importFeatures(iProjectDataProvider, iProgressMonitor);
            }
        });
    }

    private void registerProjectUpdateService() {
        this.registerProjectService(IProjectUpdateService.class, new IProjectUpdateService(){

            @Override
            public boolean canUpdate() {
                return AbstractProject.this.canUpdate();
            }

            @Override
            public void update(IProgressMonitor iProgressMonitor) throws PersistenceException {
                AbstractProject.this.update(iProgressMonitor);
            }

            @Override
            public void rollback(IProgressMonitor iProgressMonitor) throws PersistenceException {
                AbstractProject.this.rollback(iProgressMonitor);
            }

            public IProject getProject() {
                return AbstractProject.this;
            }
        });
    }

    private void registerSaveService() {
        this.registerProjectService(IProjectSaveService.class, new IProjectSaveService(){

            public void save(@CheckForNull String string, @Nonnull Map<String, Object> map, @Nonnull IProgressMonitor iProgressMonitor) throws PersistenceException {
                AbstractProject.this.save(string, map, iProgressMonitor);
            }

            public void save(String string, IProgressMonitor iProgressMonitor) throws PersistenceException {
                AbstractProject.this.save(string, Collections.emptyMap(), iProgressMonitor);
            }

            public IProject getProject() {
                return AbstractProject.this;
            }
        });
    }

    public final ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public final void setResourceSet(ResourceSet resourceSet) {
        ResourceSet resourceSet2 = this.resourceSet;
        this.resourceSet = resourceSet;
        ServiceNewAndOldValue serviceNewAndOldValue = new ServiceNewAndOldValue(resourceSet, resourceSet2);
        ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl(this, RESOURCE_SET_EVENT_TYPE, serviceNewAndOldValue);
        this.getProjectServiceEventBus().fireEvent(serviceBusEventImpl);
    }

    protected final IProjectConfigurator getConfigurator() {
        return this.configurator;
    }

    public final void setUriMapper(IResourceUriMapper iResourceUriMapper) {
        IResourceUriMapper iResourceUriMapper2 = this.uriMapper;
        this.uriMapper = iResourceUriMapper;
        ServiceNewAndOldValue serviceNewAndOldValue = new ServiceNewAndOldValue(iResourceUriMapper, iResourceUriMapper2);
        ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl(this, URI_MAPPER_EVENT_TYPE, serviceNewAndOldValue);
        this.getServiceBusSupport().fireEvent(serviceBusEventImpl);
    }

    public final IResourceUriMapper getUriMapper() {
        return this.uriMapper;
    }

    protected void initProjectDependenciesPublisher() {
        this.registerProjectService(IProjectDependenciesPublisher.class, new d(this));
    }

    protected void initReferencedProjectsResharer() {
        c.a(this);
    }

    protected void initResourceAccessTracker() {
        this.getProjectServiceEventBus().addListener(new e(this));
    }

    protected void initProjectEventDispatcher() {
        com.nomagic.ci.persistence.local.internal.d.c c2 = new com.nomagic.ci.persistence.local.internal.d.c(this);
        this.registerProjectService(a.class, c2);
    }

    protected void initProjectUsageManager() {
        J j2 = new J(this, this.getServiceBusSupport());
        this.registerProjectService(IProjectUsageManager.class, j2);
        this.registerProjectService(IReverseProjectUsageManager.class, j2);
        this.registerProjectService(w.class, j2);
        this.registerProjectService(x.class, j2);
    }

    protected void initUriMapperService() {
        IResourceUriMapperService iResourceUriMapperService = new IResourceUriMapperService(){

            public IProject getProject() {
                return AbstractProject.this;
            }

            @Override
            public URI getResourceURI(String string, String string2) {
                if (AbstractProject.this.uriMapper == null) {
                    throw new IllegalStateException();
                }
                return AbstractProject.this.uriMapper.getResourceURI(string, string2);
            }

            @Override
            public URI getPersonalResourceURI(String string, String string2, String string3) {
                if (AbstractProject.this.uriMapper == null) {
                    throw new IllegalStateException();
                }
                return AbstractProject.this.uriMapper.getPersonalResourceURI(string, string2, string3);
            }

            @Override
            public ResourceInfo getResourceInfo(URI uRI) {
                if (AbstractProject.this.uriMapper == null) {
                    throw new IllegalStateException();
                }
                return AbstractProject.this.uriMapper.getResourceInfo(uRI);
            }
        };
        this.registerProjectService(IResourceUriMapperService.class, iResourceUriMapperService);
    }

    protected void initSharingSupport() {
        H h2 = new H(this);
        this.registerProjectService(IProjectSharePointsTracker.class, h2);
        this.registerProjectService(IProjectSharingManager.class, this.configurator.createProjectSharingManager(this, this.serviceBusSupport));
        this.registerProjectService(IObjectLevelSharingManagerFactory.class, this.configurator.createObjectLevelSharingManagerFactory(this, this.serviceBusSupport));
        com.nomagic.ci.persistence.local.internal.l.d.a(this);
    }

    protected void initMountingSupport() {
        j j2 = new j(this);
        this.registerProjectService(IProjectMountingService.class, j2);
        i i2 = new i(this);
        this.registerProjectService(com.nomagic.ci.persistence.local.internal.f.d.class, i2);
        this.registerProjectService(IMountingEventsDispatcher.class, i2);
        this.registerProjectService(MountPointDependenciesProvider.class, i2);
    }

    protected void initPartitioningSupport(boolean bl) {
        k k2 = new k(this, bl);
        this.registerProjectService(IProjectExtractionService.class, k2);
        IProjectJoiningService iProjectJoiningService = this.configurator.createProjectJoiningService(this, this.serviceBusSupport);
        this.registerProjectService(IProjectJoiningService.class, iProjectJoiningService);
    }

    protected void initFeatureNotificationSupport() {
        t t2 = new t(this, this.getServiceBusSupport());
        this.projectEventSupport.addListenerInEnd(t2);
    }

    protected void initEPackageEObjectService() {
    }

    protected void initDecompositionModelSupport() {
        this.decompositionModel = this.configurator.createDecompositionModelService(this, this.serviceBusSupport);
        this.registerProjectService(IDecompositionModel.class, this.decompositionModel);
        P p2 = this.configurator.createDataSectionManager(this, this.serviceBusSupport);
        this.registerProjectService(IDataSectionManager.class, p2);
        this.registerProjectService(DecompositionModelFactory.class, new LocalDecompositionModelFactory());
    }

    protected void initFeatureDecompositionManagement() {
        LocalFeatureInitializer localFeatureInitializer = this.configurator.createFeatureInitializer(this, this.featureRegistry, this.serviceBusSupport);
        this.projectServices.a(LocalFeatureInitializer.class, localFeatureInitializer);
    }

    protected LocalFeatureInitializer getFeatureInitializer() {
        return this.projectServices.a(LocalFeatureInitializer.class);
    }

    public void setProjectManager(ProjectDecompositionManager projectDecompositionManager) {
        this.projectManager = projectDecompositionManager;
    }

    public void installProjectSupport(IProgressMonitor iProgressMonitor) {
        this.installDecomposition(iProgressMonitor);
    }

    public void registerProjectInResourceAccessManager() {
        y y2 = this.getResourceAccessManager();
        if (y2 != null) {
            y2.a(this);
        }
    }

    public void loadProjectSupport(IProgressMonitor iProgressMonitor) throws IOException {
        this.loadDecomposition(null);
        this.registerProjectInResourceAccessManager();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unloadProjectSupport(IProgressMonitor iProgressMonitor) {
        this.unloadDecomposition(null);
        EList eList = this.getResourceSet().getResources();
        for (Resource resource : this.getServiceResources()) {
            if (resource.isLoaded()) continue;
            eList.remove((Object)resource);
        }
    }

    public void installDecomposition(IProgressMonitor iProgressMonitor) {
        this.decompositionModel.install(iProgressMonitor);
    }

    public void loadDecomposition(IProgressMonitor iProgressMonitor) throws IOException {
        this.decompositionModel.load(iProgressMonitor);
    }

    public void unloadDecomposition(IProgressMonitor iProgressMonitor) {
        this.decompositionModel.unload(iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void init(Set<String> set, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkState(false);
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        boolean bl = false;
        int n2 = this.getListenerTicks();
        int n3 = this.getListenerCount();
        iProgressMonitor.beginTask("Initializing project...", n2 * 11 + n3 + n3);
        try {
            boolean bl2 = false;
            try {
                this.fireEvent(ProjectEventType.PRE_INIT, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                this.setState(true);
                if (this instanceof IAttachedProject) {
                    ((AbstractAttachedProject)this).setProjectState(ProjectState.Loaded);
                }
                this.doInit(set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2 * 8));
                bl2 = true;
            }
            finally {
                if (this instanceof IPrimaryProject) {
                    com.nomagic.ci.persistence.local.internal.f.a.d.a((IProject)this, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
            }
            this.fireEvent(ProjectEventType.POST_INIT, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
            return;
        }
        finally {
            if (!bl) {
                this.fireEvent(ProjectEventType.FAILED_INIT, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            }
            iProgressMonitor.done();
            if (!bl) {
                this.setState(false);
                if (this instanceof IAttachedProject) {
                    ((AbstractAttachedProject)this).setProjectState(ProjectState.NotLoaded);
                }
            }
        }
    }

    public void doInit(Set<String> set, IProgressMonitor iProgressMonitor) throws PersistenceException {
        iProgressMonitor.beginTask("", 1000);
        try {
            this.installProjectSupport((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
            this.installFeatures(set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void doLoadInternal(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Loading project...", 2400);
        try {
            try {
                this.beforeLoadForProxyService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                this.loadProjectSupport((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 700));
                this.loadFeatures((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl(this, FEATURE_RESOURCES_LOADED_EVENT_TYPE, null);
                this.serviceBusSupport.fireEvent(serviceBusEventImpl);
                this.updateManualReachabilytyAfterLoad((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                this.loadAttachedProjects((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                this.afterLoadForProxyService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
            }
            catch (IOException iOException) {
                throw new PersistenceException((Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void updateManualReachabilytyAfterLoad(IProgressMonitor iProgressMonitor) {
        try {
            iProgressMonitor.beginTask("", 100);
            if (this instanceof IAttachedProject) {
                com.nomagic.ci.persistence.local.internal.c.e e2 = this.getService(com.nomagic.ci.persistence.local.internal.c.e.class);
                e2.c();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected final void beforeLoadForProxyService(IProgressMonitor iProgressMonitor) throws IOException {
        block3: {
            block2: {
                g g2 = (g)this.getService(LocalProxyService.class);
                if (g2 == null) break block2;
                g2.e(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    protected final void afterLoadForProxyService(IProgressMonitor iProgressMonitor) throws IOException {
        block3: {
            block2: {
                g g2 = (g)this.getService(LocalProxyService.class);
                if (g2 == null) break block2;
                g2.f(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    @CheckForNull
    protected y getResourceAccessManager() {
        IPrimaryProjectInternal iPrimaryProjectInternal = (IPrimaryProjectInternal)ProjectUtil.getPrimaryProject((IProject)this);
        y y2 = iPrimaryProjectInternal != null ? iPrimaryProjectInternal.getResourceAccessManager() : null;
        return y2;
    }

    public void doUnload(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 900);
        try {
            this.dropFeatures((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
            this.unloadFeatureResources((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
            this.unloadProjectSupport((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void afterUnloadForProxyService(IProgressMonitor iProgressMonitor) throws IOException {
        block3: {
            block2: {
                g g2 = (g)this.getService(LocalProxyService.class);
                if (g2 == null) break block2;
                g2.h(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    protected void beforeUpdateForProxyService(IProgressMonitor iProgressMonitor) {
        block3: {
            block2: {
                g g2 = (g)this.getService(LocalProxyService.class);
                if (g2 == null) break block2;
                g2.b(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    protected void afterUpdateForProxyService(IProgressMonitor iProgressMonitor) {
        block3: {
            block2: {
                g g2 = (g)this.getService(LocalProxyService.class);
                if (g2 == null) break block2;
                g2.c(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    protected void beforeUnloadForProxyService(IProgressMonitor iProgressMonitor) throws IOException {
        block3: {
            block2: {
                g g2 = (g)this.getService(LocalProxyService.class);
                if (g2 == null) break block2;
                g2.g(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unloadFeatureResources(IProgressMonitor iProgressMonitor) {
        Collection<Resource> collection = this.getManagedResources();
        EList eList = this.getResourceSet().getResources();
        for (Resource resource : collection) {
            resource.unload();
            eList.remove((Object)resource);
        }
    }

    public void doClose(@Nonnull IProgressMonitor iProgressMonitor) {
        try {
            iProgressMonitor.beginTask("", 100);
            iProgressMonitor.worked(30);
            this.setState(false);
            iProgressMonitor.worked(30);
            iProgressMonitor.worked(30);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void checkDataProvider(IProjectDataProvider iProjectDataProvider) throws PersistenceException {
        if (iProjectDataProvider == null) {
            throw new NullPointerException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void importFeatures(IProjectDataProvider iProjectDataProvider, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkDataProvider(iProjectDataProvider);
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        boolean bl = false;
        int n2 = this.getListenerCount();
        int n3 = this.getListenerTicks();
        try {
            HashSet<String> hashSet;
            boolean bl2 = false;
            try {
                iProgressMonitor.beginTask("Importing data into project...", 1100 + n3 * 2 + n2);
                this.fireEvent(S.a(this), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                hashSet = new HashSet<String>(iProjectDataProvider.getFeatures(this));
                this.importData(iProjectDataProvider, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                List<ImportProjectAttachmentConfiguration> list = iProjectDataProvider.getAttachedProjects(this);
                if (list != null && !list.isEmpty()) {
                    this.projectManager.attach(list, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                } else {
                    iProgressMonitor.worked(500);
                }
                bl2 = true;
            }
            finally {
                com.nomagic.ci.persistence.local.internal.f.a.d.a(this, f.a.IMPORT_FEATURES, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            this.fireEvent(S.a(this, hashSet), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            bl = true;
            return;
        }
        finally {
            try {
                if (!bl) {
                    this.fireEvent(S.b(this), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    public void installFeatures(Set<String> set, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        boolean bl = false;
        int n2 = this.getListenerCount();
        int n3 = this.getListenerTicks();
        try {
            boolean bl2 = false;
            try {
                iProgressMonitor.beginTask("Installing features into project...", 1100 + n3 * 2 + n2);
                set = new HashSet<String>(set);
                this.fireEvent(new T(ProjectEventType.PRE_INSTALL_FEATURES, this, set), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                this.getFeatureInitializer().install(set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                bl2 = true;
            }
            finally {
                com.nomagic.ci.persistence.local.internal.f.a.d.a(this, f.a.INSTALL_FEATURES, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            this.fireEvent(new T(ProjectEventType.POST_INSTALL_FEATURES, this, set), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            bl = true;
        }
        finally {
            try {
                if (!bl) {
                    this.fireEvent(new T(ProjectEventType.FAILED_INSTALL_FEATURES, this, set), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    public void uninstallFeatures(Set<String> set, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        boolean bl = false;
        int n2 = this.getListenerCount();
        int n3 = this.getListenerTicks();
        try {
            boolean bl2 = false;
            try {
                iProgressMonitor.beginTask("Uninstalling features into project...", 1100 + n3 * 2 + n2);
                set = new HashSet<String>(set);
                this.fireEvent(new T(ProjectEventType.PRE_UNINSTALL_FEATURES, this, set), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                this.getFeatureInitializer().uninstall(set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                bl2 = true;
            }
            finally {
                com.nomagic.ci.persistence.local.internal.f.a.d.a(this, f.a.UNINSTALL_FEATURES, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            this.fireEvent(new T(ProjectEventType.POST_UNINSTALL_FEATURES, this, set), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            bl = true;
        }
        finally {
            try {
                if (!bl) {
                    this.fireEvent(new T(ProjectEventType.FAILED_UNINSTALL_FEATURES, this, set), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    public final void save(@CheckForNull String string, @Nonnull Map<String, Object> map, @Nonnull IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkCanSave();
        this.internalSave(string, map, iProgressMonitor);
    }

    public final void save(@CheckForNull String string, @Nonnull IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.save(string, Collections.emptyMap(), iProgressMonitor);
    }

    public final void internalSave(String string, Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = this.getListenerTicks();
        boolean bl = false;
        LinkedHashSet<IProject> linkedHashSet = new LinkedHashSet<IProject>(Collections.singleton(this));
        try {
            MultiProjectEventImpl multiProjectEventImpl;
            boolean bl2 = false;
            try {
                iProgressMonitor.beginTask("", 1100 + n2 * 2);
                multiProjectEventImpl = new MultiProjectEventImpl(ProjectEventType.PRE_SAVE_PROJECTS, (IProject)this, linkedHashSet);
                this.fireEvent((ProjectEvent)multiProjectEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                this.internalSaveProjects(string, map, linkedHashSet, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                bl2 = true;
            }
            finally {
                com.nomagic.ci.persistence.local.internal.f.a.d.a((IProject)this, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            multiProjectEventImpl = new MultiProjectEventImpl(ProjectEventType.POST_SAVE_PROJECTS, (IProject)this, linkedHashSet);
            this.fireEvent((ProjectEvent)multiProjectEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
        }
        finally {
            try {
                if (!bl) {
                    MultiProjectEventImpl multiProjectEventImpl = new MultiProjectEventImpl(ProjectEventType.FAILED_SAVE_PROJECTS, (IProject)this, linkedHashSet);
                    this.fireEvent((ProjectEvent)multiProjectEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    private void internalSaveProjects(String string, Map<String, Object> map, Set<IProject> set, IProgressMonitor iProgressMonitor) throws PersistenceException {
        boolean bl = false;
        try {
            iProgressMonitor.beginTask("Saving project..." + this.getName(), 1000);
            ISaveExecutor iSaveExecutor = this.createSaveExecutor(string, map);
            if (iSaveExecutor == null) {
                throw new IllegalArgumentException("null ISaveExecutor");
            }
            this.executePreSaveRoutines(iSaveExecutor, set, string, map, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            iSaveExecutor.commitResources(Collections.unmodifiableSet(set), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
            for (IProject iProject : set) {
                ((AbstractProject)iProject).setNew(false);
            }
            bl = true;
        }
        finally {
            try {
                this.executePostSaveRoutines(set, bl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executePreSaveRoutines(ISaveExecutor iSaveExecutor, Set<IProject> set, String string, Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        try {
            int n2 = ProjectUtil.getProjects((IPrimaryProject)ProjectUtil.getPrimaryProject((IProject)this)).size();
            iProgressMonitor.beginTask("", n2 * 550);
            Set<IProject> set2 = set;
            boolean bl = false;
            do {
                for (IProject iProject : set2) {
                    AbstractProject abstractProject = (AbstractProject)iProject;
                    abstractProject.checkState(true);
                    abstractProject.intercept(this, IProjectInterceptor.ProjectInterceptorType.PRE_SAVE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                    abstractProject.fireEvent(ProjectEventType.PRE_SAVE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                    abstractProject.getProjectMountingManger().l();
                    abstractProject.updateTreeBeforeSave((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                    try {
                        abstractProject.beforeSaveForProxyService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                    }
                    catch (IOException iOException) {
                        throw new PersistenceException((Throwable)iOException);
                    }
                    abstractProject.fireCallBackEvent((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100), CallbackEventType.SAVE_LATEST_VERSION);
                    abstractProject.doSave(string, map, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
                }
                set2 = iSaveExecutor.getOtherSavedProjects(Collections.unmodifiableSet(set), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                if (set2 != null && !set2.isEmpty()) {
                    if (!Collections.disjoint(set2, set)) {
                        throw new IllegalArgumentException("ISaveExecutor#getOtherSavedProjects returned set that contains projects from provided set of currently being saved projects");
                    }
                    set.addAll(set2);
                    continue;
                }
                bl = true;
            } while (!bl);
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public i getProjectMountingManger() {
        return (i)this.getService(com.nomagic.ci.persistence.local.internal.f.d.class);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executePostSaveRoutines(Set<IProject> var1_1, boolean var2_2, IProgressMonitor var3_3) throws PersistenceException {
        block7: {
            block8: {
                var4_4 = false;
                var3_3.beginTask("", var1_1.size() * 100 + 10);
                if (!var2_2) break block8;
                var6_5 = var1_1.iterator();
                if (true) ** GOTO lbl17
            }
            finally {
                if (var4_4) break block7;
                var10_10 = var1_1.iterator();
                if (true) ** GOTO lbl24
            }
            do {
                var5_6 = var6_5.next();
                var7_7 = (AbstractProject)var5_6;
                var7_7.fireEvent(ProjectEventType.POST_SAVE, (IProgressMonitor)new SubProgressMonitor(var3_3, 100));
lbl17:
                // 2 sources

            } while (var6_5.hasNext());
            var4_4 = true;
            do {
                var9_12 = var10_10.next();
                var11_14 = (AbstractProject)var9_12;
                var11_14.fireEvent(ProjectEventType.FAILED_SAVE, (IProgressMonitor)new SubProgressMonitor(var3_3, 100));
lbl24:
                // 2 sources

            } while (var10_10.hasNext());
        }
        var3_3.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateTreeBeforeSave(IProgressMonitor iProgressMonitor) throws PersistenceException {
        try {
            iProgressMonitor.beginTask("Updating required projects...", 1000);
            IPrimaryProjectInternal iPrimaryProjectInternal = (IPrimaryProjectInternal)ProjectUtil.getPrimaryProject((IProject)this);
            LocalProjectOptions localProjectOptions = LocalProjectOptions.adapt(iPrimaryProjectInternal.getOptions());
            if (!localProjectOptions.isTreeUpdatedBeforeSave()) {
                return;
            }
            LinkedHashSet<IProject> linkedHashSet = new LinkedHashSet<IProject>(com.nomagic.ci.persistence.local.internal.m.b.b(Collections.singleton(this)));
            if (this.canUpdate()) {
                linkedHashSet.add(this);
            }
            if (linkedHashSet.isEmpty()) {
                return;
            }
            Object object = linkedHashSet.iterator();
            while (object.hasNext()) {
                AbstractProject abstractProject = (AbstractProject)object.next();
                if (!abstractProject.isUpToDate()) continue;
                object.remove();
            }
            if (linkedHashSet.isEmpty()) {
                return;
            }
            object = com.nomagic.ci.persistence.local.internal.m.b.a(linkedHashSet, false);
            com.nomagic.ci.persistence.local.internal.m.b.a((Set<IProject>)object, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected abstract ISaveExecutor createSaveExecutor(String var1, Map<String, Object> var2) throws PersistenceException;

    private void beforeSaveForProxyService(IProgressMonitor iProgressMonitor) throws IOException {
        g g2 = (g)this.getService(LocalProxyService.class);
        if (g2 != null) {
            g2.a(iProgressMonitor);
        }
    }

    private void afterSaveForProxyService(IProgressMonitor iProgressMonitor) throws IOException {
        block3: {
            block2: {
                g g2 = (g)this.getService(LocalProxyService.class);
                if (g2 == null) break block2;
                g2.d(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    private void afterSaveForBinaryService(IProgressMonitor iProgressMonitor) {
        block3: {
            block2: {
                IBinarySynchronizationService iBinarySynchronizationService = this.getService(IBinarySynchronizationService.class);
                if (iBinarySynchronizationService == null) break block2;
                iBinarySynchronizationService.beforeCommit(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    private void beforeUpdateForBinaryService(IProgressMonitor iProgressMonitor) {
        block3: {
            block2: {
                IBinarySynchronizationService iBinarySynchronizationService = this.getService(IBinarySynchronizationService.class);
                if (iBinarySynchronizationService == null) break block2;
                iBinarySynchronizationService.beforeUpdate(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    private void publishProjectSaveDependencies(IProgressMonitor iProgressMonitor) {
        b b2 = (b)this.getService(IProjectDependenciesPublisher.class);
        if (b2 != null) {
            b2.a(SubscriptionType.PROJECT_SAVE, iProgressMonitor);
        }
        ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl(this, PROJECT_SAVE_DEPENDENCIES_PUBLISHED_EVENT_TYPE, null);
        this.serviceBusSupport.fireEvent(serviceBusEventImpl);
    }

    private void checkPersonalReferences(IProgressMonitor iProgressMonitor) {
        com.nomagic.ci.persistence.local.internal.h.b.a((IProject)this, iProgressMonitor);
    }

    protected void doSave(String string, Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Saving project...", 1700);
        try {
            try {
                this.doSaveFeatureResources(map, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
                this.publishProjectSaveDependencies((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
                this.checkPersonalReferences((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
                this.doSaveServiceResources(map, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
                this.afterSaveForProxyService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
                this.afterSaveForBinaryService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                this.updateCIVersionInDecomposition();
                this.doSaveDecomposition(map, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            catch (IOException iOException) {
                throw new PersistenceException((Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void updateCIVersionInDecomposition() {
        IDecompositionModel iDecompositionModel = this.getService(IDecompositionModel.class);
        if (iDecompositionModel != null) {
            DecompositionVersionUtility.saveCurrentVersionToProjectProperties(iDecompositionModel.getDecompositionProject());
        }
    }

    protected abstract void doSaveFeatureResources(Map<String, Object> var1, IProgressMonitor var2) throws PersistenceException;

    protected abstract void doSaveServiceResources(Map<String, Object> var1, IProgressMonitor var2) throws PersistenceException;

    protected void doSaveDecomposition(Map<String, Object> map, IProgressMonitor iProgressMonitor) throws PersistenceException {
    }

    public final void update(IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.update(false, iProgressMonitor);
    }

    public final void update(boolean bl, IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkState(true);
        if (!this.canUpdate()) {
            throw new PersistenceException("This project can not be updated, reason: " + this.getCannotUpdateReason());
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = this.getListenerTicks();
        iProgressMonitor.beginTask("Updating projects...", n2 * 10);
        try {
            iProgressMonitor.worked(n2);
            iProgressMonitor.subTask("Calculating updated projects");
            Set<IProject> set = com.nomagic.ci.persistence.local.internal.m.b.a(Collections.singleton(this), bl);
            iProgressMonitor.worked(n2);
            if (!set.isEmpty()) {
                com.nomagic.ci.persistence.local.internal.m.b.a(set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2 * 8));
            }
            iProgressMonitor.subTask("Updating project flags");
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void internalBasicUpdate(ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (projectUpdateContext == null) {
            throw new IllegalArgumentException("update context can not be null");
        }
        if (!this.canUpdate()) {
            throw new IllegalStateException("This project can not be updated");
        }
        if (!projectUpdateContext.projectHasToBeUpdated(this)) {
            return;
        }
        if (projectUpdateContext.isProjectUpdated(this)) {
            return;
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Updating project " + this.getName() + "...", 1010);
        boolean bl = false;
        try {
            boolean bl2 = false;
            try {
                this.updating = true;
                this.fireEvent(ProjectEventType.PRE_UPDATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                projectUpdateContext.addUpdatedProject(this);
                this.beforeUpdateForBinaryService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                this.doUpdate(projectUpdateContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                this.getFeatureInitializer().update((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                this.intercept(this, IProjectInterceptor.ProjectInterceptorType.POST_UPDATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                bl2 = true;
            }
            finally {
                com.nomagic.ci.persistence.local.internal.f.a.d.a((IProject)this, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            this.fireEvent(ProjectEventType.POST_UPDATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            bl = true;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.fireEvent(ProjectEventType.FAILED_UPDATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
            }
            this.updating = false;
            iProgressMonitor.done();
            throw throwable;
        }
        if (!bl) {
            this.fireEvent(ProjectEventType.FAILED_UPDATE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
        }
        this.updating = false;
        iProgressMonitor.done();
    }

    public boolean isUpdating() {
        return this.updating;
    }

    protected void doUpdate(ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
        try {
            PreUpdateProjectState preUpdateProjectState = projectUpdateContext.getPreUpdateProjectState(this);
            if (preUpdateProjectState == null) {
                throw new PersistenceRuntimeException("The project " + this.getName() + " was not scheduled for an update.");
            }
            iProgressMonitor.beginTask("Updating project " + this.getName() + "...", 1700);
            this.beforeUpdateForProxyService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            List<ProjectFeatureResources> list = preUpdateProjectState.getFeatureResources();
            this.updateProjectSupport(projectUpdateContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 700));
            this.registerProjectInResourceAccessManager();
            this.updateFeatures(list, projectUpdateContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
            ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl(this, FEATURE_RESOURCES_UPDATED_EVENT_TYPE, null);
            this.serviceBusSupport.fireEvent(serviceBusEventImpl);
            this.updateAttachedProjects(projectUpdateContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
        }
        finally {
            this.afterUpdateForProxyService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            iProgressMonitor.done();
        }
    }

    protected void updateProjectSupport(ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
    }

    protected void updateFeatures(Collection<ProjectFeatureResources> collection, ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
    }

    protected void updateAttachedProjects(ProjectUpdateContext projectUpdateContext, IProgressMonitor iProgressMonitor) throws PersistenceException {
        try {
            iProgressMonitor.beginTask("", 1000);
            this.projectManager.updateAttachedProjects(projectUpdateContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
            IPrimaryProject iPrimaryProject = ProjectUtil.getPrimaryProject((IProject)this);
            IComplexOperationEventService iComplexOperationEventService = (IComplexOperationEventService)iPrimaryProject.getService(IComplexOperationEventService.class);
            IComplexOperationEvent iComplexOperationEvent = iComplexOperationEventService.getLastPreEvent();
            if (iComplexOperationEvent == null) {
                throw new IllegalStateException("Update outside a complex operation");
            }
            if (this.isNonNestedLoadOrUpdate(iComplexOperationEvent)) {
                com.nomagic.ci.persistence.local.internal.c.a.g g2 = (com.nomagic.ci.persistence.local.internal.c.a.g)iPrimaryProject.getService(com.nomagic.ci.persistence.local.internal.c.a.g.class);
                g2.a((IProject)this, projectUpdateContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
            } else {
                iProgressMonitor.worked(800);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isNonNestedLoadOrUpdate(IComplexOperationEvent iComplexOperationEvent) {
        if (!this.isLoadOrUpdate(iComplexOperationEvent)) {
            return false;
        }
        if (iComplexOperationEvent.getParent() == null) {
            return true;
        }
        IComplexOperationEvent iComplexOperationEvent2 = iComplexOperationEvent.getParent();
        while (iComplexOperationEvent2 != null) {
            if (this.isLoadOrUpdate(iComplexOperationEvent2)) {
                return false;
            }
            iComplexOperationEvent2 = iComplexOperationEvent2.getParent();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isLoadOrUpdate(IComplexOperationEvent iComplexOperationEvent) {
        IComplexOperationEventType iComplexOperationEventType = iComplexOperationEvent.getEventType();
        return iComplexOperationEventType == ComplexOperationEventType.OPEN || iComplexOperationEventType == LocalComplexOperationEventType.LOAD || iComplexOperationEventType == ComplexOperationEventType.UPDATE;
    }

    public void importData(IProjectDataProvider iProjectDataProvider, IProgressMonitor iProgressMonitor) throws FeatureDependencyException, ProjectConfigurationException {
        this.getFeatureInitializer().importFeatures(iProjectDataProvider, false, iProgressMonitor);
    }

    public void loadFeatures(IProgressMonitor iProgressMonitor) throws IOException {
        this.getFeatureInitializer().read(false, iProgressMonitor);
    }

    public void loadAttachedProjects(IProgressMonitor iProgressMonitor) throws PersistenceException {
        try {
            iProgressMonitor.beginTask("", 1000);
            this.projectManager.loadManualAndLoadableAttachedProjects(iProgressMonitor);
            IPrimaryProject iPrimaryProject = ProjectUtil.getPrimaryProject((IProject)this);
            IComplexOperationEventService iComplexOperationEventService = (IComplexOperationEventService)iPrimaryProject.getService(IComplexOperationEventService.class);
            IComplexOperationEvent iComplexOperationEvent = iComplexOperationEventService.getLastPreEvent();
            if (iComplexOperationEvent == null) {
                throw new IllegalStateException("Load outside a complex operation");
            }
            if (this.isNonNestedLoadOrUpdate(iComplexOperationEvent)) {
                com.nomagic.ci.persistence.local.internal.c.a.g g2 = (com.nomagic.ci.persistence.local.internal.c.a.g)iPrimaryProject.getService(com.nomagic.ci.persistence.local.internal.c.a.g.class);
                g2.a(this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
            } else {
                iProgressMonitor.worked(800);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void unloadAttachedProjects(IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.projectManager.unloadAttachedProjects(iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dropFeatures(IProgressMonitor iProgressMonitor) {
        ArrayList arrayList = new ArrayList(this.featureRegistry.getFeatures());
        for (IProjectFeature iProjectFeature : arrayList) {
            this.featureRegistry.removeFeature(iProjectFeature);
        }
    }

    public ILocalProjectResourceManager getFeatureResourceManager(IProjectFeatureDescriptor iProjectFeatureDescriptor, FeatureResourceFilter ... featureResourceFilterArray) {
        return new F((IProject)this, iProjectFeatureDescriptor, featureResourceFilterArray);
    }

    public FeatureDataManager getFeatureDataManager(IProjectFeatureDescriptor iProjectFeatureDescriptor, FeatureDataSetFilter ... featureDataSetFilterArray) {
        return new F((IProject)this, iProjectFeatureDescriptor, featureDataSetFilterArray);
    }

    public final URI getServiceResourceURI(IProjectServiceDescriptor iProjectServiceDescriptor, String string) {
        return this.uriMapper.getResourceURI(iProjectServiceDescriptor.getNamespace(), string);
    }

    public IProjectRepository getProjectRepository() {
        return this.projectRepository;
    }

    public String getProjectID() {
        if (!this.decompositionModel.isAvailable()) {
            throw new IllegalStateException("Decomposition model not loaded");
        }
        return this.decompositionModel.getDecompositionProject().getId();
    }

    @Override
    @CheckForNull
    public URI getLoadedFrom() {
        URI uRI = this.isNew() ? null : this.getLocationURI();
        return uRI;
    }

    public String getName() {
        if (!this.decompositionModel.isAvailable()) {
            throw new IllegalStateException("Decomposition model not loaded");
        }
        return this.decompositionModel.getDecompositionProject().getName();
    }

    public void setName(String string) {
        if (!this.decompositionModel.isAvailable()) {
            throw new IllegalStateException("Decomposition model not loaded");
        }
        this.decompositionModel.getDecompositionProject().setName(string);
    }

    public String getDescription() {
        if (!this.decompositionModel.isAvailable()) {
            throw new IllegalStateException("Decomposition model not loaded");
        }
        return this.decompositionModel.getDecompositionProject().getDescription();
    }

    public void setDescription(String string) {
        if (!this.decompositionModel.isAvailable()) {
            throw new IllegalStateException("Decomposition model not loaded");
        }
        this.decompositionModel.getDecompositionProject().setDescription(string);
    }

    public Collection<Resource> getManagedResources() {
        IDataSectionManager iDataSectionManager = this.getService(IDataSectionManager.class);
        if (iDataSectionManager == null) {
            throw new IllegalStateException("Feature decomposition management not installed");
        }
        return iDataSectionManager.getResources();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Resource> getFeatureResources(IProjectFeatureDescriptor iProjectFeatureDescriptor) {
        List<Resource> list = Collections.emptyList();
        for (Resource resource : this.getManagedResources()) {
            ResourceInfo resourceInfo = this.uriMapper.getResourceInfo(resource.getURI());
            if (resourceInfo == null || !resourceInfo.getNamespace().equals(iProjectFeatureDescriptor.getNamespace())) continue;
            if (list.isEmpty()) {
                list = new ArrayList<Resource>();
            }
            list.add(resource);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Collection<Resource> getServiceResources() {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (IProjectServiceDescriptor iProjectServiceDescriptor : this.getPersistableServices()) {
            ILocalProjectResourceManager iLocalProjectResourceManager = ServiceResourceManagerFactory.getResourceManager(this, iProjectServiceDescriptor);
            for (String string : iLocalProjectResourceManager.getResourceNames()) {
                Resource resource = iLocalProjectResourceManager.getResource(string, false);
                if (resource == null) continue;
                arrayList.add(resource);
            }
        }
        return arrayList;
    }

    public abstract Collection<ResourceInfo> getProjectResources();

    public <T extends IProjectFeature> T getFeature(Class<T> clazz) {
        return (T)this.featureRegistry.getFeature(clazz);
    }

    public IProjectFeature getFeature(String string) {
        return this.featureRegistry.getFeature(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<String> getInstalledFeatures() {
        Set<String> set = Collections.emptySet();
        List<ProjectFeatureResources> list = this.getFeatureInitializer().getFeatureResources();
        if (!list.isEmpty()) {
            set = new HashSet<String>();
            for (ProjectFeatureResources projectFeatureResources : list) {
                set.add(projectFeatureResources.getFeature().getName());
            }
        }
        return set;
    }

    @CheckForNull
    public ILocalResourceDescriptor getResourceDescriptor(Resource resource) {
        IDataSectionManager iDataSectionManager = this.getService(IDataSectionManager.class);
        LocalDataSection localDataSection = (LocalDataSection)iDataSectionManager.getSection(resource);
        if (localDataSection != null) {
            IProjectFeatureDescriptor iProjectFeatureDescriptor = AbstractFeatureInitializer.getDescriptor((ProjectFeature)localDataSection.getFeaturedBy());
            return new M(iProjectFeatureDescriptor, localDataSection);
        }
        return null;
    }

    @Override
    public Set<IProjectServiceDescriptor> getPersistableServices() {
        return this.projectServices.getPersistableServices();
    }

    public List<ProjectFeatureResources> getFeatureResources() {
        return this.getFeatureInitializer().getFeatureResources();
    }

    public List<IProject> getAttachedProjects() {
        return this.projectManager.getAvailableAttachedProjects();
    }

    public static IProjectFeatureHandler getFeatureHandler(String string) {
        IProjectFeatureHandlerService iProjectFeatureHandlerService = (IProjectFeatureHandlerService)SingletonServiceRegistry.INSTANCE.getService(IProjectFeatureHandlerService.class);
        return iProjectFeatureHandlerService.getHandler(string);
    }

    public <T> T getService(Class<T> clazz) {
        return this.projectServices.a(clazz);
    }

    public <T> void registerProjectService(Class<T> clazz, T t2) {
        T t3 = this.projectServices.a(clazz, t2);
        ServiceNewAndOldValue serviceNewAndOldValue = new ServiceNewAndOldValue(t2, t3);
        ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl(this, SERVICE_REGISTERED_EVENT_TYPE, serviceNewAndOldValue);
        this.getServiceBusSupport().fireEvent(serviceBusEventImpl);
    }

    public <T> void registerService(Class<T> clazz, T t2) {
        this.registerProjectService(clazz, t2);
    }

    public <T> void registerGlobalService(Class<T> clazz, T t2) {
        this.globalServices.a(clazz, t2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setState(boolean var1_1) {
        block7: {
            if (this.projectAvailable == var1_1) return;
            if (AbstractProject.LOGGER.isDebugEnabled()) {
                AbstractProject.LOGGER.debug((Object)("Project " + this.getLocationURI() + "changing state to " + var1_1));
            }
            this.projectAvailable = var1_1;
            if (!var1_1) break block7;
            var3_2 = this.globalServices.a().iterator();
            if (true) ** GOTO lbl16
        }
        var3_3 = this.globalServices.b().iterator();
        if (true) ** GOTO lbl23
        do {
            var2_4 = var3_2.next();
            AbstractProject.LOGGER.debug((Object)("Service is registering " + var2_4.getName()));
            ServicesRegistry.INSTANCE.register(var2_4.getName(), this.globalServices.a(var2_4));
            AbstractProject.LOGGER.debug((Object)("Service is registered " + var2_4.getName()));
lbl16:
            // 2 sources

        } while (var3_2.hasNext());
        return;
        do {
            var2_5 = var3_3.next();
            AbstractProject.LOGGER.debug((Object)("Service is unregistering " + var2_5));
            ServicesRegistry.INSTANCE.unregister(var2_5);
            AbstractProject.LOGGER.debug((Object)("Service is unregistered " + var2_5));
lbl23:
            // 2 sources

        } while (var3_3.hasNext());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkState(boolean bl) {
        String string;
        if (this.isProjectAvailable() == bl) return;
        LOGGER.debug((Object)("Project with " + this.getLocationURI() + "is not loaded"));
        StringBuilder stringBuilder = new StringBuilder("Project is ");
        if (bl) {
            string = "not ";
            throw new IllegalStateException(stringBuilder.append(string).append(" opened/loaded").toString());
        }
        string = "already ";
        throw new IllegalStateException(stringBuilder.append(string).append(" opened/loaded").toString());
    }

    @Override
    public boolean isProjectAvailable() {
        return this.projectAvailable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public String getCannotUpdateReason() {
        if (!this.isProjectAvailable()) {
            return "the project is not open/loaded";
        }
        if (this.isNew()) {
            return "the project is new";
        }
        if (Versioning.isHistorical((IProject)this)) {
            return "the project is historical";
        }
        return null;
    }

    public boolean canUpdate() {
        if (this.getCannotUpdateReason() == null) {
            return true;
        }
        return false;
    }

    public boolean isUpToDate() {
        IUpdateAdvisor iUpdateAdvisor = this.getService(IUpdateAdvisor.class);
        boolean bl = iUpdateAdvisor != null ? iUpdateAdvisor.isUpToDate() : false;
        return bl;
    }

    private void checkCanSave() {
        if (!this.isProjectAvailable()) {
            throw new IllegalStateException("The project is not loaded");
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException("The project is read-only");
        }
        if (Versioning.isHistorical((IProject)this)) {
            throw new IllegalStateException("Project is not latest version");
        }
    }

    public ServiceBusSupportImpl getProjectServiceEventBus() {
        return this.serviceBusSupport;
    }

    public IProjectAccessModeController getAccessModeController() {
        return this.accessController;
    }

    public final void rollback(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = this.getListenerTicks();
        boolean bl = false;
        HashSet<IProject> hashSet = new HashSet<IProject>(Collections.singletonList(this));
        try {
            MultiProjectEventImpl multiProjectEventImpl;
            boolean bl2 = false;
            try {
                iProgressMonitor.beginTask("Rolling-back changes...", 1100 + n2 * 2);
                multiProjectEventImpl = new MultiProjectEventImpl(ProjectEventType.PRE_ROLLBACK_PROJECTS, (IProject)this, Collections.unmodifiableSet(hashSet));
                this.fireEvent((ProjectEvent)multiProjectEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                this.rollbackProjects(hashSet, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                bl2 = true;
            }
            finally {
                com.nomagic.ci.persistence.local.internal.f.a.d.a((IProject)this, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
            multiProjectEventImpl = new MultiProjectEventImpl(ProjectEventType.POST_ROLLBACK_PROJECTS, (IProject)this, hashSet);
            this.fireEvent((ProjectEvent)multiProjectEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
        }
        finally {
            try {
                if (!bl) {
                    MultiProjectEventImpl multiProjectEventImpl = new MultiProjectEventImpl(ProjectEventType.FAILED_ROLLBACK_PROJECTS, (IProject)this, hashSet);
                    this.fireEvent((ProjectEvent)multiProjectEventImpl, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rollbackProjects(Set<IProject> var1_1, IProgressMonitor var2_2) throws PersistenceException {
        try {
            block18: {
                var2_2.beginTask("", 1000);
                var2_2.subTask("Collecting projects to roll-back");
                var3_3 = this.createRollbackExecutor();
                if (var3_3 == null) {
                    throw new IllegalArgumentException("null IRollbackExecutor");
                }
                var4_4 = var3_3.getOtherRolledBackProjects();
                if (var4_4 != null && !var4_4.isEmpty()) {
                    if (var4_4.contains(this)) {
                        throw new IllegalArgumentException("Other rolled-back projects set contains the context project");
                    }
                    var1_1.addAll(var4_4);
                }
                var2_2.worked(200);
                var2_2.subTask("Executing roll-back");
                var5_5 = false;
                try {
                    for (IProject var6_7 : var1_1) {
                        var8_8 = (AbstractProject)var6_7;
                        var8_8.fireEvent(ProjectEventType.PRE_ROLLBACK, var8_8);
                    }
                    var2_2.worked(100);
                    var3_3.executeRollback((IProgressMonitor)new SubProgressMonitor(var2_2, 600));
                    for (IProject var6_7 : var1_1) {
                        var8_8 = (AbstractProject)var6_7;
                        var8_8.fireEvent(ProjectEventType.POST_ROLLBACK, var8_8);
                    }
                    var5_5 = true;
                }
                finally {
                    if (var5_5) break block18;
                    ** for (var10_13 : var1_1)
                }
lbl-1000:
                // 1 sources

                {
                    var12_15 = (AbstractProject)var10_13;
                    var12_15.fireEvent(ProjectEventType.FAILED_ROLLBACK, var12_15);
                    continue;
                }
            }
            var2_2.worked(100);
            return;
        }
        finally {
            var2_2.done();
        }
    }

    protected abstract IRollbackExecutor createRollbackExecutor() throws PersistenceException;

    public final boolean isNew() {
        return this.isNew;
    }

    public final void setNew(boolean bl) {
        this.isNew = bl;
    }

    public boolean isReadOnly() {
        return this.accessController.isReadOnly();
    }

    public void addProjectListener(ProjectListener projectListener) {
        Objects.requireNonNull(projectListener, "project listener cannot be null");
        this.projectEventSupport.addListener(projectListener);
    }

    @Deprecated
    public void addListenerInEnd(ProjectListener projectListener) {
        this.projectEventSupport.addListenerInEnd(projectListener);
    }

    @Deprecated
    public void addListenerInFront(ProjectListener projectListener) {
        this.projectEventSupport.addListenerInFront(projectListener);
    }

    public void removeProjectListener(ProjectListener projectListener) {
        this.projectEventSupport.removeListener(projectListener);
    }

    public List<ProjectListener> getProjectListeners() {
        return this.projectEventSupport.getListeners();
    }

    public void fireEvent(ProjectEventType projectEventType, IProgressMonitor iProgressMonitor) {
        this.fireEvent(projectEventType, this, iProgressMonitor);
    }

    protected void fireEventLifeCycleEvent(ProjectEventType projectEventType, IProject iProject, IProgressMonitor iProgressMonitor) {
        ProjectEventImpl projectEventImpl = new ProjectEventImpl(projectEventType, iProject);
        this.fireEvent((ProjectEvent)projectEventImpl, iProgressMonitor);
    }

    protected void fireEvent(ProjectEventType projectEventType, IProject iProject, IProgressMonitor iProgressMonitor) {
        ProjectEventImpl projectEventImpl = new ProjectEventImpl(projectEventType, iProject);
        this.fireEvent((ProjectEvent)projectEventImpl, iProgressMonitor);
    }

    protected void fireEvent(ProjectEventType projectEventType, IProject iProject) {
        ProjectEventImpl projectEventImpl = new ProjectEventImpl(projectEventType, iProject);
        this.projectEventSupport.fireEvent(projectEventImpl);
    }

    @Override
    public void fireEvent(ProjectEvent projectEvent, IProgressMonitor iProgressMonitor) {
        this.projectEventSupport.fireEvent(projectEvent, iProgressMonitor);
    }

    @Override
    public int getListenerTicks() {
        int n2 = this.projectEventSupport.getListenerCount();
        if (n2 == 0) {
            n2 = 1;
        }
        return n2 * 100;
    }

    public int getListenerCount() {
        return this.projectEventSupport.getListenerCount();
    }

    @Override
    public void addProjectInterceptor(IProjectInterceptor iProjectInterceptor, IProjectInterceptor.ProjectInterceptorType projectInterceptorType) {
        this.projectInterceptorController.addInterceptor(iProjectInterceptor, projectInterceptorType);
    }

    protected void intercept(IProject iProject, IProjectInterceptor.ProjectInterceptorType projectInterceptorType, IProgressMonitor iProgressMonitor) {
        this.projectInterceptorController.intercept(iProject, projectInterceptorType, iProgressMonitor);
    }

    @Override
    public void close(IProgressMonitor iProgressMonitor) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateMountedSharePoints(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("", 1100);
            if (this instanceof IAttachedProject) {
                com.nomagic.ci.persistence.local.internal.f.a.d.a((IAttachedProject)this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            } else {
                iProgressMonitor.worked(100);
            }
            IReverseProjectUsageManager iReverseProjectUsageManager = this.getService(IReverseProjectUsageManager.class);
            Set<IProject> set = iReverseProjectUsageManager.getUsedBy();
            if (set.isEmpty()) return;
            int n2 = 1000 / set.size();
            IProject iProject = null;
            if (this instanceof AbstractAttachedProject) {
                iProject = ((AbstractAttachedProject)this).getEffectivelyMountingProject();
            }
            if (iProject != null && ((AbstractProject)iProject).isProjectAvailable()) {
                com.nomagic.ci.persistence.local.internal.f.d d2 = (com.nomagic.ci.persistence.local.internal.f.d)iProject.getService(com.nomagic.ci.persistence.local.internal.f.d.class);
                d2.a(this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            }
            for (com.nomagic.ci.persistence.local.internal.f.d d2 : set) {
                if (iProject != null && d2 != iProject && ((AbstractProject)((Object)d2)).isProjectAvailable()) {
                    com.nomagic.ci.persistence.local.internal.f.d d3 = (com.nomagic.ci.persistence.local.internal.f.d)d2.getService(com.nomagic.ci.persistence.local.internal.f.d.class);
                    d3.a(this, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                    continue;
                }
                iProgressMonitor.worked(n2);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public ProjectDescriptor getProjectDescriptor() {
        try {
            IProjectRepository iProjectRepository = this.getProjectRepository();
            URI uRI = this.getLocationURI();
            return iProjectRepository.getProjectDescriptor(uRI, null);
        }
        catch (PersistenceException persistenceException) {
            throw new PersistenceRuntimeException(persistenceException.getMessage(), (Throwable)persistenceException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isObjectValid(EObject eObject, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("", 100);
            if (eObject == null) {
                throw new IllegalArgumentException("Object is null");
            }
            InternalEObject internalEObject = (InternalEObject)eObject;
            HashSet<InternalEObject> hashSet = new HashSet<InternalEObject>();
            while (internalEObject.eDirectResource() == null && internalEObject.eContainer() != null) {
                if (hashSet.contains(internalEObject)) break;
                hashSet.add(internalEObject);
                internalEObject = (InternalEObject)internalEObject.eContainer();
            }
            Resource.Internal internal = internalEObject.eDirectResource();
            if (internal == null) return false;
            if (!internal.getContents().contains((Object)internalEObject)) {
                return false;
            }
            boolean bl = LocalProjectUtil.getProject((Resource)internal) == this;
            return bl;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    public void addProjectCallbackListener(ProjectCallbackListener projectCallbackListener) {
        this.callbackSupport.addListener(projectCallbackListener);
    }

    @Override
    public void removeCallbackListener(ProjectCallbackListener projectCallbackListener) {
        this.callbackSupport.removeListener(projectCallbackListener);
    }

    @Override
    public void fireCallBackEvent(IProgressMonitor iProgressMonitor, CallbackEventType callbackEventType) {
        ProjectCallbackEventImpl projectCallbackEventImpl = new ProjectCallbackEventImpl(this, callbackEventType);
        this.fireCallBackEvent(iProgressMonitor, projectCallbackEventImpl);
    }

    @Override
    public void fireCallBackEvent(IProgressMonitor iProgressMonitor, ProjectCallbackEvent projectCallbackEvent) {
        this.callbackSupport.fireEvent(projectCallbackEvent, iProgressMonitor);
    }

    @Override
    public ServiceBusSupport getServiceBusSupport() {
        return this.serviceBusSupport;
    }

    public static enum CannotUpdateReason {
        NotAvailable,
        New,
        Historical;

    }
}

