/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.event.EventSupport;
import com.nomagic.ci.event.EventWithProgress;
import com.nomagic.ci.event.Listener;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.IProjectResourceProvider;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.ProjectEventType;
import com.nomagic.ci.persistence.ProjectOptions;
import com.nomagic.ci.persistence.local.decomposition.ProjectStructureEditorSimulator;
import com.nomagic.ci.persistence.local.internal.I;
import com.nomagic.ci.persistence.local.internal.K;
import com.nomagic.ci.persistence.local.internal.V;
import com.nomagic.ci.persistence.local.internal.c.a.g;
import com.nomagic.ci.persistence.local.internal.c.a.i;
import com.nomagic.ci.persistence.local.internal.d.f;
import com.nomagic.ci.persistence.local.internal.f.a.d;
import com.nomagic.ci.persistence.local.internal.f.c;
import com.nomagic.ci.persistence.local.internal.f.v;
import com.nomagic.ci.persistence.local.internal.l.a;
import com.nomagic.ci.persistence.local.internal.u;
import com.nomagic.ci.persistence.local.internal.y;
import com.nomagic.ci.persistence.local.mounting.IPrimaryProjectMountingService;
import com.nomagic.ci.persistence.local.partitioning.DirtyResourceSupportService;
import com.nomagic.ci.persistence.local.runtimelock.RuntimeLockService;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IPrimaryProjectInternal;
import com.nomagic.ci.persistence.local.spi.IProjectConfigurator;
import com.nomagic.ci.persistence.local.spi.IProjectInternal;
import com.nomagic.ci.persistence.local.spi.ProjectDecompositionManager;
import com.nomagic.ci.persistence.local.spi.decomposition.ProjectStructureEditorSimulatorImpl;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventType;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventTypeImpl;
import com.nomagic.ci.persistence.local.spi.interceptor.IProjectInterceptor;
import com.nomagic.ci.persistence.local.spi.mounting.MasterProjectStructureManager;
import com.nomagic.ci.persistence.local.spi.sharing.IAutomaticProjectResharingConfiguratorService;
import com.nomagic.ci.persistence.local.spi.util.EPackageEObjectService;
import com.nomagic.ci.persistence.local.spi.util.EPackageEObjectServiceImpl;
import com.nomagic.ci.persistence.spi.decomposition.AttachedProjectRemoveService;
import com.nomagic.ci.persistence.spi.decomposition.IAttachedProjectRemover;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.spi.events.CustomComplexOperationEventDeliveryService;
import com.nomagic.ci.persistence.spi.events.IComplexOperationEventService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class AbstractPrimaryProject
extends AbstractProject
implements IPrimaryProjectInternal {
    public static final ServiceEventType PROJECTS_UPDATED_EVENT_TYPE = new ServiceEventTypeImpl("PROJECTS_UPDATED ", AbstractPrimaryProject.class);
    private List<IAttachedProject> projects = new ArrayList<IAttachedProject>();
    private y resourceAccessManager;
    private ProjectOptions options;
    private boolean opening = false;
    private EventSupport<Listener<EventWithProgress>, EventWithProgress> eventSupport = new EventSupport();

    public AbstractPrimaryProject(IProjectRepository iProjectRepository, boolean bl, ResourceSet resourceSet, ProjectOptions projectOptions, IProjectConfigurator iProjectConfigurator) throws ProjectConfigurationException {
        super(iProjectRepository, bl, iProjectConfigurator);
        this.options = projectOptions;
        if (resourceSet instanceof V) {
            this.resourceAccessManager = ((V)resourceSet).a();
        }
        this.setResourceSet(resourceSet);
        if (Boolean.getBoolean("ci.dirtyflag.enable")) {
            this.registerProjectService(DirtyResourceSupportService.class, new com.nomagic.ci.persistence.local.internal.g.a(this));
        }
        this.initGlobalServices();
        this.initRuntimeLockService();
        this.initComplexOperationEventSupport();
        this.initProjectDecompositionManagement();
        this.initAutomaticProjectResharingConfigurator();
        this.initPrimaryMountingSuport();
        this.initProjectRemoverService();
        this.initAttachedProjectStateManager();
        this.initProjectStructureEditorSimulator();
        IProjectUsageManager iProjectUsageManager = this.getService(IProjectUsageManager.class);
        if (iProjectUsageManager instanceof I) {
            ((I)iProjectUsageManager).a();
        }
    }

    protected void initProjectStructureEditorSimulator() {
        this.registerProjectService(ProjectStructureEditorSimulator.class, new ProjectStructureEditorSimulatorImpl(this));
    }

    protected void initRuntimeLockService() {
        com.nomagic.ci.persistence.local.internal.k.a a2 = new com.nomagic.ci.persistence.local.internal.k.a(this);
        this.registerProjectService(RuntimeLockService.class, a2);
    }

    @Override
    public y getResourceAccessManager() {
        if (this.resourceAccessManager == null) {
            this.resourceAccessManager = new K();
        }
        return this.resourceAccessManager;
    }

    protected void initProjectRemoverService() {
        AttachedProjectRemoveService attachedProjectRemoveService = this.getConfigurator().createAttachedProjectRemoveService(this);
        this.registerProjectService(IAttachedProjectRemover.class, attachedProjectRemoveService);
    }

    protected void initProjectDecompositionManagement() {
        ProjectDecompositionManager projectDecompositionManager = this.getConfigurator().createProjectDecompositionManager(this, this);
        this.registerProjectService(IProjectDecompositionManager.class, projectDecompositionManager);
        this.setProjectManager(projectDecompositionManager);
    }

    protected void initGlobalServices() {
        u u2 = new u(this);
        this.registerGlobalService(IProjectResourceProvider.class, u2);
    }

    protected void initAutomaticProjectResharingConfigurator() {
        this.registerProjectService(IAutomaticProjectResharingConfiguratorService.class, new a(this));
    }

    protected void initPrimaryMountingSuport() {
        v v2 = new v(this);
        this.registerProjectService(c.class, v2);
        this.registerProjectService(IPrimaryProjectMountingService.class, v2);
        MasterProjectStructureManager masterProjectStructureManager = this.getConfigurator().createMasterProjectStructureManager(this);
        this.registerProjectService(MasterProjectStructureManager.class, masterProjectStructureManager);
    }

    protected void initComplexOperationEventSupport() {
        f f2 = new f(this);
        this.registerProjectService(IComplexOperationEventService.class, f2);
        this.registerProjectService(CustomComplexOperationEventDeliveryService.class, f2);
    }

    protected void initAttachedProjectStateManager() {
        this.registerProjectService(g.class, new i(this));
    }

    public final void open(IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkState(false);
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        boolean bl = false;
        int n2 = this.getListenerTicks();
        int n3 = this.getListenerCount();
        try {
            boolean bl2 = false;
            try {
                this.opening = true;
                iProgressMonitor.beginTask("Opening project...", n2 * 8 + n3);
                this.fireEvent(ProjectEventType.PRE_OPEN, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                this.setState(true);
                this.doLoadInternal((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2 * 4));
                this.intercept(this, IProjectInterceptor.ProjectInterceptorType.POST_OPEN, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                bl2 = true;
            }
            catch (Throwable throwable) {
                if (!iProgressMonitor.isCanceled()) {
                    d.a((IProject)this, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                }
                throw throwable;
            }
            if (!iProgressMonitor.isCanceled()) {
                d.a((IProject)this, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            }
            this.fireEvent(ProjectEventType.POST_OPEN, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.fireEvent(ProjectEventType.FAILED_TO_OPEN, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            }
            this.opening = false;
            if (!bl) {
                this.setState(false);
            }
            iProgressMonitor.done();
            throw throwable;
        }
        if (!bl) {
            this.fireEvent(ProjectEventType.FAILED_TO_OPEN, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
        }
        this.opening = false;
        if (!bl) {
            this.setState(false);
        }
        iProgressMonitor.done();
    }

    public boolean isOpening() {
        return this.opening;
    }

    @Override
    public final void close(IProgressMonitor iProgressMonitor) {
        this.checkState(true);
        int n2 = this.getListenerTicks();
        int n3 = this.getListenerCount();
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Closing project", n2 * 10 + n3);
        try {
            try {
                this.fireEvent(ProjectEventType.PRE_CLOSE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                this.doClose((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2 * 8));
                this.getResourceAccessManager().b(this);
                this.fireEvent(ProjectEventType.POST_CLOSE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            }
            catch (Exception exception) {
                this.fireEvent(ProjectEventType.FAILED_CLOSE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
                throw new PersistenceRuntimeException(exception.getMessage(), (Throwable)exception);
            }
        }
        finally {
            this.setState(false);
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doClose(@Nonnull IProgressMonitor iProgressMonitor) {
        List<IAttachedProject> list = this.getProjects();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(list.size() * 100 + 20 + 40 + 20));
        try {
            for (IAttachedProject iAttachedProject : list) {
                ((IProjectInternal)iAttachedProject).close((IProgressMonitor)subMonitor.newChild(100));
            }
            subMonitor.worked(20);
            super.doClose((IProgressMonitor)subMonitor.newChild(40));
            subMonitor.worked(20);
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public boolean isClosed() {
        boolean bl = !this.isProjectAvailable();
        return bl;
    }

    public List<IAttachedProject> getProjects() {
        return Collections.unmodifiableList(this.projects);
    }

    @Override
    public synchronized void addAttachedProject(IAttachedProject iAttachedProject) {
        if (!this.projects.contains(iAttachedProject)) {
            this.projects.add(iAttachedProject);
        }
    }

    @Override
    public synchronized void removeAttachedProject(IAttachedProject iAttachedProject) {
        boolean bl = false;
        if (this.projects.contains(iAttachedProject)) {
            bl = this.projects.remove(iAttachedProject);
        }
    }

    @Override
    public ProjectOptions getOptions() {
        return this.options;
    }

    public EventSupport<Listener<EventWithProgress>, EventWithProgress> getEventSupport() {
        return this.eventSupport;
    }

    @Override
    protected void initEPackageEObjectService() {
        EPackageEObjectServiceImpl ePackageEObjectServiceImpl = new EPackageEObjectServiceImpl(this);
        this.registerProjectService(EPackageEObjectService.class, ePackageEObjectServiceImpl);
    }
}

