/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.metamodel.project.DataSection;
import com.nomagic.ci.metamodel.project.Project;
import com.nomagic.ci.metamodel.project.ProjectFeature;
import com.nomagic.ci.metamodel.project.ProjectUser;
import com.nomagic.ci.metamodel.project.UserPart;
import com.nomagic.ci.metamodel.project.util.DecompositionModelUtil;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.local.spi.IDataSectionManager;
import com.nomagic.ci.persistence.spi.decomposition.DecompositionModelFactory;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class AbstractDataSectionManager
implements IDataSectionManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractDataSectionManager.class.getName());
    protected Map<Resource, DataSection> cache = new HashMap<Resource, DataSection>();
    protected Map<DataSection, Resource> cache2 = new HashMap<DataSection, Resource>();
    protected IProject project;
    private final Adapter resourceSetAdapter;
    private final Adapter ownedSectionsAdapter;
    private EventSupport[] evenSupport;
    private DataSection beingCreatedSection = null;

    public AbstractDataSectionManager(IProject iProject) {
        this.project = iProject;
        this.resourceSetAdapter = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (!notification.isTouch() && notification.getEventType() != 7) {
                    Object object;
                    Object object2 = notification.getNewValue();
                    if (object2 instanceof Resource) {
                        object = (Resource)object2;
                        AbstractDataSectionManager.this.resourceAdded((Resource)object);
                    } else if (object2 instanceof List) {
                        object = (List)object2;
                        int n2 = 0;
                        while (n2 < object.size()) {
                            Resource resource = (Resource)object.get(n2);
                            AbstractDataSectionManager.this.resourceAdded(resource);
                            ++n2;
                        }
                    }
                    object = notification.getOldValue();
                    if (object instanceof Resource) {
                        Object object3 = object;
                        AbstractDataSectionManager.this.resourceRemoved((Resource)object3);
                    } else if (object instanceof List) {
                        List list = (List)object;
                        int n3 = 0;
                        while (n3 < list.size()) {
                            Resource resource = (Resource)list.get(n3);
                            AbstractDataSectionManager.this.resourceRemoved(resource);
                            ++n3;
                        }
                    }
                }
                super.notifyChanged(notification);
            }
        };
        final int n2 = this.getProjectOwnedSectionsFeatureId();
        this.ownedSectionsAdapter = new AdapterImpl(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void notifyChanged(Notification notification) {
                if (notification.getNotifier() instanceof Project) {
                    int n22 = notification.getFeatureID(Project.class);
                    if (n22 == n2 && !notification.isTouch() && notification.getEventType() != 7) {
                        if (notification.getOldValue() != null) {
                            if (notification.getOldValue() instanceof List) {
                                this.handleOlValueMulti((List)notification.getOldValue(), notification.getEventType());
                            } else {
                                this.handleOldValue(notification.getOldValue(), notification.getEventType());
                            }
                        }
                        if (notification.getNewValue() != null) {
                            if (notification.getNewValue() instanceof List) {
                                this.handleNewValueMulti((List)notification.getNewValue(), notification.getEventType());
                            } else {
                                this.handleNewValue(notification.getNewValue(), notification.getEventType());
                            }
                        }
                    }
                    super.notifyChanged(notification);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void handleNewValueMulti(List<?> list, int n22) {
                for (Object obj : list) {
                    this.handleNewValue(obj, n22);
                }
            }

            protected void handleNewValue(Object object, int n22) {
                switch (n22) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        AbstractDataSectionManager.this.sectionAdded(this.convertToDataSection(object));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void handleOlValueMulti(List<?> list, int n22) {
                for (Object obj : list) {
                    this.handleOldValue(obj, n22);
                }
            }

            protected void handleOldValue(Object object, int n22) {
                switch (n22) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: {
                        AbstractDataSectionManager.this.sectionRemoved(this.convertToDataSection(object));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }

            protected DataSection convertToDataSection(Object object) {
                if (object instanceof DataSection) {
                    DataSection dataSection = (DataSection)object;
                    return dataSection;
                }
                throw new IllegalArgumentException();
            }
        };
    }

    @CheckForNull
    private EventSupport getEventSupport() {
        if (this.evenSupport == null) {
            this.evenSupport = new EventSupport[1];
            this.evenSupport[0] = this.createEventSupport();
        }
        return this.evenSupport[0];
    }

    @Override
    public DataSection getSection(Resource resource) {
        return this.cache.get(resource);
    }

    @Override
    public Resource getResource(DataSection dataSection) {
        return this.cache2.get(dataSection);
    }

    @Override
    public Collection<Resource> getResources() {
        return new ArrayList<Resource>(this.cache.keySet());
    }

    private void sectionAdded(DataSection dataSection) {
        Resource resource = this.findResource(dataSection);
        if (resource != null) {
            this.cache.put(resource, dataSection);
            this.cache2.put(dataSection, resource);
            EventSupport eventSupport = this.getEventSupport();
            if (eventSupport != null) {
                eventSupport.postAddResource(resource);
            }
        }
    }

    private void sectionRemoved(DataSection dataSection) {
        Resource resource = this.cache2.get(dataSection);
        this.doRemoveSection(dataSection, resource);
    }

    private void doRemoveSection(DataSection dataSection, Resource resource) {
        if (resource != null) {
            EventSupport eventSupport = this.getEventSupport();
            if (eventSupport != null) {
                eventSupport.preRemoveResource(resource);
            }
            this.cache.remove(resource);
            this.cache2.remove(dataSection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resourceAdded(Resource resource) {
        IDecompositionModel iDecompositionModel = this.getDecomposition();
        if (!iDecompositionModel.isAvailable()) return;
        Project project = iDecompositionModel.getDecompositionProject();
        DataSection dataSection = this.findOrCreateSection(project, resource);
        if (dataSection == null) return;
        Resource resource2 = this.cache2.get(dataSection);
        if (resource2 == resource) return;
        if (resource2 != null) {
            LOGGER.warning("The resource " + resource2.getURI() + " is registered for " + dataSection.getName());
        }
        this.cache.put(resource, dataSection);
        this.cache2.put(dataSection, resource);
        EventSupport eventSupport = this.getEventSupport();
        if (eventSupport == null) return;
        eventSupport.postAddResource(resource);
    }

    protected IDecompositionModel getDecomposition() {
        IDecompositionModel iDecompositionModel = (IDecompositionModel)this.project.getService(IDecompositionModel.class);
        return iDecompositionModel;
    }

    @CheckForNull
    private DataSection findOrCreateSection(Project project, Resource resource) {
        DataSection dataSection = this.findDataSection(project, resource);
        if (dataSection == null) {
            dataSection = this.createDataSection(project, resource);
        }
        return dataSection;
    }

    private void resourceRemoved(Resource resource) {
        IDecompositionModel iDecompositionModel = this.getDecomposition();
        if (iDecompositionModel.isAvailable()) {
            DataSection dataSection = this.getSection(resource);
            if (dataSection != null) {
                URI uRI = resource.getURI();
                if (!this.project.getResourceSet().getURIConverter().exists(uRI, null)) {
                    EventSupport eventSupport = this.getEventSupport();
                    if (eventSupport != null) {
                        eventSupport.preRemoveResource(resource);
                    }
                    AbstractDataSectionManager.removeSection(dataSection);
                }
            }
            this.cache.remove(resource);
            this.cache2.remove(dataSection);
        }
    }

    public static void removeSection(DataSection dataSection) {
        dataSection.setProject(null);
        dataSection.setFeaturedBy(null);
        dataSection.setBelongsTo(null);
    }

    @Nonnull
    private DecompositionModelFactory getModelFactory() {
        DecompositionModelFactory decompositionModelFactory = (DecompositionModelFactory)this.project.getService(DecompositionModelFactory.class);
        if (decompositionModelFactory == null) {
            throw new ProjectConfigurationException("Decomposition model factory not available in project " + this.project);
        }
        return decompositionModelFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setEnabled(boolean bl) {
        Project project22;
        Notifier notifier;
        ResourceSet resourceSet = this.project.getResourceSet();
        this.cache.clear();
        this.cache2.clear();
        if (this.ownedSectionsAdapter.getTarget() != null) {
            notifier = this.ownedSectionsAdapter.getTarget();
            notifier.eAdapters().remove((Object)this.ownedSectionsAdapter);
            this.ownedSectionsAdapter.setTarget(null);
        }
        if (!bl) {
            resourceSet.eAdapters().remove((Object)this.resourceSetAdapter);
            return;
        }
        notifier = this.getDecomposition();
        if (notifier == null) throw new IllegalStateException("Decomposition model is not available");
        if (!notifier.isAvailable()) {
            throw new IllegalStateException("Decomposition model is not available");
        }
        EventSupport eventSupport = this.getEventSupport();
        if (eventSupport != null) {
            eventSupport.preSynchronizeResources();
        }
        for (Project project22 : resourceSet.getResources()) {
            this.resourceAdded((Resource)project22);
        }
        project22 = notifier.getDecompositionProject();
        project22.eAdapters().add((Object)this.ownedSectionsAdapter);
        this.ownedSectionsAdapter.setTarget((Notifier)project22);
        resourceSet.eAdapters().add((Object)this.resourceSetAdapter);
    }

    @CheckForNull
    protected DataSection doCreateDataSection(Project project, String string, @CheckForNull String string2, String string3) {
        DecompositionModelFactory decompositionModelFactory = this.getModelFactory();
        return AbstractDataSectionManager.doCreateDataSection(project, string, string2, string3, decompositionModelFactory);
    }

    @CheckForNull
    public static DataSection doCreateDataSection(Project project, String string, @CheckForNull String string2, String string3, DecompositionModelFactory decompositionModelFactory) {
        ProjectFeature projectFeature = DecompositionModelUtil.findProjectFeature((Project)project, (String)string);
        if (projectFeature != null) {
            DataSection dataSection = decompositionModelFactory.createDataSection();
            dataSection.setName(string3);
            EList eList = projectFeature.getSections();
            eList.add((Object)dataSection);
            if (string2 != null) {
                AbstractDataSectionManager.addToUserPart(project, string2, dataSection, decompositionModelFactory);
            }
            dataSection.setProject(project);
            return dataSection;
        }
        return null;
    }

    public static void addToUserPart(Project project, String string, DataSection dataSection, DecompositionModelFactory decompositionModelFactory) {
        UserPart userPart;
        ProjectUser projectUser = DecompositionModelUtil.findProjectUser((Project)project, (String)string);
        if (projectUser == null) {
            projectUser = decompositionModelFactory.createProjectUser();
            projectUser.setUserId(string);
            projectUser.setProject(project);
            userPart = decompositionModelFactory.createUserPart();
            userPart.setProject(project);
            userPart.setUser(projectUser);
        } else {
            userPart = DecompositionModelUtil.findUserPart((Project)project, (ProjectUser)projectUser);
        }
        EList eList = userPart.getSections();
        eList.add((Object)dataSection);
    }

    @CheckForNull
    protected DataSection doFindDataSection(Project project, String string, @CheckForNull String string2, String string3) {
        ProjectFeature projectFeature = DecompositionModelUtil.findProjectFeature((Project)project, (String)string);
        if (projectFeature == null) {
            return null;
        }
        if (string2 != null) {
            return DecompositionModelUtil.findPersonalSection((ProjectFeature)projectFeature, (String)string2, (String)string3);
        }
        return DecompositionModelUtil.findDataSection((ProjectFeature)projectFeature, (String)string3);
    }

    public IProject getProject() {
        return this.project;
    }

    @CheckForNull
    protected abstract DataSection createDataSection(Project var1, Resource var2);

    @CheckForNull
    protected abstract DataSection findDataSection(Project var1, Resource var2);

    @CheckForNull
    protected abstract Resource findResource(DataSection var1);

    protected abstract int getProjectOwnedSectionsFeatureId();

    @CheckForNull
    protected abstract EventSupport createEventSupport();

    protected static interface EventSupport {
        public void postAddResource(Resource var1);

        public void preRemoveResource(Resource var1);

        public void preSynchronizeResources();
    }
}

