/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi;

import com.nomagic.ci.metamodel.local.project.LocalProject;
import com.nomagic.ci.metamodel.local.project.ProjectPackage;
import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.metamodel.local.project.SharePoint;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.ProjectEventType;
import com.nomagic.ci.persistence.local.internal.U;
import com.nomagic.ci.persistence.local.internal.c.e;
import com.nomagic.ci.persistence.local.internal.d.f;
import com.nomagic.ci.persistence.local.internal.f.a.d;
import com.nomagic.ci.persistence.local.internal.l.c;
import com.nomagic.ci.persistence.local.internal.m.b;
import com.nomagic.ci.persistence.local.mounting.MountLocation;
import com.nomagic.ci.persistence.local.runtimelock.RuntimeLockService;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IAttachedProjectInternal;
import com.nomagic.ci.persistence.local.spi.IPrimaryProjectInternal;
import com.nomagic.ci.persistence.local.spi.IProjectConfigurator;
import com.nomagic.ci.persistence.local.spi.IProjectRepositoryInternal;
import com.nomagic.ci.persistence.local.spi.ProjectDecompositionManager;
import com.nomagic.ci.persistence.local.spi.ServiceNewAndOldValue;
import com.nomagic.ci.persistence.local.spi.binary.IBinarySynchronizationService;
import com.nomagic.ci.persistence.local.spi.decomposition.DecompositionModelService;
import com.nomagic.ci.persistence.local.spi.decomposition.LocalDecompositionModel;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusEventImpl;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventType;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventTypeImpl;
import com.nomagic.ci.persistence.mounting.IMountPoint;
import com.nomagic.ci.persistence.spi.IAttachedProjectStateService;
import com.nomagic.ci.persistence.spi.IAttachedProjectStateServiceInternal;
import com.nomagic.ci.persistence.spi.ProjectState;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.spi.events.IComplexOperationEventService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

public abstract class AbstractAttachedProject
extends AbstractProject
implements IAttachedProject,
IAttachedProjectInternal {
    private static final Logger LOGGER = Logger.getLogger(AbstractAttachedProject.class);
    public static final ServiceEventType PRIMARY_EVENT_TYPE = new ServiceEventTypeImpl("PRIMARY", AbstractAttachedProject.class);
    public static final ServiceEventType PROJECT_EXTRACTED_EVENT_TYPE = new ServiceEventTypeImpl("PROJECT_EXTRACTED", AbstractAttachedProject.class);
    private IPrimaryProjectInternal primary;
    private IProject effectivelyMountingProject;
    private Set<IMountPoint> mountPoints = Collections.emptySet();
    private c mountOptionsStore = new c();
    private Map<EObject, MountLocation> integrationPoints = new HashMap<EObject, MountLocation>();
    private Map<String, MountLocation> restorePoints = new HashMap<String, MountLocation>();
    private ProjectState projectState = ProjectState.Created;
    private boolean loading = false;
    private boolean unloading = false;
    private Boolean manuallyReachable = null;

    public AbstractAttachedProject(IProjectRepository iProjectRepository, boolean bl, IProjectConfigurator iProjectConfigurator) {
        super(iProjectRepository, bl, iProjectConfigurator);
        this.registerAttachedProjectStateService();
        this.accessController.addContributor(new U(this, this.serviceBusSupport, this.accessController));
        this.initManuallyReachableUpdater();
    }

    private void registerAttachedProjectStateService() {
        this.registerProjectService(IAttachedProjectStateService.class, new DefaultIAttachedProjectStateService());
    }

    protected abstract void initProxyService();

    @Override
    public void close(IProgressMonitor iProgressMonitor) {
        boolean bl = false;
        try {
            iProgressMonitor.beginTask("Closing attached project", 1010);
            this.fireEvent(ProjectEventType.PRE_CLOSE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            this.doClose((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
            this.fireEvent(ProjectEventType.POST_CLOSE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            bl = true;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.fireEvent(ProjectEventType.FAILED_CLOSE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
            }
            iProgressMonitor.done();
            throw throwable;
        }
        if (!bl) {
            this.fireEvent(ProjectEventType.FAILED_CLOSE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
        }
        iProgressMonitor.done();
    }

    public IPrimaryProject getPrimaryProject() {
        return this.primary;
    }

    protected void setPrimary(IPrimaryProjectInternal iPrimaryProjectInternal) {
        IPrimaryProjectInternal iPrimaryProjectInternal2 = this.primary;
        if (iPrimaryProjectInternal2 != null) {
            iPrimaryProjectInternal2.getResourceAccessManager().b(this);
            iPrimaryProjectInternal2.removeAttachedProject(this);
        }
        this.primary = iPrimaryProjectInternal;
        if (this.primary != null) {
            this.primary.addAttachedProject(this);
            this.primary.getResourceAccessManager().a(this);
        }
        ServiceNewAndOldValue serviceNewAndOldValue = new ServiceNewAndOldValue(iPrimaryProjectInternal, iPrimaryProjectInternal2);
        ServiceBusEventImpl serviceBusEventImpl = new ServiceBusEventImpl(this, PRIMARY_EVENT_TYPE, serviceNewAndOldValue);
        this.getServiceBusSupport().fireEvent(serviceBusEventImpl);
        if (this.primary != null) {
            this.initProjectDecompositionManagement();
            this.initProxyService();
            this.initComplexEventSupport();
        }
    }

    protected void initComplexEventSupport() {
        f f2 = (f)((Object)this.primary.getServiceOrFail(IComplexOperationEventService.class));
        f2.a(this);
    }

    protected void initProjectDecompositionManagement() {
        ProjectDecompositionManager projectDecompositionManager = this.getConfigurator().createProjectDecompositionManager(this.primary, this);
        this.registerProjectService(IProjectDecompositionManager.class, projectDecompositionManager);
        this.setProjectManager(projectDecompositionManager);
    }

    protected void initManuallyReachableUpdater() {
        this.registerProjectService(e.class, new com.nomagic.ci.persistence.local.internal.c.f(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canUpdate() {
        return this.canLoad() && super.canUpdate();
    }

    public boolean canLoad() {
        boolean bl = !this.isNew();
        return bl;
    }

    public final void load(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        this.checkState(false);
        if (!this.canLoad()) {
            throw new PersistenceException("This project can not be loaded");
        }
        int n2 = this.getListenerTicks();
        int n3 = this.getListenerCount();
        boolean bl = false;
        try {
            this.loading = true;
            boolean bl2 = false;
            try {
                iProgressMonitor.beginTask("Loading...", n2 * 11 + n3);
                this.fireEvent(ProjectEventType.PRE_LOAD, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
                this.internalLoad((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2 * 8));
                bl2 = true;
            }
            finally {
                d.a((IProject)this, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            }
            this.fireEvent(ProjectEventType.POST_LOAD, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            bl = true;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.fireEvent(ProjectEventType.FAILED_LOAD, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
            }
            this.loading = false;
            iProgressMonitor.done();
            throw throwable;
        }
        if (!bl) {
            this.fireEvent(ProjectEventType.FAILED_LOAD, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n3));
        }
        this.loading = false;
        iProgressMonitor.done();
    }

    public boolean isLoading() {
        return this.loading;
    }

    public boolean isUnloading() {
        return this.unloading;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalLoad(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        boolean bl = false;
        iProgressMonitor.beginTask("Loading project", 1400);
        ProjectState projectState = this.getProjectState();
        try {
            this.setState(true);
            this.setProjectState(ProjectState.Loaded);
            boolean bl2 = true;
            IPrimaryProject iPrimaryProject = this.getPrimaryProject();
            if (iPrimaryProject instanceof AbstractProject) {
                boolean bl3 = bl2 = !((AbstractProject)iPrimaryProject).isUpdating();
            }
            if (bl2) {
                this.updateProjectsBeforeLoad((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
            }
            this.doLoadInternal((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 600));
            bl = true;
            return;
        }
        finally {
            iProgressMonitor.done();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Loading is failed");
            }
            if (!bl) {
                this.setState(false);
                this.setProjectState(projectState);
            }
        }
    }

    @Override
    public void loadProjectSupport(IProgressMonitor iProgressMonitor) throws IOException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("Load project support...", 1000);
            this.cleanDecomposition((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
            super.loadProjectSupport((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void cleanDecomposition(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("Cleaning project...", 100);
            if (((IDecompositionModel)this.getServiceOrFail(IDecompositionModel.class)).isAvailable()) {
                this.unloadDecomposition((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canUnload() {
        return this.isLoaded() && !this.isNew();
    }

    private void assureCanUnload() {
        if (!this.canUnload()) {
            throw new RuntimeException("Project can not be unloaded: " + this);
        }
    }

    public final void unload(IProgressMonitor iProgressMonitor) throws PersistenceException {
        this.checkState(true);
        this.assureCanUnload();
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Unloading project: " + this.getName() + "...", 1300);
        boolean bl = false;
        try {
            try {
                this.unloading = true;
                this.fireEvent(ProjectEventType.PRE_UNLOAD, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                this.getRuntimeLockService().lock();
                try {
                    boolean bl2 = false;
                    try {
                        this.getProjectMountingManger().k();
                        this.beforeUnloadForProxyService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                        this.beforeUnloadForBinaryService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                        this.unloadAttachedProjects((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 450));
                        this.doUnload((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
                        this.loadShallow((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                        this.setState(false);
                        this.projectState = ProjectState.Unloaded;
                        this.updateManualReachabilytyAfterUnload((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                        this.afterUnloadForProxyService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                        bl2 = true;
                    }
                    finally {
                        d.a((IProject)this, bl2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                    }
                }
                finally {
                    this.getRuntimeLockService().unlock();
                }
                this.fireEvent(ProjectEventType.POST_UNLOAD, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                bl = true;
            }
            catch (IOException iOException) {
                throw new PersistenceException((Throwable)iOException);
            }
        }
        finally {
            try {
                if (!bl) {
                    this.fireEvent(ProjectEventType.FAILED_UNLOAD, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 50));
                }
            }
            finally {
                this.unloading = false;
            }
        }
    }

    protected void updateManualReachabilytyAfterUnload(IProgressMonitor iProgressMonitor) {
        try {
            iProgressMonitor.beginTask("", 100);
            e e2 = this.getService(e.class);
            e2.b();
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void loadShallow(IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (this.effectivelyMountingProject != null) {
            IProjectUsageManager iProjectUsageManager = (IProjectUsageManager)this.effectivelyMountingProject.getServiceOrFail(IProjectUsageManager.class);
            ProjectUsage projectUsage = (ProjectUsage)iProjectUsageManager.getProjectUsage((IProject)this);
            if (projectUsage == null) {
                throw new PersistenceException("The " + this.effectivelyMountingProject.getName() + " project does not have usage to " + this.getName());
            }
            this.loadShallow(this.effectivelyMountingProject, projectUsage, iProgressMonitor);
        }
    }

    public void create(IProject iProject, ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) throws PersistenceException {
        block4: {
            DecompositionModelService decompositionModelService = (DecompositionModelService)this.getServiceOrFail(IDecompositionModel.class);
            if (!decompositionModelService.isAvailable()) {
                LocalProject localProject;
                Resource resource;
                decompositionModelService.install(iProgressMonitor);
                LocalProject localProject2 = projectUsage.getUsedProject();
                if (localProject2 == null || !localProject2.eIsProxy()) break block4;
                String string = EcoreUtil.getURI((EObject)localProject2).fragment();
                if (string != null && (resource = (localProject = decompositionModelService.getDecompositionProject()).eResource()) instanceof XMIResource) {
                    XMIResource xMIResource = (XMIResource)resource;
                    xMIResource.setID((EObject)localProject, string);
                }
            }
        }
        this.setProjectState(ProjectState.Created);
    }

    @Override
    public final void loadShallow(IProject iProject, ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Shallow loading...", 1000);
        try {
            if (this.getProjectState() == ProjectState.Created) {
                this.cleanDecomposition((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                this.setProjectState(ProjectState.NotLoaded);
            }
            this.doLoadShallow(iProject, projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 600));
            this.shallowLoadFeatures((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 300));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void shallowLoadFeatures(IProgressMonitor iProgressMonitor) throws PersistenceException {
        try {
            this.getFeatureInitializer().read(true, iProgressMonitor);
        }
        catch (ProjectConfigurationException | IOException throwable) {
            throw new PersistenceException(throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doLoadShallow(IProject iProject, ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            SharePoint sharePoint;
            iProgressMonitor.beginTask("Reading minimum information about attached project...", 1000);
            LocalProject localProject = this.getShallowDecomposition(iProject, projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 400));
            this.registerProjectInResourceAccessManager();
            ArrayList<SharePoint> arrayList = new ArrayList<SharePoint>();
            TreeIterator treeIterator2 = EcoreUtil.getAllProperContents((EObject)localProject, (boolean)false);
            while (treeIterator2.hasNext()) {
                EObject eObject = (EObject)treeIterator2.next();
                if (!(eObject instanceof SharePoint)) continue;
                sharePoint = (SharePoint)eObject;
                arrayList.add(sharePoint);
            }
            for (TreeIterator treeIterator2 : arrayList) {
                sharePoint = treeIterator2.getObject();
                d.a((IProject)this, this.getResourceSet(), (EObject)sharePoint);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    protected LocalProject getShallowDecomposition(IProject iProject, ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Loading minimum information for " + this.getName() + "...", 1000);
        try {
            LocalProject localProject = this.resolveShallowDecomposition(iProject, projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 200));
            if (!this.isDecompositionValid(localProject)) {
                if (localProject != null) {
                    LOGGER.warn((Object)("Decomposition resolving failed. Continue loading from " + this.getLocationURI() + ", decomposition not valid reason: " + this.getDecompositionNotValidReason(localProject)));
                }
                projectUsage.setUsedProject(null);
                localProject = this.loadShallowDecomposition(iProject, projectUsage, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
            }
            if (!this.isDecompositionValid(localProject)) {
                throw new PersistenceException("Decomposition information about " + this.getLocationURI() + " project is corrupted, reason: " + this.getDecompositionNotValidReason(localProject) + ". Load can not continue.");
            }
            LocalProject localProject2 = localProject;
            return localProject2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    protected LocalProject resolveShallowDecomposition(IProject iProject, ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 100);
        try {
            LocalProject localProject = projectUsage.getUsedProjectResolved();
            if (localProject != null && localProject.eResource() != null) {
                Resource resource = localProject.eResource();
                TreeIterator treeIterator = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
                while (treeIterator.hasNext()) {
                    EObject eObject2 = (EObject)treeIterator.next();
                    EObject eObject = eObject2.eContainer();
                    if (eObject2.eContainer() == null || !eObject.eIsProxy()) continue;
                    EcoreUtil.resolve((EObject)eObject, (EObject)eObject2);
                }
            }
            LocalProject localProject2 = localProject;
            return localProject2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected LocalProject loadShallowDecomposition(IProject iProject, ProjectUsage projectUsage, IProgressMonitor iProgressMonitor) throws PersistenceException {
        LocalDecompositionModel localDecompositionModel = (LocalDecompositionModel)this.getServiceOrFail(IDecompositionModel.class);
        URI uRI = localDecompositionModel.getResourceURI();
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet.getURIConverter().exists(uRI, null)) {
            Resource resource = resourceSet.getResource(uRI, true);
            if (resource != null && resource.isLoaded()) {
                resource.unload();
            }
            resourceSet.getResource(uRI, true);
        }
        if (!localDecompositionModel.isAvailable()) return null;
        LocalProject localProject = localDecompositionModel.getDecompositionProject();
        return localProject;
    }

    protected boolean isDecompositionValid(LocalProject localProject) {
        if (this.getDecompositionNotValidReason(localProject) == null) {
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getDecompositionNotValidReason(LocalProject localProject) {
        EObject eObject2;
        if (localProject == null) {
            return "decomposition project is null";
        }
        if (localProject.eIsProxy()) {
            return "decomposition project is proxy";
        }
        Resource resource = localProject.eResource();
        if (resource == null) {
            return "decomposition project without resource";
        }
        if (this.getUriMapper().getResourceInfo(resource.getURI()) == null) {
            LOGGER.warn((Object)("Decomposition infromation resolved to wrong resource for project: " + this.getLocationURI()));
            LOGGER.info((Object)"Decomposition model of attaching project is out of synch with attached project data snapshot. See MDUML-53062 for details.");
            return "decomposition project's resource is not from the context project";
        }
        TreeIterator treeIterator2 = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
        while (treeIterator2.hasNext()) {
            Iterator iterator = (EObject)treeIterator2.next();
            eObject2 = iterator.eContainer();
            if (iterator.eContainer() == null || !eObject2.eIsProxy()) continue;
            return "proxy container of content object " + iterator;
        }
        for (TreeIterator treeIterator2 : localProject.getFeatures()) {
            if (treeIterator2.getNamespace() == null) {
                return "project feature without namespace";
            }
            if (treeIterator2.getName() == null) {
                return "project feature without name";
            }
            for (EObject eObject2 : treeIterator2.getSections()) {
                if (eObject2.eIsProxy()) {
                    return "proxy data section";
                }
                if (eObject2.getProject() == localProject) continue;
                return "data section's project not as expected: " + eObject2.getProject();
            }
        }
        for (TreeIterator treeIterator2 : localProject.getOwnedSections()) {
            if (treeIterator2.getName() == null) {
                return "data secion without name";
            }
            eObject2 = treeIterator2.getFeaturedBy();
            if (eObject2 == null) {
                return "data section " + treeIterator2.getName() + " without feature";
            }
            if (eObject2.eIsProxy()) {
                return "data section's " + treeIterator2.getName() + " feature is proxy";
            }
            if (eObject2.getProject() != localProject) {
                return "data section's " + treeIterator2.getName() + " feature's proejct is not as expected: " + eObject2.getProject();
            }
            Iterator iterator = treeIterator2.getBelongsTo();
            if (iterator != null) {
                if (iterator.eIsProxy()) {
                    return "data section's " + treeIterator2.getName() + " user part is proxy";
                }
                if (iterator.getProject() != localProject) {
                    return "data section's " + treeIterator2.getName() + " user part's project is not as expected: " + iterator.getProject();
                }
                if (iterator.getUser() == null) {
                    return "data section's " + treeIterator2.getName() + " user part without user";
                }
            }
            EList eList = treeIterator2.getSharePoints();
            for (SharePoint sharePoint : eList) {
                if (sharePoint.eGet((EStructuralFeature)ProjectPackage.eINSTANCE.getSharePoint_Object(), false) != null) continue;
                return "share point " + sharePoint.getID() + " without shared object";
            }
        }
        return null;
    }

    protected Resource getShallowResource(URI uRI) {
        Resource resource = this.getResourceSet().getResource(uRI, false);
        if (resource == null) {
            resource = this.getResourceSet().createResource(uRI);
        }
        return resource;
    }

    public boolean isLoaded() {
        return this.isProjectAvailable();
    }

    public void setProjectState(ProjectState projectState) {
        this.projectState = projectState;
    }

    public ProjectState getProjectState() {
        return this.projectState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateProjectsBeforeLoad(IProgressMonitor iProgressMonitor) throws PersistenceException {
        try {
            iProgressMonitor.beginTask("", 1000);
            IProjectRepositoryInternal iProjectRepositoryInternal = (IProjectRepositoryInternal)this.getProjectRepository();
            Set<IProject> set = null;
            Set<IProject> set2 = iProjectRepositoryInternal.collectTopLevelProjectsThatHaveToBeUpdatedToLoadProject(this);
            if (set2 != null && !set2.isEmpty()) {
                set = b.a(set2, false);
            }
            iProgressMonitor.worked(200);
            if (set != null && !set.isEmpty()) {
                b.a(set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
                return;
            }
            iProgressMonitor.worked(800);
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public IProject getEffectivelyMountingProject() {
        return this.effectivelyMountingProject;
    }

    public void setEffectivelyMountingProject(IProject iProject) {
        this.effectivelyMountingProject = iProject;
    }

    public Set<IMountPoint> getMountPoints() {
        return Collections.unmodifiableSet(this.mountPoints);
    }

    public void setMountPoints(Set<IMountPoint> set) {
        if (set == null) {
            throw new IllegalArgumentException("Can not set nulll");
        }
        this.mountPoints = set;
    }

    public final void detaching(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = this.getListenerTicks();
        iProgressMonitor.beginTask("Detaching the project...", 100 + n2);
        try {
            this.beforeRemoveForBinaryService((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            this.doDetaching((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n2));
            this.setPrimary(null);
            this.setResourceSet(null);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public abstract void doDetaching(IProgressMonitor var1);

    private void beforeUnloadForBinaryService(IProgressMonitor iProgressMonitor) {
        block3: {
            block2: {
                IBinarySynchronizationService iBinarySynchronizationService = this.getService(IBinarySynchronizationService.class);
                if (iBinarySynchronizationService == null) break block2;
                iBinarySynchronizationService.beforeUnload(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    private void beforeRemoveForBinaryService(IProgressMonitor iProgressMonitor) {
        block3: {
            block2: {
                IBinarySynchronizationService iBinarySynchronizationService = this.getService(IBinarySynchronizationService.class);
                if (iBinarySynchronizationService == null) break block2;
                iBinarySynchronizationService.beforeRemove(iProgressMonitor);
                break block3;
            }
            iProgressMonitor.done();
        }
    }

    public c getMountOptionsStore() {
        return this.mountOptionsStore;
    }

    public Map<EObject, MountLocation> getIntegrationPoints() {
        return this.integrationPoints;
    }

    public Map<String, MountLocation> getRestorePoints() {
        return this.restorePoints;
    }

    private RuntimeLockService getRuntimeLockService() {
        return (RuntimeLockService)this.getPrimaryProject().getService(RuntimeLockService.class);
    }

    @Override
    public void setManuallyReachable(Boolean bl) {
        this.manuallyReachable = bl;
    }

    @Override
    public Boolean getManuallyReachable() {
        return this.manuallyReachable;
    }

    public boolean isManuallyReachable() {
        if (this.getPrimaryProject() == null) {
            return false;
        }
        if (this.manuallyReachable == null) {
            e e2 = (e)this.getServiceOrFail(e.class);
            e2.a();
            if (this.manuallyReachable == null) {
                LOGGER.error((Object)("manuallyReachable is still not initialized after invoking updateFlags. Project: " + this.getLocationURI()));
            }
        }
        boolean bl = this.manuallyReachable != null ? this.manuallyReachable : false;
        return bl;
    }

    private class DefaultIAttachedProjectStateService
    implements IAttachedProjectStateServiceInternal {
        private DefaultIAttachedProjectStateService() {
        }

        public boolean canLoad() {
            return AbstractAttachedProject.this.canLoad();
        }

        public void load(IProgressMonitor iProgressMonitor) throws PersistenceException {
            AbstractAttachedProject.this.load(iProgressMonitor);
        }

        public boolean canUnload() {
            return AbstractAttachedProject.this.canUnload();
        }

        public void unload(IProgressMonitor iProgressMonitor) throws PersistenceException {
            AbstractAttachedProject.this.unload(iProgressMonitor);
        }

        public boolean isLoaded() {
            return AbstractAttachedProject.this.isLoaded();
        }

        public ProjectState getProjectState() {
            return AbstractAttachedProject.this.getProjectState();
        }

        public boolean isUnloading() {
            return AbstractAttachedProject.this.isUnloading();
        }

        public IProject getProject() {
            return AbstractAttachedProject.this;
        }
    }
}

