/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.services;

import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.ServiceNewAndOldValue;
import com.nomagic.ci.persistence.local.spi.events.ServiceBusEvent;
import com.nomagic.ci.persistence.local.spi.events.ServiceEventListener;

public abstract class WaitForService<T> {
    protected AbstractProject project;
    Class<T> serviceType;
    ServiceEventListener regiterListener;

    public WaitForService(AbstractProject abstractProject, Class<T> clazz) {
        this.project = abstractProject;
        this.serviceType = clazz;
    }

    public final void doWait() {
        T t2 = this.project.getService(this.serviceType);
        if (t2 != null) {
            this.serviceAvailable(t2);
        } else {
            this.regiterListener = new ServiceEventListener(){

                @Override
                public void notify(ServiceBusEvent serviceBusEvent) {
                    ServiceNewAndOldValue serviceNewAndOldValue;
                    if (serviceBusEvent.getSource() instanceof AbstractProject && serviceBusEvent.getEventType().equals(AbstractProject.SERVICE_REGISTERED_EVENT_TYPE) && (serviceNewAndOldValue = (ServiceNewAndOldValue)serviceBusEvent.getData()).getNewValue() != null && WaitForService.this.serviceType.isAssignableFrom(serviceNewAndOldValue.getNewValue().getClass())) {
                        WaitForService.this.project.getProjectServiceEventBus().removeListener(WaitForService.this.regiterListener);
                        WaitForService.this.serviceAvailable(WaitForService.this.serviceType.cast(serviceNewAndOldValue.getNewValue()));
                    }
                }
            };
            this.project.getProjectServiceEventBus().addListener(this.regiterListener);
        }
    }

    public abstract void serviceAvailable(T var1);
}

