/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.proxy.resource.impl;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.local.proxy.resource.UsageTypeProvider;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class UsageTypeProviderImpl
implements UsageTypeProvider {
    public static final String DISABLE_DIRECT_MODULES_ELEMENTS_IN_SNAPSHOT = "disable.direct.modules.elements.in.snapshot";
    private final Collection<Resource> directlyUsedResources;

    public UsageTypeProviderImpl(Collection<Resource> collection) {
        this.directlyUsedResources = new HashSet<Resource>(collection);
        this.collectManagedResourcesFromProjects(UsageTypeProviderImpl.collectProjects(collection));
    }

    private void collectManagedResourcesFromProjects(HashSet<IProject> hashSet) {
        for (IProject iProject : hashSet) {
            this.directlyUsedResources.addAll(((AbstractProject)iProject).getManagedResources());
            if (!Boolean.getBoolean(DISABLE_DIRECT_MODULES_ELEMENTS_IN_SNAPSHOT)) continue;
            this.addResourcesFromDirectUsedProjects(iProject);
        }
    }

    private void addResourcesFromDirectUsedProjects(IProject iProject) {
        for (IProject iProject2 : LocalProjectUtil.getDirectlyUsedProjects(iProject)) {
            this.directlyUsedResources.addAll(((AbstractProject)iProject2).getManagedResources());
        }
    }

    private static HashSet<IProject> collectProjects(Collection<Resource> collection) {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        for (Resource resource : collection) {
            IProject iProject = LocalProjectUtil.getProject(resource);
            if (iProject == null) continue;
            hashSet.add(iProject);
        }
        return hashSet;
    }

    @Override
    public boolean isDirectlyUsed(EObject eObject) {
        return this.directlyUsedResources.contains(eObject.eResource());
    }
}

