/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.proxy.resource.impl;

import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.local.internal.i.e;
import com.nomagic.ci.persistence.local.proxy.PersistentObjectProvider;
import com.nomagic.ci.persistence.local.proxy.SubsetProvider;
import com.nomagic.ci.persistence.local.proxy.ValueFilter;
import com.nomagic.ci.persistence.local.proxy.resource.SnapshotXMIResource;
import com.nomagic.ci.persistence.local.proxy.resource.impl.FilterXMISaveImpl;
import com.nomagic.ci.persistence.local.spi.proxy.PackageURIRemapperSupport;
import com.nomagic.ci.persistence.local.spi.util.EPackageEObjectService;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import com.nomagic.ci.persistence.util.ProjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.UnresolvedReferenceException;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SnapshotXMIResourceImpl
extends XMIResourceImpl
implements SnapshotXMIResource,
SubsetProvider {
    private static final Logger LOGGER = Logger.getLogger(SnapshotXMIResourceImpl.class);
    private XMIResource original;
    private ValueFilter persistentFeatureFilter;
    private boolean saving;
    private PersistentObjectProvider persistentObjectProvider = new e();
    private Set<EObject> persistentObjects;
    private Map<URI, EObject> objectMap = new ReferenceMap(0, 2);
    private PackageURIRemapperSupport packageURIRemapper;
    private Set<String> rootObjects = null;

    public SnapshotXMIResourceImpl(XMIResource xMIResource, URI uRI, ValueFilter valueFilter) {
        this(xMIResource, uRI, valueFilter, null);
    }

    public SnapshotXMIResourceImpl(XMIResource xMIResource, URI uRI, ValueFilter valueFilter, @CheckForNull PackageURIRemapperSupport packageURIRemapperSupport) {
        super(uRI);
        this.original = xMIResource;
        this.persistentFeatureFilter = valueFilter;
        this.packageURIRemapper = packageURIRemapperSupport;
        this.setIntrinsicIDToEObjectMap(this.getIDToEObjectMap());
    }

    protected EObject getEObjectByID(String string) {
        Map map = this.getIntrinsicIDToEObjectMap();
        if (map != null) {
            EObject eObject = (EObject)map.get(string);
            if (eObject != null) {
                return eObject;
            }
        }
        return null;
    }

    protected XMLSave createXMLSave() {
        return new FilterXMISaveImpl((XMLHelper)new XMIHelperImpl((XMLResource)this.original){

            public String getHREF(EObject eObject) {
                int n2;
                String string = super.getHREF(eObject);
                if (SnapshotXMIResourceImpl.this.isPersistent(eObject) && string != null && (n2 = string.indexOf("#")) > 0) {
                    return string.substring(n2);
                }
                return string;
            }
        }, this.persistentFeatureFilter, this);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> map) throws IOException {
        map = map == null ? Collections.singletonMap("DEFER_IDREF_RESOLUTION", true) : SnapshotXMIResourceImpl.mergeMaps(map, Collections.singletonMap("DEFER_IDREF_RESOLUTION", true));
        super.doLoad(inputStream, (Map)map);
    }

    protected XMLHelper createXMLHelper() {
        return new XMIHelperImpl((XMLResource)this){

            public String getURI(String string) {
                String string2;
                String string3 = super.getURI(string);
                if (SnapshotXMIResourceImpl.this.packageURIRemapper != null && (string2 = SnapshotXMIResourceImpl.this.packageURIRemapper.remap(string3)) != null) {
                    return string2;
                }
                return string3;
            }
        };
    }

    protected XMLLoad createXMLLoad() {
        return new XMILoadImpl(this.createXMLHelper()){

            protected DefaultHandler makeDefaultHandler() {
                return new SAXXMIHandler(this.resource, this.helper, this.options){

                    protected EPackage handleMissingPackage(String string) {
                        if (SnapshotXMIResourceImpl.this.packageURIRemapper != null) {
                            String string2 = SnapshotXMIResourceImpl.this.packageURIRemapper.remap(string);
                            EPackage ePackage = this.packageRegistry.getEPackage(string2);
                            if (ePackage != null) {
                                return ePackage;
                            }
                        }
                        return super.handleMissingPackage(string);
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    protected void handleForwardReferences(boolean bl) {
                        EObject eObject;
                        Object object;
                        Object object2;
                        EObject eObject2;
                        InternalEObject internalEObject;
                        IProject iProject = LocalProjectUtil.getProject((Resource)SnapshotXMIResourceImpl.this.original);
                        IPrimaryProject iPrimaryProject = null;
                        if (iProject != null) {
                            iPrimaryProject = ProjectUtil.getPrimaryProject((IProject)iProject);
                        }
                        Iterator iterator = this.sameDocumentProxies.iterator();
                        block25: while (iterator.hasNext()) {
                            EStructuralFeature eStructuralFeature;
                            InternalEList internalEList;
                            Object object3;
                            EPackageEObjectService ePackageEObjectService;
                            internalEObject = (InternalEObject)iterator.next();
                            eObject2 = internalEObject.eClass();
                            object2 = eObject2.getEAllReferences();
                            if (iPrimaryProject != null && (ePackageEObjectService = (EPackageEObjectService)iPrimaryProject.getService(EPackageEObjectService.class)) != null && (object3 = ePackageEObjectService.getEObjectService(eObject2.getEPackage())) != null) {
                                object = object3.getReplaceHelper();
                                eObject = object.getSortedFeatures((EClass)eObject2);
                                object2 = new ArrayList(object2.size());
                                internalEList = eObject.iterator();
                                while (internalEList.hasNext()) {
                                    eStructuralFeature = internalEList.next();
                                    if (!(eStructuralFeature instanceof EReference)) continue;
                                    object2.add((EReference)eStructuralFeature);
                                }
                            }
                            object3 = object2.iterator();
                            while (object3.hasNext()) {
                                int n2;
                                int n3;
                                ePackageEObjectService = (EReference)object3.next();
                                object = ePackageEObjectService.getEOpposite();
                                if (object == null || !object.isChangeable() || object.isDerived() || !internalEObject.eIsSet((EStructuralFeature)ePackageEObjectService)) continue;
                                eObject = this.xmlResource.getEObject(internalEObject.eProxyURI().fragment());
                                if (eObject == null) continue block25;
                                if (!bl) {
                                    iterator.remove();
                                }
                                eStructuralFeature = (EObject)(ePackageEObjectService.isMany() ? ((List)internalEObject.eGet((EStructuralFeature)ePackageEObjectService)).get(0) : internalEObject.eGet((EStructuralFeature)ePackageEObjectService));
                                if (object.isMany() && (n3 = (internalEList = (InternalEList)eStructuralFeature.eGet((EStructuralFeature)object)).basicIndexOf((Object)eObject)) != -1 && (n2 = internalEList.basicIndexOf((Object)internalEObject)) != -1) {
                                    internalEList.move(n2, n3);
                                    internalEList.remove(n2 > n3 ? n2 - 1 : n2 + 1);
                                    continue block25;
                                }
                                if (!object.getEType().isInstance((Object)eObject)) {
                                    this.error((XMIException)new IllegalValueException((EObject)eStructuralFeature, (EStructuralFeature)object, (Object)eObject, null, this.getLocation(), this.getLineNumber(), this.getColumnNumber()));
                                    continue block25;
                                }
                                if (!(ePackageEObjectService.isMany() ? !((InternalEList)eObject.eGet((EStructuralFeature)ePackageEObjectService)).basicContains((Object)eStructuralFeature) : eObject.eGet((EStructuralFeature)ePackageEObjectService) != eStructuralFeature)) continue block25;
                                if (object.isMany()) {
                                    internalEList = (InternalEList)eStructuralFeature.eGet((EStructuralFeature)object);
                                    try {
                                        n3 = internalEList.basicIndexOf((Object)internalEObject);
                                        if (n3 != -1) {
                                            internalEList.setUnique(n3, (Object)eObject);
                                            continue block25;
                                        }
                                        internalEList.addUnique((Object)eObject);
                                        continue block25;
                                    }
                                    catch (Exception exception) {
                                        LOGGER.error((Object)("Exception occured. eReference: " + SnapshotXMIResourceImpl.getFeatureName((EStructuralFeature)ePackageEObjectService) + " oppositeEReference: " + SnapshotXMIResourceImpl.getFeatureName((EStructuralFeature)object)), (Throwable)exception);
                                        throw new RuntimeException(exception);
                                    }
                                }
                                eStructuralFeature.eSet((EStructuralFeature)object, (Object)eObject);
                                continue block25;
                            }
                        }
                        iterator = this.forwardSingleReferences.iterator();
                        while (iterator.hasNext()) {
                            internalEObject = (XMLHandler.SingleReference)iterator.next();
                            eObject2 = this.xmlResource.getEObject((String)internalEObject.getValue());
                            if (eObject2 != null) {
                                if (!bl) {
                                    iterator.remove();
                                }
                                object2 = internalEObject.getFeature();
                                this.setFeatureValue(internalEObject.getObject(), (EStructuralFeature)object2, eObject2, internalEObject.getPosition());
                                continue;
                            }
                            if (!bl) continue;
                            this.error((XMIException)new UnresolvedReferenceException((String)internalEObject.getValue(), this.getLocation(), internalEObject.getLineNumber(), internalEObject.getColumnNumber()));
                        }
                        iterator = this.forwardManyReferences.iterator();
                        while (iterator.hasNext()) {
                            internalEObject = (XMLHandler.ManyReference)iterator.next();
                            eObject2 = internalEObject.getValues();
                            boolean bl2 = false;
                            int n4 = 0;
                            int n5 = ((Object[])eObject2).length;
                            while (n4 < n5) {
                                object = (String)eObject2[n4];
                                eObject = this.xmlResource.getEObject((String)object);
                                eObject2[n4] = eObject;
                                if (eObject == null) {
                                    bl2 = true;
                                    if (bl) {
                                        this.error((XMIException)new UnresolvedReferenceException((String)object, this.getLocation(), internalEObject.getLineNumber(), internalEObject.getColumnNumber()));
                                    }
                                }
                                ++n4;
                            }
                            if (!bl2) {
                                if (!bl) {
                                    iterator.remove();
                                }
                                this.setFeatureValues((XMLHandler.ManyReference)internalEObject);
                                continue;
                            }
                            if (!bl) continue;
                            this.setFeatureValues((XMLHandler.ManyReference)internalEObject);
                        }
                    }
                };
            }
        };
    }

    private static String getFeatureName(EStructuralFeature eStructuralFeature) {
        EClass eClass = eStructuralFeature.getEContainingClass();
        if (eClass != null) {
            return String.valueOf(eClass.getName()) + '.' + eStructuralFeature.getName();
        }
        return eStructuralFeature.getName();
    }

    public void doSave(OutputStream outputStream, Map<?, ?> map) throws IOException {
        this.saving = true;
        try {
            this.initPersistentObjects();
            super.doSave(outputStream, map);
        }
        finally {
            this.persistentObjects = null;
            this.saving = false;
        }
    }

    public void doSave(Writer writer, Map<?, ?> map) throws IOException {
        this.saving = true;
        try {
            this.initPersistentObjects();
            super.doSave(writer, map);
        }
        finally {
            this.persistentObjects = null;
            this.saving = false;
        }
    }

    protected URIConverter getURIConverter() {
        if (this.original != null) {
            ResourceSet resourceSet = this.original.getResourceSet();
            if (resourceSet != null) {
                return resourceSet.getURIConverter();
            }
        }
        return super.getURIConverter();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EList<EObject> getContents() {
        if (this.saving && this.persistentObjectProvider != null) {
            return this.persistentObjectProvider.getContents((Resource)this.original, this.persistentFeatureFilter);
        }
        return super.getContents();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initPersistentObjects() {
        this.objectMap.clear();
        this.persistentObjects = new HashSet<EObject>();
        PersistentObjectProvider persistentObjectProvider = this.persistentObjectProvider;
        if (persistentObjectProvider == null) {
            persistentObjectProvider = new e();
        }
        ResourceSet resourceSet = this.original.getResourceSet();
        ArrayList arrayList = new ArrayList(resourceSet.getResources());
        arrayList.remove(this.original);
        this.persistentObjects.addAll(persistentObjectProvider.getPersistentObjects((Resource)this.original, arrayList, this.persistentFeatureFilter));
        for (EObject eObject : this.persistentObjects) {
            this.objectMap.put(EcoreUtil.getURI((EObject)eObject), eObject);
        }
    }

    boolean isPersistent(EObject eObject) {
        if (this.persistentObjects != null) {
            return this.persistentObjects.contains(eObject);
        }
        throw new IllegalStateException("persistent objects are initialized on save only.");
    }

    @Override
    public boolean isPartOfSubset(EObject eObject) {
        return this.isPersistent(eObject);
    }

    protected boolean useUUIDs() {
        return true;
    }

    @Override
    public Map<URI, EObject> getSavedObjectMap() {
        return this.objectMap;
    }

    @Override
    public void setPersistentObjectProvider(PersistentObjectProvider persistentObjectProvider) {
        this.persistentObjectProvider = persistentObjectProvider;
    }

    @Override
    public XMIResource getOriginal() {
        return this.original;
    }

    @Override
    public Set<String> getRootObjects() {
        return this.rootObjects;
    }

    @Override
    public void setRootObjects(Set<String> set) {
        this.rootObjects = set;
    }
}

