/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.proxy.resource.impl;

import com.nomagic.ci.persistence.local.internal.V;
import com.nomagic.ci.persistence.local.internal.i.a.g;
import com.nomagic.ci.persistence.local.internal.y;
import com.nomagic.ci.persistence.local.proxy.ProxyRegistry;
import com.nomagic.ci.persistence.local.proxy.URIResolver;
import com.nomagic.ci.persistence.local.proxy.resource.IDefaultObjectResolveBarrier;
import com.nomagic.ci.persistence.local.proxy.resource.IResolveBarrier;
import com.nomagic.ci.persistence.local.proxy.resource.ResolvingResourceSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ResolvingResourceSetImpl
extends V
implements ResolvingResourceSet {
    private static final Logger LOGGER = Logger.getLogger(ResolvingResourceSetImpl.class);
    private static final boolean DISABLE_BARRIERS = Boolean.getBoolean("ci.resourceset.disable.barriers");
    private List<URIResolver> resolvers = new ArrayList<URIResolver>();
    private ProxyRegistry proxyRegistry;
    private boolean enabled = true;
    private Set<IResolveBarrier> resolveBarriers = new HashSet<IResolveBarrier>();
    private Set<IDefaultObjectResolveBarrier> defaultResolveBarriers = new HashSet<IDefaultObjectResolveBarrier>();

    public ResolvingResourceSetImpl(y y2) {
        this(y2, new g());
    }

    public ResolvingResourceSetImpl(y y2, ProxyRegistry proxyRegistry) {
        super(y2);
        this.proxyRegistry = proxyRegistry;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EObject getEObject(URI uRI, boolean bl) {
        Object object;
        if (!this.enabled) {
            return null;
        }
        if (!DISABLE_BARRIERS) {
            for (IResolveBarrier iResolveBarrier : this.resolveBarriers) {
                if (!iResolveBarrier.isForbidden(uRI, bl)) continue;
                object = this.getURIRemapper();
                if (object == null) return null;
                URI uRI2 = object.remap(uRI);
                if (uRI2 == null) return null;
                if (iResolveBarrier.isForbidden(uRI2, bl)) return null;
            }
        }
        try {
            IResolveBarrier iResolveBarrier;
            iResolveBarrier = null;
            Iterator<Object> iterator = this.resolvers.iterator();
            while (true) {
                if (iResolveBarrier != null || !iterator.hasNext()) {
                    if (iResolveBarrier != null) return iResolveBarrier;
                    return this.defaultResolveObject(uRI, bl);
                }
                object = (URIResolver)iterator.next();
                if (!object.canResolve(uRI)) continue;
                iResolveBarrier = object.resolve(uRI, bl, this, this.proxyRegistry);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private EObject defaultResolveObject(URI uRI, boolean bl) {
        if (!DISABLE_BARRIERS) {
            for (IDefaultObjectResolveBarrier iDefaultObjectResolveBarrier : this.defaultResolveBarriers) {
                if (!iDefaultObjectResolveBarrier.isResolveForbidden(uRI)) continue;
                return null;
            }
        }
        return super.getEObject(uRI, bl);
    }

    @Override
    public void addURIResolver(int n2, URIResolver uRIResolver) {
        if (uRIResolver == null) {
            throw new IllegalArgumentException("URI resolver can not be null.");
        }
        this.resolvers.add(n2, uRIResolver);
    }

    @Override
    public void addURIResolver(URIResolver uRIResolver) {
        if (uRIResolver == null) {
            throw new IllegalArgumentException("URI resolver can not be null.");
        }
        this.resolvers.add(uRIResolver);
    }

    @Override
    public void removeURIResolver(URIResolver uRIResolver) {
        this.resolvers.remove(uRIResolver);
    }

    @Override
    public List<URIResolver> getURIResolvers() {
        return Collections.unmodifiableList(this.resolvers);
    }

    @Override
    public void demandLoadHelper(Resource resource) {
        super.demandLoadHelper(resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump() {
        System.out.println(super.toString());
        System.out.println("# of resolvers: " + this.resolvers.size());
        for (URIResolver uRIResolver : this.resolvers) {
            System.out.println(uRIResolver);
        }
    }

    @Override
    public void addResolveBarrier(IResolveBarrier iResolveBarrier) {
        this.resolveBarriers.add(iResolveBarrier);
    }

    @Override
    public void removeResolveBarrier(IResolveBarrier iResolveBarrier) {
        this.resolveBarriers.remove(iResolveBarrier);
    }

    @Override
    public void addDefaultObjectResolveBarrier(IDefaultObjectResolveBarrier iDefaultObjectResolveBarrier) {
        this.defaultResolveBarriers.add(iDefaultObjectResolveBarrier);
    }

    @Override
    public void removeDefaultObjectResolveBarrier(IDefaultObjectResolveBarrier iDefaultObjectResolveBarrier) {
        this.defaultResolveBarriers.remove(iDefaultObjectResolveBarrier);
    }
}

