/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.proxy.resource.impl;

import com.nomagic.ci.persistence.local.internal.i.b;
import com.nomagic.ci.persistence.local.proxy.PersistentObjectProvider;
import com.nomagic.ci.persistence.local.proxy.ValueFilter;
import com.nomagic.ci.persistence.local.proxy.resource.UsageTypeProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DependentPersistentObjectProviderImpl
implements PersistentObjectProvider {
    private final Collection<EObject> dependsOn;
    private final UsageTypeProvider usageType;

    public DependentPersistentObjectProviderImpl(@Nonnull Collection<EObject> collection, @Nonnull UsageTypeProvider usageTypeProvider) {
        this.dependsOn = collection;
        this.usageType = usageTypeProvider;
    }

    @Override
    @Nonnull
    public EList<EObject> getContents(@Nonnull Resource resource, ValueFilter valueFilter) {
        if (this.dependsOn.isEmpty()) {
            return ECollections.emptyEList();
        }
        Collection<EObject> collection = DependentPersistentObjectProviderImpl.addRequiredParentsAndFindTopLevelElements(resource, this.getPersistentObjects(resource, Collections.emptyList(), valueFilter));
        return new BasicEList(collection);
    }

    @Nonnull
    public Collection<EObject> getPersistentObjects(Resource resource, Collection<?> collection, ValueFilter valueFilter) {
        return b.a(this.dependsOn, DependentPersistentObjectProviderImpl.createRelatedElementFilter(this.usageType, resource), valueFilter);
    }

    private static b.a createRelatedElementFilter(final UsageTypeProvider usageTypeProvider, final Resource resource) {
        return new b.a(){

            @Override
            public boolean evaluate(EObject eObject) {
                return eObject.eResource() == resource || !usageTypeProvider.isDirectlyUsed(eObject);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Collection<EObject> addRequiredParentsAndFindTopLevelElements(Resource resource, Collection<EObject> collection) {
        HashSet<EObject> hashSet = new HashSet<EObject>();
        block4: for (EObject eObject : collection) {
            try {
                while (true) {
                    if (DependentPersistentObjectProviderImpl.isTopLevelInResource(resource, eObject) || eObject == null) {
                        if (eObject == null) continue block4;
                        hashSet.add(eObject);
                        continue block4;
                    }
                    eObject = eObject.eContainer();
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        return hashSet;
    }

    private static boolean isTopLevelInResource(Resource resource, EObject eObject) {
        Resource resource2 = eObject.eResource();
        if (resource2 == null) {
            return DependentPersistentObjectProviderImpl.fail(eObject, resource);
        }
        return resource2.getContents().contains((Object)eObject);
    }

    private static boolean fail(EObject eObject, Resource resource) {
        URI uRI = EcoreUtil.getURI((EObject)eObject);
        if (eObject.eIsProxy()) {
            throw new RuntimeException("Dependency on emf proxy detected " + uRI + " from resource " + resource.getURI());
        }
        throw new RuntimeException("Dependency on object without resource detected " + uRI + " from resource " + resource.getURI());
    }
}

