/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.migration;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IResourceDescriptor;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import com.nomagic.ci.persistence.local.ILocalResourceDescriptor;
import com.nomagic.ci.persistence.local.features.FeatureResourceManagerFactory;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import com.nomagic.ci.persistence.migration.IDataTransferer;
import com.nomagic.ci.persistence.resources.IProjectResourceManager;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceTransferer {
    private IProject targetProject;
    private IDataTransferer transferMethod;

    public ResourceTransferer(IProject iProject, IDataTransferer iDataTransferer) {
        this.targetProject = iProject;
        this.transferMethod = iDataTransferer;
    }

    public void transfer(Collection<Resource> collection, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        int n2 = collection.size();
        iProgressMonitor.beginTask("Transfering data to " + this.targetProject.getName() + "...", 100 * n2);
        try {
            for (Resource resource : collection) {
                if (!resource.getContents().isEmpty()) {
                    Resource resource2 = ResourceTransferer.getTargetResource(resource, this.targetProject);
                    this.transferMethod.transfer((Collection)resource.getContents(), resource2);
                }
                iProgressMonitor.worked(100);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public static Resource getTargetResource(Resource resource, IProject iProject) {
        IProject iProject2 = LocalProjectUtil.getProject(resource);
        ILocalResourceDescriptor iLocalResourceDescriptor = ((AbstractProject)iProject2).getResourceDescriptor(resource);
        String string = iLocalResourceDescriptor.getResourceName();
        IProjectResourceManager iProjectResourceManager = ResourceTransferer.getTargetResourceManager(iLocalResourceDescriptor, iProject);
        Resource resource2 = iProjectResourceManager.getResourceNames().contains(string) ? iProjectResourceManager.getResource(string, true) : iProjectResourceManager.createResource(string);
        return resource2;
    }

    private static IProjectResourceManager getTargetResourceManager(IResourceDescriptor iResourceDescriptor, IProject iProject) {
        boolean bl;
        IProjectFeatureDescriptor iProjectFeatureDescriptor = iResourceDescriptor.getResourceFeatureDescriptor();
        boolean bl2 = iResourceDescriptor instanceof ILocalResourceDescriptor;
        boolean bl3 = bl = bl2 ? ((ILocalResourceDescriptor)iResourceDescriptor).isShared() : false;
        if (iResourceDescriptor.isPersonal()) {
            if (bl2) {
                return FeatureResourceManagerFactory.getPersonalResourceManager(iProject, iProjectFeatureDescriptor, bl);
            }
            return FeatureResourceManagerFactory.getPersonalResourceManager(iProject, iProjectFeatureDescriptor);
        }
        if (bl2) {
            return bl ? FeatureResourceManagerFactory.getSharedResourceManager(iProject, iProjectFeatureDescriptor) : FeatureResourceManagerFactory.getPrivateResourceManager(iProject, iProjectFeatureDescriptor);
        }
        return FeatureResourceManagerFactory.getResourceManager(iProject, iProjectFeatureDescriptor);
    }
}

