/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.migration;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import com.nomagic.ci.persistence.local.features.FeatureResources;
import com.nomagic.ci.persistence.local.migration.ResourceTransferer;
import com.nomagic.ci.persistence.migration.DataCopier;
import com.nomagic.ci.persistence.migration.IDataTransferer;
import com.nomagic.ci.persistence.migration.ITransferedData;
import com.nomagic.ci.persistence.util.MultiValueHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class FeatureDataTransferer {
    private IProject source;
    private IProjectFeatureDescriptor feature;
    protected IDataTransferer transferMethod;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeatureDataTransferer(IProject iProject, IProjectFeatureDescriptor iProjectFeatureDescriptor, IDataTransferer iDataTransferer) {
        if (iProject != null && iProjectFeatureDescriptor != null && iDataTransferer != null) {
            this.source = iProject;
            this.feature = iProjectFeatureDescriptor;
            this.transferMethod = iDataTransferer;
            return;
        }
        throw new IllegalArgumentException();
    }

    public IProjectFeatureDescriptor getFeature() {
        return this.feature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transfer(IProject iProject, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        Collection<Resource> collection = this.getSourceResources();
        int n2 = collection.size();
        iProgressMonitor.beginTask(String.valueOf(this.transferMethod.getJobTitle()) + " " + this.feature.getName() + "...", 100 * n2);
        try {
            for (Resource resource : collection) {
                List<EObject> list = this.getSourceResourceScope(iProject, resource);
                if (list != null && !list.isEmpty()) {
                    Resource resource2;
                    MultiValueHashMap multiValueHashMap = new MultiValueHashMap();
                    for (EObject eObject : list) {
                        resource2 = this.getTargetResource(this.source, resource, eObject, iProject);
                        if (resource2 == null) {
                            throw new PersistenceRuntimeException("Can not create target resource for feature " + this.feature.getName());
                        }
                        multiValueHashMap.append((Object)resource2, (Object)eObject);
                    }
                    for (Map.Entry entry : multiValueHashMap.entrySet()) {
                        resource2 = (Resource)entry.getKey();
                        Set set = (Set)entry.getValue();
                        this.transferMethod.transfer((Collection)set, resource2);
                    }
                }
                iProgressMonitor.worked(100);
            }
            this.transferMethod.finish();
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected Resource getTargetResource(IProject iProject, Resource resource, EObject eObject, IProject iProject2) {
        return ResourceTransferer.getTargetResource(resource, iProject2);
    }

    public Map<EObject, EObject> getCopies() {
        Map map = Collections.emptyMap();
        if (this.transferMethod instanceof DataCopier) {
            DataCopier dataCopier = (DataCopier)this.transferMethod;
            map = dataCopier.getCopies();
        }
        return map;
    }

    protected List<EObject> getSourceResourceScope(IProject iProject, Resource resource) {
        return new ArrayList<EObject>((Collection<EObject>)resource.getContents());
    }

    public Collection<Resource> getSourceResources() {
        return FeatureResources.getResources(this.source, this.feature, false);
    }

    public ITransferedData getTransferedData() {
        return this.transferMethod.getTransferedData();
    }
}

