/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.features.dependency;

import com.nomagic.ci.persistence.features.FeatureDataSet;
import com.nomagic.ci.persistence.local.features.dependency.VirtualResource;
import com.nomagic.ci.persistence.local.features.dependency.VirtualResourceFactory;
import com.nomagic.ci.persistence.local.util.EcoreHelper;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class VirtualResourceFactoryImpl
implements VirtualResourceFactory {
    @Override
    public VirtualResource create(Resource resource) {
        return new ResourceAdapter(resource);
    }

    @Override
    public VirtualResource create(FeatureDataSet featureDataSet) {
        return new FeatureDataSetAdapter(featureDataSet);
    }

    @Override
    public Collection<VirtualResource> create(Collection<Resource> collection) {
        return collection.stream().map(this::create).collect(Collectors.toList());
    }

    @Override
    public Collection<VirtualResource> createFrom(Collection<FeatureDataSet> collection) {
        return collection.stream().map(this::create).collect(Collectors.toList());
    }

    private static abstract class AbstractVirtualResource<T>
    implements VirtualResource {
        protected T identity;

        public AbstractVirtualResource(T t2) {
            this.identity = t2;
        }

        @Override
        public boolean isMyObject(EObject eObject) {
            return EcoreHelper.isSameResourceAncestor(this.getContents(), eObject);
        }

        public T getIdentity() {
            return this.identity;
        }

        public int hashCode() {
            return this.identity.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AbstractVirtualResource abstractVirtualResource = (AbstractVirtualResource)object;
            return this.identity.equals(abstractVirtualResource.identity);
        }
    }

    private static class FeatureDataSetAdapter
    extends AbstractVirtualResource<FeatureDataSet> {
        public FeatureDataSetAdapter(FeatureDataSet featureDataSet) {
            super(featureDataSet);
        }

        @Override
        public List<EObject> getContents() {
            return ((FeatureDataSet)this.identity).getData();
        }
    }

    private static class ResourceAdapter
    extends AbstractVirtualResource<Resource> {
        public ResourceAdapter(Resource resource) {
            super(resource);
        }

        @Override
        public List<EObject> getContents() {
            return ((Resource)this.identity).getContents();
        }
    }
}

