/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.features.dependency;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.features.FeatureDependencyException;
import com.nomagic.ci.persistence.features.IProjectFeatureHandler;
import com.nomagic.ci.persistence.local.features.dependency.DependencyFinder;
import com.nomagic.ci.persistence.local.features.dependency.DependencyInfo;
import com.nomagic.ci.persistence.local.internal.e.a.a;
import com.nomagic.ci.persistence.local.internal.e.a.c;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;

public class DependencyFinderUtil {
    public static Set<DependencyInfo<?>> findDependencies(IProgressMonitor iProgressMonitor, Resource resource) {
        return DependencyFinderUtil.findDependencies(iProgressMonitor, resource, null, false);
    }

    public static Set<DependencyInfo<?>> findDependencies(IProgressMonitor iProgressMonitor, Resource resource, boolean bl) {
        return DependencyFinderUtil.findDependencies(iProgressMonitor, resource, null, bl);
    }

    public static Set<DependencyInfo<?>> findDependencies(IProgressMonitor iProgressMonitor, Resource resource, DependencyFinder dependencyFinder) {
        return DependencyFinderUtil.findDependencies(iProgressMonitor, resource, dependencyFinder, false);
    }

    public static Set<DependencyInfo<?>> findDependencies(IProgressMonitor iProgressMonitor, Resource resource, DependencyFinder dependencyFinder, boolean bl) {
        IProject iProject = LocalProjectUtil.getProject(resource);
        if (iProject == null) {
            return Collections.emptySet();
        }
        IProjectFeatureHandler iProjectFeatureHandler = LocalProjectUtil.getHandler(resource);
        if (iProjectFeatureHandler instanceof DependencyFinder) {
            DependencyFinder dependencyFinder2 = (DependencyFinder)iProjectFeatureHandler;
            Set<DependencyInfo<?>> set = dependencyFinder2.findDependencies(iProgressMonitor, resource, bl);
            if (set != null) {
                return set;
            }
        }
        if (dependencyFinder == null) {
            dependencyFinder = new a();
        }
        return dependencyFinder.findDependencies(iProgressMonitor, resource, bl);
    }

    public static Set<DependencyInfo<?>> findIncomingDependencies(IProgressMonitor iProgressMonitor, Set<Resource> set, Set<Resource> set2, boolean bl) throws FeatureDependencyException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            iProgressMonitor.beginTask("Finding incoming dependencies...", 1000);
            DependencyFinderUtil.checkResources(set2, set);
            iProgressMonitor.subTask("Initializing finder...");
            c c2 = new c(set, set2);
            c2.a((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            iProgressMonitor.subTask("Finding dependencies...");
            if (c2.c()) {
                Set<DependencyInfo<?>> set3 = c2.a((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 900), bl);
                return set3;
            }
            Set<DependencyInfo<?>> set4 = Collections.emptySet();
            return set4;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkResources(Set<Resource> set, Set<Resource> set2) {
        if (set2 == null || set2.isEmpty()) {
            throw new IllegalArgumentException("targetResources not provided");
        }
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("sourceResources not provided");
        }
        if (!Collections.disjoint(set2, set)) {
            throw new IllegalArgumentException("targetResources and sourceResources sets must not contain common elements");
        }
    }
}

