/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.decomposition.ProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import com.nomagic.ci.persistence.local.decomposition.DefaultFeatureExtracter;
import com.nomagic.ci.persistence.local.features.FeatureResourceManagerFactory;
import com.nomagic.ci.persistence.local.importers.SharePointData;
import com.nomagic.ci.persistence.local.mounting.IMountingProjectFeatureHandler;
import com.nomagic.ci.persistence.local.sharing.IProjectSharingManager;
import com.nomagic.ci.persistence.local.sharing.IResourceNamingProvider;
import com.nomagic.ci.persistence.local.util.LocalProjectUtil;
import com.nomagic.ci.persistence.migration.DataMover;
import com.nomagic.ci.persistence.migration.IDataTransferer;
import com.nomagic.ci.persistence.migration.ITransferedData;
import com.nomagic.ci.persistence.resources.IProjectResourceManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MountableFeatureExtracter
extends DefaultFeatureExtracter {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MountableFeatureExtracter(IProject iProject, IMountingProjectFeatureHandler iMountingProjectFeatureHandler, Collection<? extends EObject> collection, Set<ProjectAttachmentConfiguration> set) {
        super(iProject, iMountingProjectFeatureHandler, (IDataTransferer)new DataMover(), collection, set);
        if (collection == null) throw new IllegalArgumentException();
        if (!collection.isEmpty()) return;
        throw new IllegalArgumentException();
    }

    @Override
    public IMountingProjectFeatureHandler getFeature() {
        return (IMountingProjectFeatureHandler)super.getFeature();
    }

    @Override
    public Set<SharePointData> extractSharePoints(IAttachedProject iAttachedProject, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        IMountingProjectFeatureHandler iMountingProjectFeatureHandler = this.getFeature();
        Collection<? extends EObject> collection = this.getScope();
        ITransferedData iTransferedData = this.getTransferedData();
        iProgressMonitor.beginTask("Creating share points: " + iMountingProjectFeatureHandler.getName() + "...", 100 * collection.size());
        try {
            HashSet<SharePointData> hashSet = new HashSet<SharePointData>();
            for (EObject eObject : collection) {
                String string = EcoreUtil.generateUUID();
                Map<String, String> map = iMountingProjectFeatureHandler.getDefaultOptions(eObject);
                SharePointData sharePointData = new SharePointData(iTransferedData.getTransfered(eObject), string, map, false);
                hashSet.add(sharePointData);
                iProgressMonitor.worked(100);
            }
            HashSet<SharePointData> hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    protected Resource getTargetResource(IProject iProject, Resource resource, EObject eObject, IProject iProject2) {
        IMountingProjectFeatureHandler iMountingProjectFeatureHandler = this.getFeature();
        IResourceNamingProvider iResourceNamingProvider = iMountingProjectFeatureHandler.getResourceNamingProvider(iProject);
        IProjectSharingManager iProjectSharingManager = (IProjectSharingManager)iProject.getService(IProjectSharingManager.class);
        String string = iProjectSharingManager.isResourceShared(resource) ? LocalProjectUtil.getResourceName(iProject, resource) : iResourceNamingProvider.getResourceNameShared(resource, eObject);
        String string2 = string;
        IProjectResourceManager iProjectResourceManager = FeatureResourceManagerFactory.getSharedResourceManager(iProject2, (IProjectFeatureDescriptor)iMountingProjectFeatureHandler);
        Resource resource2 = iProjectResourceManager.getResourceNames().contains(string2) ? this.getResource(iProjectResourceManager, string2) : iProjectResourceManager.createResource(string2);
        Resource resource3 = resource2;
        return resource3;
    }

    private Resource getResource(IProjectResourceManager iProjectResourceManager, String string) {
        Resource resource = iProjectResourceManager.getResource(string, false);
        if (resource == null) {
            resource = iProjectResourceManager.getResource(string, true);
        }
        return resource;
    }
}

