/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.decomposition;

import com.nomagic.ci.metamodel.project.util.CastUtil;
import com.nomagic.ci.persistence.DecompositionDescriptor;
import com.nomagic.ci.persistence.ProjectDescriptor;
import com.nomagic.ci.persistence.sharing.ISharePoint;
import com.nomagic.ci.persistence.versioning.IVersionDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class LocalDecompositionDescriptor
extends DecompositionDescriptor {
    private Collection<AttachedProjectDescriptor> attached;

    public LocalDecompositionDescriptor(ProjectDescriptor projectDescriptor, String string, Map<String, String> map, Collection<LocalProjectFeatureDescriptor> collection, Collection<AttachedProjectDescriptor> collection2) {
        super(projectDescriptor, string, map, (Collection)CastUtil.castListOrFail(DecompositionDescriptor.ProjectFeatureDescriptor.class, collection));
        this.attached = collection2;
    }

    public Collection<LocalProjectFeatureDescriptor> getFeatures() {
        return CastUtil.castListOrFail(LocalProjectFeatureDescriptor.class, (Collection)super.getFeatures());
    }

    public Collection<AttachedProjectDescriptor> getAttached() {
        return Collections.unmodifiableCollection(this.attached);
    }

    public static class AttachedProjectDescriptor {
        private URI locationURI;
        private URI projectURI;
        private boolean readOnly;
        private boolean reshared;
        private boolean resharedAutomatically;
        private boolean loadAutomatically;
        private boolean isAutomatic;
        private Map<String, String> properties;
        private IVersionDescriptor version;
        private List<MountPointDescriptor> mountPointDescriotorList;

        public AttachedProjectDescriptor(URI uRI, URI uRI2, boolean bl, boolean bl2, boolean bl3, boolean bl4, IVersionDescriptor iVersionDescriptor) {
            this(uRI, uRI2, bl, bl2, bl3, bl4, false, null, iVersionDescriptor, Collections.emptyList());
        }

        public AttachedProjectDescriptor(URI uRI, @CheckForNull URI uRI2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Map<String, String> map, IVersionDescriptor iVersionDescriptor, List<MountPointDescriptor> list) {
            this.locationURI = uRI;
            this.projectURI = uRI2 != null ? uRI2 : uRI;
            this.readOnly = bl;
            this.reshared = bl2;
            this.loadAutomatically = bl4;
            this.isAutomatic = bl5;
            this.properties = map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
            this.version = iVersionDescriptor;
            this.mountPointDescriotorList = list;
            this.resharedAutomatically = bl3;
        }

        public List<MountPointDescriptor> getMountPointDescriotorList() {
            return this.mountPointDescriotorList;
        }

        public URI getProjectLocationURI() {
            return this.locationURI;
        }

        public URI getProjectURI() {
            return this.projectURI;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public boolean isReshared() {
            return this.reshared;
        }

        public boolean isLoadAutomatically() {
            return this.loadAutomatically;
        }

        public boolean isAutomatic() {
            return this.isAutomatic;
        }

        public boolean isResharedAutomatically() {
            return this.resharedAutomatically;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public IVersionDescriptor getVersion() {
            return this.version;
        }

        public String getProjectID() {
            return this.properties.get("LOCAL_PROJECT_ID");
        }
    }

    public static class LocalProjectFeatureDescriptor
    extends DecompositionDescriptor.ProjectFeatureDescriptor {
        public LocalProjectFeatureDescriptor(String string, String string2, String string3, int n2, Collection<LocalResourceDescriptor> collection) {
            super(string, string2, string3, n2, (Collection)CastUtil.castListOrFail(DecompositionDescriptor.DataSetDescriptor.class, collection));
        }

        public Collection<LocalResourceDescriptor> getDataSets() {
            return CastUtil.castListOrFail(LocalResourceDescriptor.class, (Collection)super.getDataSets());
        }
    }

    public static class LocalResourceDescriptor
    extends DecompositionDescriptor.DataSetDescriptor {
        protected boolean shared;
        private Collection<SharePointDescriptor> sharePoints;

        public LocalResourceDescriptor(String string, boolean bl, Map<String, String> map, Collection<SharePointDescriptor> collection) {
            super(string, map);
            this.shared = bl;
            this.sharePoints = collection != null ? collection : Collections.emptyList();
        }

        public Collection<SharePointDescriptor> getSharePoints() {
            return Collections.unmodifiableCollection(this.sharePoints);
        }

        public boolean isShared() {
            return this.shared;
        }
    }

    public static class MountPointDescriptor {
        String mountedSharePointId;
        Map<String, String> options;

        public MountPointDescriptor(String string, Map<String, String> map) {
            this.mountedSharePointId = string;
            this.options = map;
        }

        public String getMountedSharePointId() {
            return this.mountedSharePointId;
        }

        public Map<String, String> getOptions() {
            return this.options;
        }
    }

    public static class SharePointDescriptor
    implements ISharePoint {
        private String ID;
        private Map<String, String> options;
        private EObject obj;
        private String fragment;

        SharePointDescriptor(String string, Map<String, String> map, EObject eObject) {
            this(string, map, eObject, null);
        }

        public SharePointDescriptor(String string, Map<String, String> map, EObject eObject, String string2) {
            this.ID = string;
            this.options = map;
            this.obj = eObject;
            this.fragment = string2;
        }

        @Override
        public String getID() {
            return this.ID;
        }

        @Override
        public Map<String, String> getOptions() {
            return this.options;
        }

        @Override
        public EObject getPoint() {
            return this.obj;
        }

        public String getPointURIFragment() {
            return this.fragment;
        }

        public String toString() {
            return String.format("[%s,%s]", this.ID, this.options);
        }
    }
}

