/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.decomposition.SubstituteObjectRegistry;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import com.nomagic.ci.persistence.features.IProjectFeatureHandler;
import com.nomagic.ci.persistence.local.decomposition.ICustomFeatureJoiner;
import com.nomagic.ci.persistence.local.migration.FeatureDataTransferer;
import com.nomagic.ci.persistence.local.mounting.IMountingProjectFeatureHandler;
import com.nomagic.ci.persistence.local.sharing.IObjectLevelSharingManager;
import com.nomagic.ci.persistence.local.sharing.IObjectLevelSharingManagerFactory;
import com.nomagic.ci.persistence.local.sharing.IProjectSharingManager;
import com.nomagic.ci.persistence.local.spi.InvalidProjectObjectException;
import com.nomagic.ci.persistence.local.spi.sharing.IObjectLevelSharingManagerWithLockingSupportInternal;
import com.nomagic.ci.persistence.migration.DataCopier;
import com.nomagic.ci.persistence.migration.DataMover;
import com.nomagic.ci.persistence.migration.IDataTransferer;
import com.nomagic.ci.persistence.migration.ITransferedData;
import com.nomagic.ci.persistence.sharing.ISharePoint;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class DefaultFeatureJoiner
extends FeatureDataTransferer
implements ICustomFeatureJoiner {
    private final IAttachedProject source;

    public DefaultFeatureJoiner(IAttachedProject iAttachedProject, IProjectFeatureHandler iProjectFeatureHandler) {
        this(iAttachedProject, iProjectFeatureHandler, (IDataTransferer)(DefaultFeatureJoiner.isMountingSupported(iProjectFeatureHandler) ? new DataMover() : new DataCopier()));
    }

    public DefaultFeatureJoiner(IAttachedProject iAttachedProject, IProjectFeatureHandler iProjectFeatureHandler, IDataTransferer iDataTransferer) {
        super((IProject)iAttachedProject, (IProjectFeatureDescriptor)iProjectFeatureHandler, iDataTransferer);
        this.source = iAttachedProject;
    }

    public IProjectFeatureHandler getFeature() {
        return (IProjectFeatureHandler)super.getFeature();
    }

    @Override
    protected Resource getTargetResource(IProject iProject, Resource resource, EObject eObject, IProject iProject2) {
        IProjectFeatureHandler iProjectFeatureHandler = this.getFeature();
        if (iProjectFeatureHandler instanceof IMountingProjectFeatureHandler) {
            return eObject.eContainer().eResource();
        }
        return super.getTargetResource(iProject, resource, eObject, iProject2);
    }

    @Override
    public void joinFeatureWith(IProject iProject, SubstituteObjectRegistry substituteObjectRegistry, IProgressMonitor iProgressMonitor) throws InvalidProjectObjectException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        IProjectFeatureHandler iProjectFeatureHandler = this.getFeature();
        iProgressMonitor.beginTask("Joining feature " + iProjectFeatureHandler.getName() + "...", 1000);
        try {
            Map<EObject, Map<String, String>> map = this.getSharesToRestore(iProject);
            this.transfer(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 900));
            substituteObjectRegistry.setSubstituted((IProjectFeatureDescriptor)this.getFeature(), this.getCopies());
            ITransferedData iTransferedData = this.getTransferedData();
            this.restoreShares(iProject, iTransferedData, map, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private Map<EObject, Map<String, String>> getSharesToRestore(IProject iProject) {
        Map<EObject, Map<String, String>> map = Collections.emptyMap();
        IProjectFeatureHandler iProjectFeatureHandler = this.getFeature();
        if (iProjectFeatureHandler instanceof IMountingProjectFeatureHandler && ((IProjectSharingManager)iProject.getService(IProjectSharingManager.class)).isProjectReshared((IProject)this.source)) {
            map = new HashMap<EObject, Map<String, String>>();
            IMountingProjectFeatureHandler iMountingProjectFeatureHandler = (IMountingProjectFeatureHandler)iProjectFeatureHandler;
            IObjectLevelSharingManager iObjectLevelSharingManager = ((IObjectLevelSharingManagerFactory)this.source.getService(IObjectLevelSharingManagerFactory.class)).createManager(iMountingProjectFeatureHandler);
            ISharePoint[] iSharePointArray = iObjectLevelSharingManager.getSharePoints();
            int n2 = iSharePointArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ISharePoint iSharePoint = iSharePointArray[n3];
                map.put(iSharePoint.getPoint(), iSharePoint.getOptions());
                ++n3;
            }
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void restoreShares(IProject iProject, ITransferedData iTransferedData, Map<EObject, Map<String, String>> map, IProgressMonitor iProgressMonitor) throws InvalidProjectObjectException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Establishing shares...", 100 * map.size());
        try {
            IProjectFeatureHandler iProjectFeatureHandler = this.getFeature();
            if (!(iProjectFeatureHandler instanceof IMountingProjectFeatureHandler)) return;
            IMountingProjectFeatureHandler iMountingProjectFeatureHandler = (IMountingProjectFeatureHandler)iProjectFeatureHandler;
            IObjectLevelSharingManagerWithLockingSupportInternal iObjectLevelSharingManagerWithLockingSupportInternal = (IObjectLevelSharingManagerWithLockingSupportInternal)((Object)((IObjectLevelSharingManagerFactory)iProject.getService(IObjectLevelSharingManagerFactory.class)).createManager(iMountingProjectFeatureHandler));
            for (Map.Entry<EObject, Map<String, String>> entry : map.entrySet()) {
                Map<String, String> map2 = entry.getValue();
                EObject eObject = entry.getKey();
                if (iTransferedData.getTransfered(eObject) == eObject && !iObjectLevelSharingManagerWithLockingSupportInternal.isShared(eObject)) {
                    iObjectLevelSharingManagerWithLockingSupportInternal.shareWithoutLock(eObject, map2, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                    continue;
                }
                iProgressMonitor.worked(100);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    public Set<EObject> getObjectsToModify(IProgressMonitor iProgressMonitor) {
        return Collections.emptySet();
    }

    static boolean isMountingSupported(IProjectFeatureHandler iProjectFeatureHandler) {
        return iProjectFeatureHandler instanceof IMountingProjectFeatureHandler;
    }
}

