/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.decomposition.ProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.decomposition.SubstituteObjectRegistry;
import com.nomagic.ci.persistence.features.IProjectFeature;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import com.nomagic.ci.persistence.features.IProjectFeatureHandler;
import com.nomagic.ci.persistence.local.decomposition.ILocalCustomFeatureExtracter;
import com.nomagic.ci.persistence.local.importers.SharePointData;
import com.nomagic.ci.persistence.local.migration.FeatureDataTransferer;
import com.nomagic.ci.persistence.migration.DataCopier;
import com.nomagic.ci.persistence.migration.DataMover;
import com.nomagic.ci.persistence.migration.IDataTransferer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class DefaultFeatureExtracter
extends FeatureDataTransferer
implements ILocalCustomFeatureExtracter {
    private Collection<? extends EObject> scope;
    private Set<ProjectAttachmentConfiguration> mandatoryUsages;

    public DefaultFeatureExtracter(IProject iProject, IProjectFeatureHandler iProjectFeatureHandler, Collection<? extends EObject> collection) {
        this(iProject, iProjectFeatureHandler, (IDataTransferer)new DataCopier(), collection, null);
    }

    public DefaultFeatureExtracter(IProject iProject, IProjectFeatureHandler iProjectFeatureHandler, IDataTransferer iDataTransferer, Collection<? extends EObject> collection, Set<ProjectAttachmentConfiguration> set) {
        super(iProject, (IProjectFeatureDescriptor)iProjectFeatureHandler, iDataTransferer);
        this.scope = collection;
        this.mandatoryUsages = set;
    }

    public IProjectFeatureHandler getFeature() {
        return (IProjectFeatureHandler)super.getFeature();
    }

    public Collection<? extends EObject> getScope() {
        return this.scope;
    }

    public IProjectFeature extractFeatureTo(IAttachedProject iAttachedProject, SubstituteObjectRegistry substituteObjectRegistry, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        IProjectFeatureHandler iProjectFeatureHandler = this.getFeature();
        iProgressMonitor.beginTask("Extracting feature: " + iProjectFeatureHandler.getName() + "...", 1000);
        try {
            this.transfer((IProject)iAttachedProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 800));
            substituteObjectRegistry.setSubstituted((IProjectFeatureDescriptor)this.getFeature(), this.getCopies());
            IProjectFeature iProjectFeature = iProjectFeatureHandler.read((IProject)iAttachedProject, (IProjectFeatureDescriptor)iProjectFeatureHandler);
            iProgressMonitor.worked(200);
            IProjectFeature iProjectFeature2 = iProjectFeature;
            return iProjectFeature2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    protected List<EObject> getSourceResourceScope(IProject iProject, Resource resource) {
        List<EObject> list = super.getSourceResourceScope(iProject, resource);
        if (this.scope != null) {
            list = new ArrayList<EObject>();
            for (EObject eObject : this.scope) {
                if (eObject.eResource() != resource) continue;
                list.add(eObject);
            }
        }
        return list;
    }

    @Override
    public Set<SharePointData> extractSharePoints(IAttachedProject iAttachedProject, IProgressMonitor iProgressMonitor) {
        return Collections.emptySet();
    }

    public Set<ProjectAttachmentConfiguration> getMandatoryAttachments(IAttachedProject iAttachedProject, IProgressMonitor iProgressMonitor) {
        return this.mandatoryUsages;
    }

    public Set<EObject> getObjectsToModify(IProgressMonitor iProgressMonitor) {
        return this.getObjectsToModify(null, iProgressMonitor);
    }

    public Set<EObject> getObjectsToModify(@CheckForNull Map<String, Object> map, IProgressMonitor iProgressMonitor) {
        Set<EObject> set = Collections.emptySet();
        if (this.transferMethod instanceof DataMover) {
            set = new HashSet<EObject>();
            set.addAll(this.scope);
            for (EObject eObject : this.scope) {
                EObject eObject2 = eObject.eContainer();
                if (eObject2 == null) continue;
                set.add(eObject2);
            }
        }
        return set;
    }
}

