/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local;

import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.IProjectRepositoryType;
import com.nomagic.ci.persistence.PersistencePlugin;
import com.nomagic.ci.persistence.local.spi.IProjectRepositoryInternal;
import com.nomagic.ci.services.ServicesDiscovery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

public class ProjectRepositoryRegistry {
    public static final String PROJECT_REPOSITORY_TYPES_EXTENSION_POINT = "com.nomagic.ci.persistence.projectRepositoryTypes";
    private static final Logger LOGGER = Logger.getLogger(ProjectRepositoryRegistry.class);
    private static final ProjectRepositoryRegistry INSTANCE = new ProjectRepositoryRegistry();
    private Set<IProjectRepository> projectRepositories = new HashSet<IProjectRepository>();

    static {
        PersistencePlugin.init();
    }

    private ProjectRepositoryRegistry() {
    }

    public static ProjectRepositoryRegistry getInstance() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Map<String, IProjectRepositoryType> getTypesMap() {
        HashMap<String, IProjectRepositoryType> hashMap = new HashMap<String, IProjectRepositoryType>();
        LOGGER.debug((Object)"Reading registry");
        Collection collection = ServicesDiscovery.INSTANCE.getServices(PROJECT_REPOSITORY_TYPES_EXTENSION_POINT);
        for (IProjectRepositoryType iProjectRepositoryType : collection) {
            if (IProjectRepositoryType.class.isInstance(iProjectRepositoryType)) {
                hashMap.put(iProjectRepositoryType.getId(), iProjectRepositoryType);
                continue;
            }
            LOGGER.error((Object)("Class '" + iProjectRepositoryType.getClass() + "' should implement '" + IProjectRepositoryType.class.getName() + "', but it doesn't."));
        }
        return hashMap;
    }

    public Collection<IProjectRepositoryType> getTypes() {
        return this.getTypesMap().values();
    }

    public IProjectRepositoryType getType(String string) {
        return this.getTypesMap().get(string);
    }

    public void register(IProjectRepository iProjectRepository) {
        LOGGER.debug((Object)("project repository registered: " + iProjectRepository.toString()));
        IProjectRepository iProjectRepository2 = this.getProjectRepositoryByType(iProjectRepository.getType());
        if (iProjectRepository2 != null) {
            throw new IllegalStateException(String.format("Project repository %s is already registered. First you need to unregister it.", iProjectRepository.getType().getId()));
        }
        this.projectRepositories.add(iProjectRepository);
    }

    public boolean unregister(IProjectRepository iProjectRepository) {
        LOGGER.debug((Object)("project repository unregistered: " + iProjectRepository.toString()));
        return this.projectRepositories.remove(iProjectRepository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<IProjectRepository> getProjectRepositoriesByType(IProjectRepositoryType iProjectRepositoryType) {
        List<IProjectRepository> list = Collections.emptyList();
        for (IProjectRepository iProjectRepository : this.projectRepositories) {
            if (!iProjectRepository.getType().getId().equals(iProjectRepositoryType.getId())) continue;
            if (list.isEmpty()) {
                list = new ArrayList<IProjectRepository>();
            }
            list.add(iProjectRepository);
        }
        return list;
    }

    @CheckForNull
    public IProjectRepository getProjectRepositoryByType(IProjectRepositoryType iProjectRepositoryType) {
        Collection<IProjectRepository> collection = this.getProjectRepositoriesByType(iProjectRepositoryType);
        IProjectRepository iProjectRepository = collection.isEmpty() ? null : collection.iterator().next();
        return iProjectRepository;
    }

    @CheckForNull
    public IProjectRepository getProjectRepositoryByTypeId(String string) {
        IProjectRepositoryType iProjectRepositoryType = this.getType(string);
        return this.getProjectRepositoryByType(iProjectRepositoryType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<IProjectRepositoryType> getSupportingRepositoryTypes(URI uRI) {
        ArrayList<IProjectRepositoryType> arrayList = new ArrayList<IProjectRepositoryType>();
        for (IProjectRepositoryType iProjectRepositoryType : this.getTypes()) {
            if (!iProjectRepositoryType.isResourceSupported(uRI)) continue;
            arrayList.add(iProjectRepositoryType);
        }
        return arrayList;
    }

    @CheckForNull
    public IProjectRepository getProjectRepository(URI uRI) {
        Collection<IProjectRepositoryType> collection = this.getSupportingRepositoryTypes(uRI);
        for (IProjectRepositoryType iProjectRepositoryType : collection) {
            IProjectRepository iProjectRepository = this.getProjectRepository(iProjectRepositoryType, uRI);
            if (iProjectRepository == null || !iProjectRepository.canOpenProject(uRI)) continue;
            return iProjectRepository;
        }
        return null;
    }

    @CheckForNull
    public IProjectRepository getLocationRepository(URI uRI) {
        Collection<IProjectRepositoryType> collection = this.getSupportingRepositoryTypes(uRI);
        for (IProjectRepositoryType iProjectRepositoryType : collection) {
            IProjectRepository iProjectRepository = this.getProjectRepository(iProjectRepositoryType, uRI);
            if (iProjectRepository == null) continue;
            return iProjectRepository;
        }
        return null;
    }

    @CheckForNull
    private IProjectRepository getProjectRepository(IProjectRepositoryType iProjectRepositoryType, URI uRI) {
        for (IProjectRepository iProjectRepository : this.getProjectRepositoriesByType(iProjectRepositoryType)) {
            if (!(iProjectRepository instanceof IProjectRepositoryInternal)) continue;
            return iProjectRepository;
        }
        return null;
    }
}

