/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local;

import com.nomagic.ci.persistence.ProjectOptions;
import com.nomagic.ci.persistence.local.proxy.SnapshotPreprocessor;
import com.nomagic.ci.persistence.local.proxy.ValueFilter;
import com.nomagic.ci.persistence.local.spi.proxy.PackageURIRemapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LocalProjectOptions
extends ProjectOptions {
    private boolean enableProxyService = false;
    private boolean preloadProject = false;
    private LoadMode loadMode;
    private Set<ValueFilter> proxyValueFilters;
    private List<PackageURIRemapper> packageURIRemappers;
    private boolean treeUpdatedBeforeSave = false;
    private Set<SnapshotPreprocessor> preProcessorSet = new HashSet<SnapshotPreprocessor>();

    public LocalProjectOptions() {
        this.loadMode = LoadMode.DEFAULT;
    }

    public boolean getEnableProxyService() {
        return this.enableProxyService;
    }

    public void setEnableProxyService(boolean bl) {
        this.enableProxyService = bl;
    }

    public boolean getPreloadProject() {
        return this.preloadProject;
    }

    public void setPreloadProject(boolean bl) {
        this.preloadProject = bl;
    }

    public LoadMode getAttachedProjectLoadMode() {
        return this.loadMode;
    }

    public void setAttachedProjectLoadMode(LoadMode loadMode) {
        this.loadMode = loadMode;
    }

    public boolean isTreeUpdatedBeforeSave() {
        return this.treeUpdatedBeforeSave;
    }

    public void setTreeUpdatedBeforeSave(boolean bl) {
        this.treeUpdatedBeforeSave = bl;
    }

    public void fillCopy(ProjectOptions projectOptions) {
        super.fillCopy(projectOptions);
        if (projectOptions instanceof LocalProjectOptions) {
            LocalProjectOptions localProjectOptions = (LocalProjectOptions)projectOptions;
            localProjectOptions.enableProxyService = this.enableProxyService;
            localProjectOptions.preloadProject = this.preloadProject;
            localProjectOptions.loadMode = this.loadMode;
            localProjectOptions.treeUpdatedBeforeSave = this.treeUpdatedBeforeSave;
            localProjectOptions.getProxyValueFilters().addAll(this.getProxyValueFilters());
            localProjectOptions.getPackageURIRemappers().addAll(this.getPackageURIRemappers());
            localProjectOptions.getSnapshotPreprocessors().addAll(this.getSnapshotPreprocessors());
        }
    }

    public LocalProjectOptions createCopy() {
        return (LocalProjectOptions)super.createCopy();
    }

    public static LocalProjectOptions adapt(ProjectOptions projectOptions) {
        if (projectOptions instanceof LocalProjectOptions) {
            return (LocalProjectOptions)projectOptions;
        }
        LocalProjectOptions localProjectOptions = new LocalProjectOptions();
        projectOptions.fillCopy((ProjectOptions)localProjectOptions);
        return localProjectOptions;
    }

    public Set<ValueFilter> getProxyValueFilters() {
        if (this.proxyValueFilters == null) {
            this.proxyValueFilters = new HashSet<ValueFilter>();
            return this.proxyValueFilters;
        }
        return this.proxyValueFilters;
    }

    public List<PackageURIRemapper> getPackageURIRemappers() {
        if (this.packageURIRemappers == null) {
            this.packageURIRemappers = new ArrayList<PackageURIRemapper>();
        }
        return this.packageURIRemappers;
    }

    public void addPreprocessor(SnapshotPreprocessor snapshotPreprocessor) {
        this.preProcessorSet.add(snapshotPreprocessor);
    }

    public void removePreprocessor(SnapshotPreprocessor snapshotPreprocessor) {
        this.preProcessorSet.remove(snapshotPreprocessor);
    }

    public Set<SnapshotPreprocessor> getSnapshotPreprocessors() {
        return this.preProcessorSet;
    }

    public static enum LoadMode {
        DEFAULT,
        SKIP,
        FORCE;

    }
}

