/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceException;

public class IllegalProjectStateException
extends PersistenceException {
    private static final long serialVersionUID = 1L;
    private final IProject project;
    private final IllegalState illegalState;

    public IllegalProjectStateException(IProject iProject, IllegalState illegalState) {
        super(String.format(illegalState.getFormatString(), iProject.getName()));
        this.project = iProject;
        this.illegalState = illegalState;
    }

    public IllegalProjectStateException(IProject iProject, IllegalState illegalState, Throwable throwable) {
        super(String.format(illegalState.getFormatString(), iProject.getName()), throwable);
        this.project = iProject;
        this.illegalState = illegalState;
    }

    public IProject getProject() {
        return this.project;
    }

    public IllegalState getIllegalState() {
        return this.illegalState;
    }

    public static enum IllegalState {
        READ_ONLY{

            @Override
            public String getFormatString() {
                return "The project %s is read only";
            }
        }
        ,
        READ_WRITE{

            @Override
            public String getFormatString() {
                return "The project %s is read write";
            }
        }
        ,
        NOT_LOADED{

            @Override
            public String getFormatString() {
                return "The project %s is not loaded";
            }
        };


        public abstract String getFormatString();
    }
}

