/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.versioning;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.versioning.IHistoricalProject;
import com.nomagic.ci.persistence.versioning.IVersionDescriptor;
import com.nomagic.ci.persistence.versioning.IVersionableProjectRepository;
import com.nomagic.ci.persistence.versioning.IVersioningService;
import com.nomagic.ci.persistence.versioning.VersioningNotSupportedException;

public class Versioning {
    private static void checkVersioningSupport(IProjectRepository iProjectRepository) {
        if (iProjectRepository.getService(IVersionableProjectRepository.class) == null) {
            throw new VersioningNotSupportedException();
        }
    }

    public static IVersionableProjectRepository get(IProjectRepository iProjectRepository) {
        Versioning.checkVersioningSupport(iProjectRepository);
        return (IVersionableProjectRepository)((Object)iProjectRepository);
    }

    public static IVersioningService get(IProject iProject) {
        return iProject.getService(IVersioningService.class);
    }

    public static IVersionDescriptor getVersion(IProject iProject) {
        IVersioningService iVersioningService = iProject.getService(IVersioningService.class);
        IVersionDescriptor iVersionDescriptor = iVersioningService == null ? null : iVersioningService.getVersion();
        return iVersionDescriptor;
    }

    public static boolean isHistorical(IProject iProject) {
        IHistoricalProject iHistoricalProject = iProject.getService(IHistoricalProject.class);
        boolean bl = iHistoricalProject == null ? false : iHistoricalProject.isHistorical();
        return bl;
    }

    public static boolean isLatestVersion(IProject iProject) {
        IHistoricalProject iHistoricalProject = iProject.getService(IHistoricalProject.class);
        boolean bl = iHistoricalProject == null ? true : iHistoricalProject.isLatestVersion();
        return bl;
    }
}

