/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.util;

import com.nomagic.ci.metamodel.project.AbstractProjectUsage;
import com.nomagic.ci.persistence.EObjectProjectProvider;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.features.EObjectDataSetProvider;
import com.nomagic.ci.persistence.features.FeatureDataSet;
import com.nomagic.ci.persistence.spi.IAttachedProjectStateService;
import com.nomagic.ci.persistence.spi.IAttachedProjectStateServiceInternal;
import com.nomagic.ci.persistence.spi.ProjectAvailabilityService;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManagerInternal;
import com.nomagic.ci.persistence.spi.decomposition.ManualReachabilityCalculator;
import com.nomagic.ci.services.SingletonServiceDiscovery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.emf.ecore.EObject;

public class ProjectUtil {
    @CheckForNull
    public static IProject getProject(EObject eObject) {
        EObjectProjectProvider eObjectProjectProvider;
        if (eObject != null && (eObjectProjectProvider = (EObjectProjectProvider)SingletonServiceDiscovery.INSTANCE.getService(EObjectProjectProvider.class)) != null) {
            IProject iProject = eObjectProjectProvider.getProject(eObject);
            return iProject;
        }
        return null;
    }

    public static IPrimaryProject getPrimaryProject(IProject iProject) {
        if (iProject instanceof IAttachedProject) {
            IAttachedProject iAttachedProject = (IAttachedProject)iProject;
            return iAttachedProject.getPrimaryProject();
        }
        return (IPrimaryProject)iProject;
    }

    public static List<IProject> getProjects(IPrimaryProject iPrimaryProject) {
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        arrayList.add(iPrimaryProject);
        arrayList.addAll(iPrimaryProject.getProjects());
        return arrayList;
    }

    public static IProject findProjectByID(IPrimaryProject iPrimaryProject, String string) {
        if (iPrimaryProject != null) {
            for (IProject iProject : ProjectUtil.getProjects(iPrimaryProject)) {
                if (!iProject.getProjectID().equals(string)) continue;
                return iProject;
            }
        }
        return null;
    }

    public static IProject findFirstUsingProject(@Nonnull IAttachedProject iAttachedProject) {
        IPrimaryProject iPrimaryProject = iAttachedProject.getPrimaryProject();
        if (iPrimaryProject == null) {
            throw new IllegalStateException("Primary project is null");
        }
        IProject[] iProjectArray = new IProject[1];
        IProject iProject = ProjectUtil.findFirstUsingProject(iAttachedProject, iPrimaryProject, new HashSet<IProject>(), new HashSet<IProject>(), false, iProjectArray);
        IProject iProject2 = iProject != null ? iProject : iProjectArray[0];
        return iProject2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IProject findFirstUsingProject(IAttachedProject iAttachedProject, IProject iProject, Set<IProject> set, Set<IProject> set2, boolean bl, IProject[] iProjectArray) {
        set.add(iProject);
        if (!bl) {
            set2.add(iProject);
        }
        if (!ProjectUtil.isProjectLoaded(iProject)) {
            throw new IllegalArgumentException("startSearchFrom project has to be loaded");
        }
        IProjectDecompositionManager iProjectDecompositionManager = iProject.getServiceOrFail(IProjectDecompositionManager.class);
        Map<IProject, AbstractProjectAttachmentConfiguration> map = iProjectDecompositionManager.getAttachedProjects();
        if (map.containsKey(iAttachedProject)) {
            if (!bl && ProjectUtil.isProjectUsageManual(iProject, iAttachedProject)) {
                return iProject;
            }
            if (iProjectArray[0] == null) {
                iProjectArray[0] = iProject;
            }
        }
        for (Map.Entry<IProject, AbstractProjectAttachmentConfiguration> entry : map.entrySet()) {
            IProject iProject2;
            boolean bl2;
            IProject iProject3 = entry.getKey();
            boolean bl3 = bl2 = bl || !ProjectUtil.isProjectUsageManual(iProject, iProject3);
            if (!ProjectUtil.isProjectLoaded(iProject3) || (!bl2 || iProjectArray[0] != null || set.contains(iProject3)) && (bl2 || set2.contains(iProject3)) || (iProject2 = ProjectUtil.findFirstUsingProject(iAttachedProject, iProject3, set, set2, bl2, iProjectArray)) == null) continue;
            return iProject2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isProjectLoaded(IProject iProject) {
        IAttachedProjectStateService iAttachedProjectStateService;
        ProjectAvailabilityService projectAvailabilityService = iProject.getService(ProjectAvailabilityService.class);
        if (projectAvailabilityService != null && !projectAvailabilityService.isProjectAvailable()) {
            return false;
        }
        return !(iProject instanceof IAttachedProject) || (iAttachedProjectStateService = iProject.getService(IAttachedProjectStateService.class)) == null || !((IAttachedProjectStateServiceInternal)iAttachedProjectStateService).isUnloading();
    }

    public static boolean isProjectUsageManual(@Nonnull IProject iProject, @Nonnull IProject iProject2) {
        IProjectUsageManagerInternal iProjectUsageManagerInternal = (IProjectUsageManagerInternal)iProject.getServiceOrFail(IProjectUsageManager.class);
        Object t = iProjectUsageManagerInternal.getProjectUsage(iProject2);
        if (t == null) {
            throw new IllegalStateException(String.format("There is no usage between projects '%s' and '%s'.", iProject.getName(), iProject2.getName()));
        }
        ManualReachabilityCalculator.AttachmentData attachmentData = iProjectUsageManagerInternal.convertToAttachmentData((AbstractProjectUsage)t);
        return ManualReachabilityCalculator.isAttachmentManual(ProjectUtil.getPrimaryProject(iProject), iProject, attachmentData);
    }

    public static boolean isProjectUsageManual(IProject iProject, AbstractProjectUsage abstractProjectUsage) {
        IProjectUsageManagerInternal iProjectUsageManagerInternal = (IProjectUsageManagerInternal)iProject.getServiceOrFail(IProjectUsageManager.class);
        ManualReachabilityCalculator.AttachmentData attachmentData = iProjectUsageManagerInternal.convertToAttachmentData(abstractProjectUsage);
        return ManualReachabilityCalculator.isAttachmentManual(ProjectUtil.getPrimaryProject(iProject), iProject, attachmentData);
    }

    @CheckForNull
    public static FeatureDataSet getFeatureDataSet(EObject eObject) {
        IProject iProject = ProjectUtil.getProject(eObject);
        if (iProject != null) {
            EObjectDataSetProvider eObjectDataSetProvider = iProject.getService(EObjectDataSetProvider.class);
            if (eObjectDataSetProvider != null) {
                return eObjectDataSetProvider.getFeatureDataSet(eObject);
            }
        }
        return null;
    }

    public static class AttachmentDataImpl
    implements ManualReachabilityCalculator.AttachmentData {
        private boolean automatic;
        private boolean reshared;
        private boolean resharedAutomatically;

        public AttachmentDataImpl(boolean bl, boolean bl2, boolean bl3) {
            this.automatic = bl;
            this.reshared = bl2;
            this.resharedAutomatically = bl3;
        }

        @Override
        public boolean isAutomatic() {
            return this.automatic;
        }

        @Override
        public boolean isReshared() {
            return this.reshared;
        }

        @Override
        public boolean isResharedAutomatically() {
            return this.resharedAutomatically;
        }
    }
}

