/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MultiValueHashMap<K, V>
extends HashMap<K, Set<V>> {
    private static final long serialVersionUID = -3656821720900933363L;

    public void append(K k, V v) {
        Set<V> set = (Set<V>)this.get(k);
        if (set == null || set.isEmpty()) {
            set = Collections.singleton(v);
            this.put(k, set);
        } else {
            if (set.size() == 1) {
                set = new HashSet<V>(set);
                this.put(k, set);
            }
            set.add(v);
        }
    }

    public void touch(K k) {
        Set set = (Set)this.get(k);
        if (set == null) {
            set = Collections.emptySet();
            this.put(k, set);
        }
    }

    public void subtract(K k, V v) {
        Set set = (Set)this.get(k);
        if (set != null && !set.isEmpty() && set.contains(v)) {
            if (set.size() == 1) {
                this.remove(k);
            } else {
                set.remove(v);
            }
        }
    }
}

