/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.lock;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.features.AbstractFeatureException;
import com.nomagic.ci.persistence.spi.features.AbstractFeatureInitializer;
import com.nomagic.ci.persistence.spi.features.IProjectFeatureRegistry;
import com.nomagic.ci.persistence.spi.lock.FeatureChangeDecompositionLocker;
import com.nomagic.ci.persistence.spi.lock.ILockFailureHandler;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class FeatureInitializerWithLockingSupport
extends AbstractFeatureInitializer {
    protected FeatureChangeDecompositionLocker decompositionLocker;

    public FeatureInitializerWithLockingSupport(IProject iProject, IProjectFeatureRegistry iProjectFeatureRegistry) {
        super(iProject, iProjectFeatureRegistry);
        this.decompositionLocker = this.createFeatureChangeDecompositionLocker(iProject);
    }

    protected FeatureChangeDecompositionLocker createFeatureChangeDecompositionLocker(IProject iProject) {
        return new FeatureChangeDecompositionLocker(iProject, ILockFailureHandler.INSTANCE);
    }

    @Override
    public void install(Set<String> set, IProgressMonitor iProgressMonitor) throws AbstractFeatureException {
        this.decompositionLocker.checkAndHandle(set, true);
        Set<String> set2 = set.stream().filter(string -> {
            boolean bl = !this.isFeatureInstalled((String)string);
            return bl;
        }).collect(Collectors.toSet());
        if (!set2.isEmpty()) {
            super.install(set2, iProgressMonitor);
        }
    }

    @Override
    public void uninstall(Set<String> set, IProgressMonitor iProgressMonitor) throws AbstractFeatureException {
        this.decompositionLocker.checkAndHandle(set, false);
        Set<String> set2 = set.stream().filter(string -> this.isFeatureInstalled((String)string)).collect(Collectors.toSet());
        if (!set2.isEmpty()) {
            super.uninstall(set2, iProgressMonitor);
        }
    }
}

