/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.lock;

import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.lock.DecompositionLockException;
import com.nomagic.ci.persistence.lock.IDecompositionLockService;
import com.nomagic.ci.persistence.lock.ILockManager;
import com.nomagic.ci.persistence.lock.Locking;
import com.nomagic.ci.persistence.lock.ProjectUsageLockException;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DecompositionLockHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkDecompositionLock(IProject iProject, boolean bl) {
        String string;
        if (iProject != null) {
            if (iProject.isNew()) return;
            if (iProject.isReadOnly()) {
                return;
            }
        }
        ILockManager iLockManager = Locking.getLockManager(iProject);
        IDecompositionLockService iDecompositionLockService = Locking.getDecompositionLockService(iProject);
        IDecompositionLockService.IDecompositionLock iDecompositionLock = iDecompositionLockService.getLock();
        if (iDecompositionLock == null) {
            if (!bl) throw new DecompositionLockException("Cannot obtain decomposition lock", null);
            iDecompositionLock = iDecompositionLockService.lock();
            if (iDecompositionLock == null) throw new DecompositionLockException("Cannot obtain decomposition lock", null);
            return;
        }
        if (iLockManager.isMyLock(iDecompositionLock)) {
            return;
        }
        String string2 = iDecompositionLock.getUser() != null ? iDecompositionLock.getUser().getName() : null;
        StringBuilder stringBuilder = new StringBuilder("Cannot obtain decomposition lock Project ");
        if (iProject != null) {
            string = iProject.getName();
            throw new DecompositionLockException(stringBuilder.append(string).append(" is locked by user ").append(string2).toString(), string2);
        }
        string = null;
        throw new DecompositionLockException(stringBuilder.append(string).append(" is locked by user ").append(string2).toString(), string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkUsageLock(IProject iProject, IProject iProject2, boolean bl) {
        if (iProject.isNew() || iProject2.isNew() || iProject.isReadOnly()) {
            return;
        }
        ILockManager iLockManager = Locking.getLockManager(iProject);
        IDecompositionLockService iDecompositionLockService = Locking.getDecompositionLockService(iProject);
        IDecompositionLockService.IProjectUsageLock iProjectUsageLock = iDecompositionLockService.getUsageLock(iProject2);
        if (iProjectUsageLock == null ? bl && (iProjectUsageLock = iDecompositionLockService.lockUsage(iProject2)) != null : iLockManager.isMyLock(iProjectUsageLock)) {
            return;
        }
        String string = DecompositionLockHelper.getUsageDetails(iProject, iProject2);
        throw new ProjectUsageLockException(iProject2, iProject2.getLocationURI(), iProjectUsageLock, null, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static String getUsageDetails(IProject iProject, IProject iProject2) {
        IProjectUsageManager iProjectUsageManager = iProject.getService(IProjectUsageManager.class);
        if (iProjectUsageManager == null) return null;
        Object t = iProjectUsageManager.getProjectUsage(iProject2);
        if (t == null) return null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Details: (project is primary)=").append(iProject instanceof IPrimaryProject);
        stringBuilder.append(", (attached is primary)=").append(iProject2 instanceof IPrimaryProject);
        stringBuilder.append(", attached.locationURI=").append(iProject2.getLocationURI());
        stringBuilder.append(", usage details=[");
        EClass eClass = t.eClass();
        Iterator iterator = eClass.getEAllAttributes().iterator();
        while (iterator.hasNext()) {
            EAttribute eAttribute = (EAttribute)iterator.next();
            stringBuilder.append(eAttribute.getName()).append("=");
            Object object = t.eGet((EStructuralFeature)eAttribute);
            stringBuilder.append(String.valueOf(object));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

