/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.features;

import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.features.IProjectFeature;
import com.nomagic.ci.persistence.spi.features.IProjectFeatureRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultProjectFeatureRegistry
implements IProjectFeatureRegistry {
    protected Map<Class<? extends IProjectFeature>, IProjectFeature> featureMap = new HashMap<Class<? extends IProjectFeature>, IProjectFeature>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addFeature(IProjectFeature iProjectFeature) throws ProjectConfigurationException {
        if (iProjectFeature.getDescriptor() == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = iProjectFeature.getClass();
        IProjectFeature iProjectFeature2 = this.featureMap.get(clazz);
        if (iProjectFeature2 != null && !iProjectFeature2.getDescriptor().getNamespace().equals(iProjectFeature.getDescriptor().getNamespace())) {
            throw new ProjectConfigurationException("Feature: [class = " + clazz + "] is already installed by " + iProjectFeature2.getDescriptor().getName());
        }
        this.featureMap.put(clazz, iProjectFeature);
    }

    @Override
    public void removeFeature(IProjectFeature iProjectFeature) throws ProjectConfigurationException {
        Class<?> clazz = iProjectFeature.getClass();
        this.featureMap.remove(clazz);
    }

    @Override
    public <T extends IProjectFeature> T getFeature(Class<T> clazz) {
        return (T)this.featureMap.get(clazz);
    }

    @Override
    public IProjectFeature getFeature(String string) {
        for (IProjectFeature iProjectFeature : this.featureMap.values()) {
            if (!iProjectFeature.getDescriptor().getName().equals(string)) continue;
            return iProjectFeature;
        }
        return null;
    }

    @Override
    public Collection<IProjectFeature> getFeatures() {
        return Collections.unmodifiableCollection(this.featureMap.values());
    }
}

