/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.features;

import com.nomagic.ci.metamodel.project.Project;
import com.nomagic.ci.metamodel.project.ProjectFeature;
import com.nomagic.ci.metamodel.project.util.DecompositionModelUtil;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.ProjectConfigurationException;
import com.nomagic.ci.persistence.features.AbstractFeatureException;
import com.nomagic.ci.persistence.features.IProjectFeature;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import com.nomagic.ci.persistence.features.IProjectFeatureHandler;
import com.nomagic.ci.persistence.features.IProjectFeatureHandlerService;
import com.nomagic.ci.persistence.spi.decomposition.DecompositionModelFactory;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import com.nomagic.ci.persistence.spi.features.IProjectFeatureRegistry;
import com.nomagic.ci.services.SingletonServiceDiscovery;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractFeatureInitializer {
    protected IProject project;
    protected IProjectFeatureRegistry registry;
    private EventSupport[] eventSupport;

    public AbstractFeatureInitializer(IProject iProject, IProjectFeatureRegistry iProjectFeatureRegistry) {
        this.project = iProject;
        this.registry = iProjectFeatureRegistry;
    }

    private DecompositionModelFactory getModelFactory() {
        DecompositionModelFactory decompositionModelFactory = this.project.getServiceOrFail(DecompositionModelFactory.class);
        return decompositionModelFactory;
    }

    private IDecompositionModel getDecompositionModel() {
        IDecompositionModel iDecompositionModel = this.project.getServiceOrFail(IDecompositionModel.class);
        return iDecompositionModel;
    }

    @Nonnull
    protected ProjectFeature addProjectFeature(IProjectFeatureDescriptor iProjectFeatureDescriptor) {
        IDecompositionModel iDecompositionModel = this.getDecompositionModel();
        Project project = iDecompositionModel.getDecompositionProject();
        String string = iProjectFeatureDescriptor.getNamespace();
        ProjectFeature projectFeature = DecompositionModelUtil.findProjectFeature((Project)project, (String)string);
        if (projectFeature != null) {
            throw new IllegalArgumentException("Feature " + string + " is already exists");
        }
        DecompositionModelFactory decompositionModelFactory = this.getModelFactory();
        projectFeature = decompositionModelFactory.createProjectFeature();
        projectFeature.setProject(project);
        AbstractFeatureInitializer.updateFeature(projectFeature, iProjectFeatureDescriptor);
        return projectFeature;
    }

    protected boolean isFeatureInstalled(String string) {
        IProjectFeatureHandlerService iProjectFeatureHandlerService = (IProjectFeatureHandlerService)SingletonServiceDiscovery.INSTANCE.getService(IProjectFeatureHandlerService.class);
        IDecompositionModel iDecompositionModel = this.getDecompositionModel();
        Project project = iDecompositionModel.getDecompositionProject();
        IProjectFeatureHandler iProjectFeatureHandler = iProjectFeatureHandlerService.getHandler(string);
        if (DecompositionModelUtil.findProjectFeature((Project)project, (String)iProjectFeatureHandler.getNamespace()) != null) {
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void install(Set<String> set, @CheckForNull IProgressMonitor iProgressMonitor) throws AbstractFeatureException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("Install features...", 1000);
        try {
            IProjectFeatureHandlerService iProjectFeatureHandlerService = (IProjectFeatureHandlerService)SingletonServiceDiscovery.INSTANCE.getService(IProjectFeatureHandlerService.class);
            IDecompositionModel iDecompositionModel = this.getDecompositionModel();
            Project project = iDecompositionModel.getDecompositionProject();
            int n = set.size();
            int n2 = 0;
            int n3 = 0;
            if (n == 0) {
                iProgressMonitor.worked(500);
            } else {
                n2 = 500 / n;
                n3 = 500 % n;
            }
            for (String string : set) {
                iProgressMonitor.worked(n2);
                IProjectFeatureHandler iProjectFeatureHandler = iProjectFeatureHandlerService.getHandler(string);
                if (iProjectFeatureHandler == null) {
                    throw new ProjectConfigurationException("The handler for feature " + string + " is not registered");
                }
                ProjectFeature projectFeature = DecompositionModelUtil.findProjectFeature((Project)project, (String)iProjectFeatureHandler.getNamespace());
                if (projectFeature == null) continue;
                throw new ProjectConfigurationException("The feature " + iProjectFeatureHandler.getName() + " is already installed");
            }
            iProgressMonitor.worked(n3);
            List<IProjectFeatureHandler> list = iProjectFeatureHandlerService.getHandlers(set);
            int n4 = list.size();
            if (n4 == 0) {
                iProgressMonitor.worked(500);
            } else {
                n2 = 500 / n4;
                n3 = 500 % n4;
            }
            for (IProjectFeatureHandler iProjectFeatureHandler : list) {
                EventSupport eventSupport;
                iProgressMonitor.worked(n2);
                ProjectFeature projectFeature = DecompositionModelUtil.findProjectFeature((Project)project, (String)iProjectFeatureHandler.getNamespace());
                if (projectFeature != null) continue;
                this.addProjectFeature(iProjectFeatureHandler);
                IProjectFeature iProjectFeature = iProjectFeatureHandler.install(this.project);
                if (iProjectFeature != null) {
                    this.registry.addFeature(iProjectFeature);
                }
                if ((eventSupport = this.getEventSupport()) == null) continue;
                eventSupport.featureInstalled(iProjectFeatureHandler);
            }
            iProgressMonitor.worked(n3);
            if (list.size() != 0) return;
            iProgressMonitor.worked(500);
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @CheckForNull
    private EventSupport getEventSupport() {
        if (this.eventSupport == null) {
            this.eventSupport = new EventSupport[1];
            this.eventSupport[0] = this.createEventSupport();
        }
        return this.eventSupport[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstall(Set<String> set, IProgressMonitor iProgressMonitor) throws AbstractFeatureException {
        Object object;
        IProjectFeatureHandler iProjectFeatureHandler;
        IProjectFeatureHandlerService iProjectFeatureHandlerService = (IProjectFeatureHandlerService)SingletonServiceDiscovery.INSTANCE.getService(IProjectFeatureHandlerService.class);
        List<IProjectFeatureHandler> list = iProjectFeatureHandlerService.getInverseHandlers(set);
        IDecompositionModel iDecompositionModel = this.getDecompositionModel();
        Project project = iDecompositionModel.getDecompositionProject();
        for (String string : set) {
            iProjectFeatureHandler = iProjectFeatureHandlerService.getHandler(string);
            object = DecompositionModelUtil.findProjectFeature((Project)project, (String)iProjectFeatureHandler.getNamespace());
            if (object != null) continue;
            throw new ProjectConfigurationException("The feature " + iProjectFeatureHandler.getName() + " was not installed");
        }
        for (IProjectFeatureHandler iProjectFeatureHandler2 : list) {
            Object object22;
            iProjectFeatureHandler = DecompositionModelUtil.findProjectFeature((Project)project, (String)iProjectFeatureHandler2.getNamespace());
            if (iProjectFeatureHandler == null) continue;
            object = AbstractFeatureInitializer.findProjectFeature(this.registry, iProjectFeatureHandler2);
            if (this.project != null) {
                this.registry.removeFeature((IProjectFeature)object);
            }
            iProjectFeatureHandler2.uninstall(this.project);
            this.removeFeatureResources(iProjectFeatureHandler2);
            for (Object object22 : iProjectFeatureHandler.getSections()) {
                object22.setProject(null);
                if (object22.getBelongsTo() == null) continue;
                object22.setBelongsTo(null);
            }
            iProjectFeatureHandler.setProject(null);
            object22 = this.getEventSupport();
            if (object22 == null) continue;
            object22.featureUninstalled((ProjectFeature)iProjectFeatureHandler);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Map.Entry<ProjectFeature, IProjectFeatureHandler>> getAvailableFeatureHandlers(IProject iProject) {
        String string;
        AbstractCollection abstractCollection;
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        IProjectFeatureHandlerService iProjectFeatureHandlerService = (IProjectFeatureHandlerService)SingletonServiceDiscovery.INSTANCE.getService(IProjectFeatureHandlerService.class);
        IDecompositionModel iDecompositionModel = iProject.getService(IDecompositionModel.class);
        if (iDecompositionModel != null && iDecompositionModel.isAvailable()) {
            object = iDecompositionModel.getDecompositionProject();
            abstractCollection = new HashSet();
            for (Object object2 : object.getFeatures()) {
                string = object2.getName();
                IProjectFeatureHandler iProjectFeatureHandler = iProjectFeatureHandlerService.getHandler(string);
                if (iProjectFeatureHandler == null || !Collections.disjoint(abstractCollection, AbstractFeatureInitializer.getDependencies(iProjectFeatureHandler))) {
                    abstractCollection.add(string);
                    continue;
                }
                hashMap.put(string, object2);
            }
        }
        if (hashMap.isEmpty()) {
            return Collections.emptyList();
        }
        object = iProjectFeatureHandlerService.getHandlers(hashMap.keySet());
        abstractCollection = new ArrayList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object2 = (IProjectFeatureHandler)iterator.next();
            string = (ProjectFeature)hashMap.get(object2.getName());
            abstractCollection.add(new AbstractMap.SimpleEntry<String, Object>(string, object2));
        }
        return abstractCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(@CheckForNull ReadCoordinator readCoordinator, IProgressMonitor iProgressMonitor) throws ProjectConfigurationException {
        IDecompositionModel iDecompositionModel = this.project.getService(IDecompositionModel.class);
        if (iDecompositionModel == null) throw new ProjectConfigurationException("Project has no decomposition model available");
        if (!iDecompositionModel.isAvailable()) {
            throw new ProjectConfigurationException("Project has no decomposition model available");
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        List<Map.Entry<ProjectFeature, IProjectFeatureHandler>> list = AbstractFeatureInitializer.getAvailableFeatureHandlers(this.project);
        iProgressMonitor.beginTask("Loading features...", 100 * list.size());
        try {
            for (Map.Entry<ProjectFeature, IProjectFeatureHandler> entry : list) {
                EventSupport eventSupport;
                ProjectFeature projectFeature = entry.getKey();
                IProjectFeatureHandler iProjectFeatureHandler = entry.getValue();
                if (readCoordinator != null && !readCoordinator.canRead(projectFeature, iProjectFeatureHandler)) continue;
                IProjectFeature iProjectFeature = readCoordinator != null ? readCoordinator.read(projectFeature, iProjectFeatureHandler) : iProjectFeatureHandler.read(this.project, AbstractFeatureInitializer.getDescriptor(projectFeature));
                if (iProjectFeature != null) {
                    this.registry.addFeature(iProjectFeature);
                }
                if ((eventSupport = this.getEventSupport()) != null) {
                    eventSupport.featureRead(projectFeature);
                }
                if (this.project.isReadOnly()) continue;
                AbstractFeatureInitializer.updateFeature(projectFeature, iProjectFeatureHandler);
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    static Collection<String> getDependencies(IProjectFeatureHandler iProjectFeatureHandler) {
        Collection<Object> collection = iProjectFeatureHandler.getDependencies() == null ? Collections.emptyList() : iProjectFeatureHandler.getDependencies();
        return collection;
    }

    public static void updateFeature(ProjectFeature projectFeature, IProjectFeatureDescriptor iProjectFeatureDescriptor) {
        if (!AbstractFeatureInitializer.areEqual(projectFeature.getName(), iProjectFeatureDescriptor.getName())) {
            projectFeature.setName(iProjectFeatureDescriptor.getName());
        }
        if (!AbstractFeatureInitializer.areEqual(projectFeature.getVersion(), iProjectFeatureDescriptor.getVersion())) {
            projectFeature.setVersion(iProjectFeatureDescriptor.getVersion());
        }
        if (!AbstractFeatureInitializer.areEqual(projectFeature.getNamespace(), iProjectFeatureDescriptor.getNamespace())) {
            projectFeature.setNamespace(iProjectFeatureDescriptor.getNamespace());
        }
        if (!AbstractFeatureInitializer.areEqual(projectFeature.getInternalVersion(), iProjectFeatureDescriptor.getInternalVersion())) {
            projectFeature.setInternalVersion(iProjectFeatureDescriptor.getInternalVersion());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean areEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    private static IProjectFeature findProjectFeature(IProjectFeatureRegistry iProjectFeatureRegistry, IProjectFeatureDescriptor iProjectFeatureDescriptor) {
        for (IProjectFeature iProjectFeature : iProjectFeatureRegistry.getFeatures()) {
            if (!iProjectFeatureDescriptor.getNamespace().equals(iProjectFeature.getDescriptor().getNamespace())) continue;
            return iProjectFeature;
        }
        return null;
    }

    public static IProjectFeatureDescriptor getDescriptor(ProjectFeature projectFeature) {
        return new FeatureDescriptor(projectFeature);
    }

    @CheckForNull
    protected abstract EventSupport createEventSupport();

    protected abstract void removeFeatureResources(IProjectFeatureHandler var1);

    protected static interface EventSupport {
        public void featureInstalled(IProjectFeatureHandler var1);

        public void featureRead(ProjectFeature var1);

        public void featureUninstalled(ProjectFeature var1);
    }

    private static class FeatureDescriptor
    implements IProjectFeatureDescriptor {
        private ProjectFeature feature;

        FeatureDescriptor(ProjectFeature projectFeature) {
            this.feature = projectFeature;
        }

        @Override
        public String getName() {
            return this.feature.getName();
        }

        @Override
        public String getNamespace() {
            return this.feature.getNamespace();
        }

        @Override
        public String getVersion() {
            return this.feature.getVersion();
        }

        @Override
        public int getInternalVersion() {
            return this.feature.getInternalVersion();
        }
    }

    protected static interface ReadCoordinator {
        public boolean canRead(ProjectFeature var1, IProjectFeatureHandler var2);

        @CheckForNull
        public IProjectFeature read(ProjectFeature var1, IProjectFeatureHandler var2) throws ProjectConfigurationException;
    }
}

