/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.events;

import com.nomagic.ci.event.AbstractEventSupport;
import com.nomagic.ci.event.ExceptionHandlingPolicy;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.a.b;
import com.nomagic.ci.persistence.events.IComplexOperationEventType;
import com.nomagic.ci.persistence.spi.ComplexOperationContext;
import com.nomagic.ci.persistence.spi.events.ComplexOperationEvent;
import com.nomagic.ci.persistence.spi.events.ComplexOperationEventDeliveryService;
import com.nomagic.ci.persistence.spi.events.ComplexOperationEventType;
import com.nomagic.ci.persistence.spi.events.ComplexOperationOutcome;
import com.nomagic.ci.persistence.spi.events.IComplexOperationEvent;
import com.nomagic.ci.persistence.spi.events.IComplexOperationEventListener;
import com.nomagic.ci.persistence.spi.events.IComplexOperationEventService;
import com.nomagic.ci.persistence.spi.events.IComplexOperationEventServiceConfigurator;
import com.nomagic.ci.persistence.util.ThreadUtil;
import com.nomagic.ci.services.SingletonServiceDiscovery;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class DefaultComplexOperationEventService
implements IComplexOperationEventService,
ComplexOperationEventDeliveryService {
    private static final Logger LOGGER = Logger.getLogger(DefaultComplexOperationEventService.class);
    private IPrimaryProject project;
    private ComplexEventSupport eventSupport = new ComplexEventSupport();
    private Map<IProject, Map<CombinedEventType, ComplexOperationEvent>> openEvents = new HashMap<IProject, Map<CombinedEventType, ComplexOperationEvent>>();
    private ComplexOperationEvent lastOpenEvent = null;
    private ComplexOperationContext currentContext = null;

    public DefaultComplexOperationEventService(IPrimaryProject iPrimaryProject) {
        this.project = iPrimaryProject;
    }

    @Override
    public void fireCustomPreEvent(IProject iProject, Object object, boolean bl, @CheckForNull Set<IProject> set, @CheckForNull IProgressMonitor iProgressMonitor) {
        this.createAndDeliverEvent(new ComplexOperationEventDeliveryService.ComplexOperationEventData(ComplexOperationEventType.CUSTOM_EVENT, iProject, ComplexOperationEventDeliveryService.PrimitiveEventType.PRE, bl, set, object, iProgressMonitor));
    }

    @Override
    public void fireCustomPostEvent(IProject iProject, Object object, boolean bl, @CheckForNull Set<IProject> set, @CheckForNull IProgressMonitor iProgressMonitor) {
        this.createAndDeliverEvent(new ComplexOperationEventDeliveryService.ComplexOperationEventData(ComplexOperationEventType.CUSTOM_EVENT, iProject, ComplexOperationEventDeliveryService.PrimitiveEventType.POST, bl, set, object, iProgressMonitor));
    }

    @Override
    public void fireCustomFailedEvent(IProject iProject, Object object, boolean bl, @CheckForNull Set<IProject> set, @CheckForNull IProgressMonitor iProgressMonitor) {
        this.createAndDeliverEvent(new ComplexOperationEventDeliveryService.ComplexOperationEventData(ComplexOperationEventType.CUSTOM_EVENT, iProject, ComplexOperationEventDeliveryService.PrimitiveEventType.FAILED, bl, set, object, iProgressMonitor));
    }

    @Override
    public void createAndDeliverEvent(ComplexOperationEventDeliveryService.ComplexOperationEventData complexOperationEventData) {
        ComplexOperationEvent complexOperationEvent = this.createComplexEvent(complexOperationEventData);
        if (complexOperationEvent != null) {
            block12: {
                try {
                    IProgressMonitor iProgressMonitor;
                    block11: {
                        iProgressMonitor = complexOperationEventData.getProgressMonitor();
                        if (iProgressMonitor != null) break block11;
                        this.eventSupport.fireEvent(complexOperationEvent);
                        break block12;
                    }
                    this.eventSupport.fireEvent(complexOperationEvent, iProgressMonitor);
                }
                catch (Throwable throwable) {
                    if (this.lastOpenEvent == null) {
                        this.currentContext = null;
                    }
                    throw throwable;
                }
            }
            if (this.lastOpenEvent == null) {
                this.currentContext = null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public ComplexOperationEvent createComplexEvent(ComplexOperationEventDeliveryService.ComplexOperationEventData complexOperationEventData) {
        IComplexOperationEventType iComplexOperationEventType = complexOperationEventData.getComplexType();
        Object object = complexOperationEventData.getCustomEventType();
        if (iComplexOperationEventType == ComplexOperationEventType.CUSTOM_EVENT && object == null) {
            throw new IllegalArgumentException("Custom event without custom event type");
        }
        CombinedEventType combinedEventType = new CombinedEventType(iComplexOperationEventType, object);
        ComplexOperationEvent complexOperationEvent = complexOperationEventData.getPrimitiveType() == ComplexOperationEventDeliveryService.PrimitiveEventType.PRE ? this.createPreEvent(complexOperationEventData, combinedEventType) : this.createPostEvent(complexOperationEventData, combinedEventType);
        if (complexOperationEvent == null) return complexOperationEvent;
        complexOperationEvent.setPrimitiveType(complexOperationEventData.getPrimitiveType());
        return complexOperationEvent;
    }

    @CheckForNull
    private ComplexOperationEvent createPreEvent(ComplexOperationEventDeliveryService.ComplexOperationEventData complexOperationEventData, CombinedEventType combinedEventType) {
        ComplexOperationEvent complexOperationEvent = new ComplexOperationEvent(complexOperationEventData.getProject(), this.lastOpenEvent, combinedEventType.getComplexType(), complexOperationEventData.isMultiProject(), combinedEventType.getCustomEventType());
        if (complexOperationEventData.isMultiProject()) {
            complexOperationEvent.setAllProjects(complexOperationEventData.getAllProjects());
        }
        if (!this.addOpenEvent(complexOperationEvent, combinedEventType)) {
            return null;
        }
        if (this.lastOpenEvent != null) {
            this.lastOpenEvent.addNestedOperationEvent(complexOperationEvent);
        }
        if (this.lastOpenEvent == null) {
            this.currentContext = new b();
        }
        this.lastOpenEvent = complexOperationEvent;
        return complexOperationEvent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    private ComplexOperationEvent createPostEvent(ComplexOperationEventDeliveryService.ComplexOperationEventData complexOperationEventData, CombinedEventType combinedEventType) {
        if (this.lastOpenEvent == null) {
            if (complexOperationEventData.getPrimitiveType() == ComplexOperationEventDeliveryService.PrimitiveEventType.POST) {
                this.handlePostEventOnEmptyStack(complexOperationEventData);
            }
            return null;
        }
        ComplexOperationEvent complexOperationEvent = this.getOpenEvent(combinedEventType, complexOperationEventData.getProject());
        if (complexOperationEvent == null) {
            if (complexOperationEventData.getPrimitiveType() == ComplexOperationEventDeliveryService.PrimitiveEventType.POST) {
                this.handlePostEventWithNoPreEvent(complexOperationEventData);
            }
            return null;
        }
        if (complexOperationEvent != this.lastOpenEvent) {
            this.handlePrematureEndEvent(complexOperationEvent);
        }
        if (complexOperationEvent.isMultiProject() != complexOperationEventData.isMultiProject()) {
            this.handleMultiProjectFlagMissmatch(complexOperationEvent);
        }
        if (complexOperationEvent.isMultiProject()) {
            complexOperationEvent.setAllProjects(complexOperationEventData.getAllProjects());
        }
        ComplexOperationOutcome complexOperationOutcome2 = complexOperationEventData.getPrimitiveType() == ComplexOperationEventDeliveryService.PrimitiveEventType.POST ? ComplexOperationOutcome.FINISHED : ComplexOperationOutcome.FAILED;
        complexOperationEvent.setOutcome(complexOperationOutcome2);
        ComplexOperationEvent complexOperationEvent2 = complexOperationEvent.getParent();
        this.removeOpenEvent(complexOperationEvent, combinedEventType);
        this.lastOpenEvent = complexOperationEvent2;
        return complexOperationEvent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addOpenEvent(ComplexOperationEvent complexOperationEvent, CombinedEventType combinedEventType) {
        Map<CombinedEventType, ComplexOperationEvent> map = this.openEvents.get(complexOperationEvent.getProject());
        if (map != null) {
            if (map.containsKey(combinedEventType)) {
                this.handleRecursiveEvent(complexOperationEvent);
                return false;
            }
        } else if (map == null) {
            map = new HashMap<CombinedEventType, ComplexOperationEvent>();
            this.openEvents.put(complexOperationEvent.getProject(), map);
        }
        map.put(combinedEventType, complexOperationEvent);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeOpenEvent(ComplexOperationEvent complexOperationEvent, CombinedEventType combinedEventType) {
        Map<CombinedEventType, ComplexOperationEvent> map = this.openEvents.get(complexOperationEvent.getProject());
        if (map == null) return;
        map.remove(combinedEventType);
        if (!map.isEmpty()) return;
        this.openEvents.remove(complexOperationEvent.getProject());
    }

    @CheckForNull
    private ComplexOperationEvent getOpenEvent(CombinedEventType combinedEventType, IProject iProject) {
        Map<CombinedEventType, ComplexOperationEvent> map = this.openEvents.get(iProject);
        ComplexOperationEvent complexOperationEvent = map != null ? map.get(combinedEventType) : null;
        return complexOperationEvent;
    }

    @Override
    @CheckForNull
    public IComplexOperationEvent getLastPreEvent() {
        return this.lastOpenEvent;
    }

    @Override
    public ComplexOperationContext getCurrentContext() {
        return this.currentContext;
    }

    @Override
    public void addComplexOperationEventListener(IComplexOperationEventListener iComplexOperationEventListener) {
        this.eventSupport.addListener(iComplexOperationEventListener);
    }

    @Override
    public void removeComplexOperationEventListener(IComplexOperationEventListener iComplexOperationEventListener) {
        this.eventSupport.removeListener(iComplexOperationEventListener);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    private void handleRecursiveEvent(ComplexOperationEvent complexOperationEvent) {
        String string = "Same type of operation for same project began yet before identical operation has ended, " + this.getComplexOperationEventInfo(complexOperationEvent);
        this.logAndFail(string);
    }

    private void handlePostEventOnEmptyStack(ComplexOperationEventDeliveryService.ComplexOperationEventData complexOperationEventData) {
        String string = "Got 'POST' event, but did not get any 'PRE' event yet, " + this.getEventInfo(complexOperationEventData);
        this.logAndFail(string);
    }

    private void handlePostEventWithNoPreEvent(ComplexOperationEventDeliveryService.ComplexOperationEventData complexOperationEventData) {
        String string = "Got 'POST' event, but did not get corresponding 'PRE' event yet, " + this.getEventInfo(complexOperationEventData);
        this.logAndFail(string);
    }

    private void handlePrematureEndEvent(ComplexOperationEvent complexOperationEvent) {
        String string = "'POST'/'FAILED' event for some parent operation has arrived earlier than for last started operation, " + this.getComplexOperationEventInfo(complexOperationEvent);
        this.logAndFail(string);
    }

    private void handleMultiProjectFlagMissmatch(ComplexOperationEvent complexOperationEvent) {
        StringBuilder stringBuilder = new StringBuilder("Got 'POST'/'FAILED' event for operation which ").append(this.wasOrWasNot(complexOperationEvent.isMultiProject())).append(" marked as multi-project when got 'PRE', but now it ");
        DefaultComplexOperationEventService defaultComplexOperationEventService = this;
        boolean bl = !complexOperationEvent.isMultiProject();
        String string = stringBuilder.append(defaultComplexOperationEventService.wasOrWasNot(bl)).append(" marked as multi-project, ").append(this.getComplexOperationEventInfo(complexOperationEvent)).toString();
        this.logAndFail(string);
    }

    private String wasOrWasNot(boolean bl) {
        String string = bl ? "was" : "was not";
        return string;
    }

    private String getEventInfo(ComplexOperationEventDeliveryService.ComplexOperationEventData complexOperationEventData) {
        String string = "project: " + complexOperationEventData.getProject() + ", operation type: " + complexOperationEventData.getComplexType();
        Object object = complexOperationEventData.getCustomEventType();
        if (object != null) {
            string = String.valueOf(string) + ", custom event type: " + object;
        }
        return string;
    }

    private String getComplexOperationEventInfo(ComplexOperationEvent complexOperationEvent) {
        String string = "project: " + complexOperationEvent.getProject() + ", operation type: " + complexOperationEvent.getEventType();
        Object object = complexOperationEvent.getCustomEventType();
        if (object != null) {
            string = String.valueOf(string) + ", custom event type: " + object;
        }
        return string;
    }

    private void logAndFail(String string) {
        boolean bl = this.failFast();
        LOGGER.warn((Object)string);
        this.dumpTree();
        this.dumpThreads();
        if (bl) {
            throw new IllegalStateException(string);
        }
    }

    private void dumpThreads() {
        LOGGER.warn((Object)ThreadUtil.createThreadDump());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean failFast() {
        IComplexOperationEventServiceConfigurator iComplexOperationEventServiceConfigurator = (IComplexOperationEventServiceConfigurator)SingletonServiceDiscovery.INSTANCE.getService(IComplexOperationEventServiceConfigurator.class);
        return iComplexOperationEventServiceConfigurator == null || iComplexOperationEventServiceConfigurator.failOnInconsistentEventOrder();
    }

    private void dumpTree() {
        if (this.lastOpenEvent != null) {
            IComplexOperationEvent iComplexOperationEvent = this.lastOpenEvent;
            while (iComplexOperationEvent.getParent() != null) {
                iComplexOperationEvent = iComplexOperationEvent.getParent();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Current complex operation tree:\n");
            this.printEventData(iComplexOperationEvent, stringBuilder, null, 0);
            this.printNestedEvents(iComplexOperationEvent, stringBuilder, 0);
            LOGGER.warn((Object)stringBuilder.toString());
        }
    }

    private void printNestedEvent(IComplexOperationEvent iComplexOperationEvent, StringBuilder stringBuilder, int n) {
        this.printEventData(iComplexOperationEvent, stringBuilder, iComplexOperationEvent.getOutcome(), n);
        this.printNestedEvents(iComplexOperationEvent, stringBuilder, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printNestedEvents(IComplexOperationEvent iComplexOperationEvent, StringBuilder stringBuilder, int n) {
        for (IComplexOperationEvent iComplexOperationEvent2 : iComplexOperationEvent.getExecutedNestedOperations()) {
            this.printNestedEvent(iComplexOperationEvent2, stringBuilder, n + 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printEventData(IComplexOperationEvent iComplexOperationEvent, StringBuilder stringBuilder, @CheckForNull ComplexOperationOutcome complexOperationOutcome, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append('\t');
            ++n2;
        }
        stringBuilder.append('{');
        stringBuilder.append(iComplexOperationEvent.getEventType());
        stringBuilder.append("} project: ");
        stringBuilder.append(iComplexOperationEvent.getProject());
        if (complexOperationOutcome != null) {
            stringBuilder.append(", outcome: ");
            stringBuilder.append((Object)complexOperationOutcome);
        }
        stringBuilder.append('\n');
    }

    private static class CombinedEventType {
        private IComplexOperationEventType complexType;
        private Object customEventType;

        public CombinedEventType(IComplexOperationEventType iComplexOperationEventType, @CheckForNull Object object) {
            this.complexType = iComplexOperationEventType;
            this.customEventType = object;
        }

        public IComplexOperationEventType getComplexType() {
            return this.complexType;
        }

        @CheckForNull
        public Object getCustomEventType() {
            return this.customEventType;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.complexType == null ? 0 : this.complexType.hashCode());
            n = 31 * n + (this.customEventType == null ? 0 : this.customEventType.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CombinedEventType combinedEventType = (CombinedEventType)object;
            if (this.complexType != combinedEventType.complexType) {
                return false;
            }
            return !(this.customEventType == null ? combinedEventType.customEventType != null : !this.customEventType.equals(combinedEventType.customEventType));
        }
    }

    public static class ComplexEventSupport
    extends AbstractEventSupport<IComplexOperationEventListener, ComplexOperationEvent> {
        public ComplexEventSupport() {
            super(ExceptionHandlingPolicy.RETHROW);
        }

        protected void notify(IComplexOperationEventListener iComplexOperationEventListener, ComplexOperationEvent complexOperationEvent) {
            block7: {
                block8: {
                    ComplexOperationEventDeliveryService.PrimitiveEventType primitiveEventType;
                    block6: {
                        primitiveEventType = complexOperationEvent.getPrimitiveType();
                        if (primitiveEventType != ComplexOperationEventDeliveryService.PrimitiveEventType.PRE) break block6;
                        iComplexOperationEventListener.preOperation(complexOperationEvent);
                        break block7;
                    }
                    if (primitiveEventType != ComplexOperationEventDeliveryService.PrimitiveEventType.POST) break block8;
                    iComplexOperationEventListener.postOperation(complexOperationEvent);
                    break block7;
                }
                try {
                    iComplexOperationEventListener.failedOperation(complexOperationEvent);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)("could not fire event on" + iComplexOperationEventListener), (Throwable)exception);
                }
            }
        }
    }

    public static interface ComplexOperationEventFactory {
        public void projectAdded(IProject var1);
    }
}

