/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.events;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.events.IComplexOperationEventType;
import com.nomagic.ci.persistence.spi.events.ComplexOperationEventDeliveryService;
import com.nomagic.ci.persistence.spi.events.ComplexOperationOutcome;
import com.nomagic.ci.persistence.spi.events.IComplexOperationEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.CheckForNull;
import org.eclipse.core.runtime.IProgressMonitor;

public class ComplexOperationEvent
implements IComplexOperationEvent {
    IProject project;
    ComplexOperationEvent parent;
    IComplexOperationEventType eventType;
    ComplexOperationOutcome outcome = ComplexOperationOutcome.UNKNOWN;
    List<IComplexOperationEvent> executedNestedOperations = null;
    boolean multiProject;
    Set<IProject> allProjects = null;
    IProgressMonitor progressMonitor = null;
    ComplexOperationEventDeliveryService.PrimitiveEventType primitiveType;
    Object customEventType;

    public ComplexOperationEvent(IProject iProject, @CheckForNull ComplexOperationEvent complexOperationEvent, IComplexOperationEventType iComplexOperationEventType, boolean bl, @CheckForNull Object object) {
        this.project = iProject;
        this.parent = complexOperationEvent;
        this.eventType = iComplexOperationEventType;
        this.multiProject = bl;
        this.customEventType = object;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @CheckForNull
    public ComplexOperationEventDeliveryService.PrimitiveEventType getPrimitiveType() {
        return this.primitiveType;
    }

    public void setPrimitiveType(ComplexOperationEventDeliveryService.PrimitiveEventType primitiveEventType) {
        this.primitiveType = primitiveEventType;
    }

    @Override
    public boolean isMultiProject() {
        return this.multiProject;
    }

    @Override
    @CheckForNull
    public Set<IProject> getAllProjects() {
        return this.allProjects != null ? Collections.unmodifiableSet(this.allProjects) : null;
    }

    void setAllProjects(@CheckForNull Set<IProject> set) {
        this.allProjects = set;
    }

    void addNestedOperationEvent(IComplexOperationEvent iComplexOperationEvent) {
        if (this.executedNestedOperations == null) {
            this.executedNestedOperations = new CopyOnWriteArrayList<IComplexOperationEvent>();
        }
        this.executedNestedOperations.add(iComplexOperationEvent);
    }

    @Override
    public IComplexOperationEventType getEventType() {
        return this.eventType;
    }

    @Override
    public ComplexOperationEvent getParent() {
        return this.parent;
    }

    @Override
    public List<IComplexOperationEvent> getExecutedNestedOperations() {
        return this.executedNestedOperations != null ? Collections.unmodifiableList(this.executedNestedOperations) : Collections.emptyList();
    }

    @CheckForNull
    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(@CheckForNull IProgressMonitor iProgressMonitor) {
        this.progressMonitor = iProgressMonitor;
    }

    void setOutcome(ComplexOperationOutcome complexOperationOutcome) {
        this.outcome = complexOperationOutcome;
    }

    @Override
    public ComplexOperationOutcome getOutcome() {
        return this.outcome;
    }

    @Override
    @CheckForNull
    public Object getCustomEventType() {
        return this.customEventType;
    }
}

