/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.decomposition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class ManualReachabilityCalculator {
    public static <T> boolean isProjectReachable(T t, T t2, AttachingProjecsProvider<T> attachingProjecsProvider) {
        return ManualReachabilityCalculator.isProjectReachableExt(t, t2, attachingProjecsProvider).isProjectReachable();
    }

    public static <T> boolean isProjectReachable(T t, T t2, T t3, AttachingProjecsProvider<T> attachingProjecsProvider) {
        return ManualReachabilityCalculator.isProjectReachableExt(t, t2, t3, attachingProjecsProvider).isProjectReachable();
    }

    public static <T> IsProjectReachableResult isProjectReachableExt(T t, T t2, AttachingProjecsProvider<T> attachingProjecsProvider) {
        return ManualReachabilityCalculator.isProjectReachableExt(t, t, t2, attachingProjecsProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> IsProjectReachableResult isProjectReachableExt(T t, T t2, T t3, AttachingProjecsProvider<T> attachingProjecsProvider) {
        if (t == null || t2 == null || t3 == null || attachingProjecsProvider == null) {
            throw new IllegalArgumentException("Neither of arguments can be null");
        }
        if (t2 == t3) {
            return new IsProjectReachableResult(true, 0);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Stack<ProjectAndDistance<T>> stack = new Stack<ProjectAndDistance<T>>();
        stack.push(new ProjectAndDistance<T>(t3, 0));
        while (!stack.isEmpty()) {
            ProjectAndDistance projectAndDistance = (ProjectAndDistance)stack.pop();
            Object object = projectAndDistance.project;
            if (hashSet.contains(object)) continue;
            hashSet.add(object);
            List<Attachment<Object>> list = attachingProjecsProvider.getAttachingProjects(object);
            if (list == null || list.isEmpty()) continue;
            for (Attachment<Object> attachment : list) {
                Object object2 = attachment.getProject();
                if (!ManualReachabilityCalculator.isAttachmentVisibleFromSource(t, t2, object2, attachment) || !ManualReachabilityCalculator.isAttachmentManualFromSourcePerspective(t, t2, object2, attachment)) continue;
                if (object2 == t2) {
                    return new IsProjectReachableResult(true, projectAndDistance.distance + 1);
                }
                stack.push(new ProjectAndDistance<Object>(object2, projectAndDistance.distance + 1));
            }
        }
        return new IsProjectReachableResult(false, 0);
    }

    public static <T> Set<T> getAllReachableProjects(T t, AttachedProjectsProvider<T> attachedProjectsProvider) {
        return ManualReachabilityCalculator.getAllReachableProjects(t, t, attachedProjectsProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Set<T> getAllReachableProjects(T t, T t2, AttachedProjectsProvider<T> attachedProjectsProvider) {
        if (t == null) throw new IllegalArgumentException("Neither of arguments can be null");
        if (t2 == null) throw new IllegalArgumentException("Neither of arguments can be null");
        if (attachedProjectsProvider == null) {
            throw new IllegalArgumentException("Neither of arguments can be null");
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(t2);
        HashSet hashSet2 = new HashSet();
        Stack<Object> stack = new Stack<Object>();
        stack.push(t2);
        while (!stack.isEmpty()) {
            Object e = stack.pop();
            if (hashSet2.contains(e)) continue;
            hashSet2.add(e);
            List list = attachedProjectsProvider.getAttachedProjects(e);
            if (list == null || list.isEmpty()) continue;
            for (Attachment attachment : list) {
                Object e2 = attachment.getProject();
                if (e2 == null) {
                    throw new IllegalArgumentException("Attached project can not be null");
                }
                if (!ManualReachabilityCalculator.isAttachmentVisibleFromSource(t, t2, e, attachment) || !ManualReachabilityCalculator.isAttachmentManualFromSourcePerspective(t, t2, e, attachment) || e2 == t2) continue;
                hashSet.add(e2);
                stack.push(e2);
            }
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> boolean isAttachmentVisibleFromSource(T t, T t2, T t3, AttachmentData attachmentData) {
        if (t == null || t2 == null || t3 == null || attachmentData == null) {
            throw new IllegalArgumentException("Neither of arguments can be null");
        }
        return t2 == t && t == t3 || attachmentData.isReshared();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> boolean isAttachmentManualFromSourcePerspective(T t, T t2, T t3, AttachmentData attachmentData) {
        if (t == null || t2 == null || t3 == null || attachmentData == null) {
            throw new IllegalArgumentException("Neither of arguments can be null");
        }
        if (attachmentData.isAutomatic()) {
            return false;
        }
        return t2 == t && t3 == t || !attachmentData.isReshared() || attachmentData.isReshared() && !attachmentData.isResharedAutomatically();
    }

    public static <T> boolean isAttachmentManual(T t, T t2, AttachmentData attachmentData) {
        return ManualReachabilityCalculator.isAttachmentManualFromSourcePerspective(t, t, t2, attachmentData);
    }

    public static interface AttachedProjectsProvider<T> {
        public List<Attachment<T>> getAttachedProjects(T var1);
    }

    public static interface AttachingProjecsProvider<T> {
        public List<Attachment<T>> getAttachingProjects(T var1);
    }

    public static interface Attachment<T>
    extends AttachmentData {
        public T getProject();
    }

    public static interface AttachmentData {
        public boolean isReshared();

        public boolean isResharedAutomatically();

        public boolean isAutomatic();
    }

    public static class IsProjectReachableResult {
        private boolean isProjectReachable;
        private int distance;

        public IsProjectReachableResult(boolean bl, int n) {
            this.isProjectReachable = bl;
            this.distance = n;
        }

        public boolean isProjectReachable() {
            return this.isProjectReachable;
        }

        public int getDistance() {
            return this.distance;
        }
    }

    private static class ProjectAndDistance<T> {
        private T project;
        private int distance;

        public ProjectAndDistance(T t, int n) {
            this.project = t;
            this.distance = n;
        }
    }
}

