/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.decomposition;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;

public class IllegalProjectRelationshipException
extends PersistenceException {
    private static final long serialVersionUID = 1L;
    private final IProject sourceProject;
    private final AbstractProjectAttachmentConfiguration attachmentConfiguration;
    private final IProject targetProject;
    private final IllegalRelationship illegalRelationship;

    public IllegalProjectRelationshipException(AbstractProjectAttachmentConfiguration abstractProjectAttachmentConfiguration, IProject iProject, IllegalRelationship illegalRelationship) {
        super(String.format(illegalRelationship.getFormatString(), abstractProjectAttachmentConfiguration.getAttachedProjectURI(), iProject.getName()));
        this.attachmentConfiguration = abstractProjectAttachmentConfiguration;
        this.targetProject = iProject;
        this.illegalRelationship = illegalRelationship;
        this.sourceProject = null;
    }

    public IllegalProjectRelationshipException(IProject iProject, IProject iProject2, IllegalRelationship illegalRelationship) {
        super(String.format(illegalRelationship.getFormatString(), iProject.getName(), iProject2.getName()));
        this.sourceProject = iProject;
        this.targetProject = iProject2;
        this.illegalRelationship = illegalRelationship;
        this.attachmentConfiguration = null;
    }

    public IProject getSourceProject() {
        return this.sourceProject;
    }

    public AbstractProjectAttachmentConfiguration getAttachmentConfiguration() {
        return this.attachmentConfiguration;
    }

    public IProject getTargetProject() {
        return this.targetProject;
    }

    public IllegalRelationship getIllegalRelationship() {
        return this.illegalRelationship;
    }

    public static enum IllegalRelationship {
        SELF{

            @Override
            public String getFormatString() {
                return "The project %1$s will become attached to self.";
            }
        }
        ,
        ATTACHED{

            @Override
            public String getFormatString() {
                return "The project %1$s is attached to project %2$s";
            }
        }
        ,
        NOT_ATTACHED{

            @Override
            public String getFormatString() {
                return "The project %1$s is not directly attached to project %2$s";
            }
        }
        ,
        NOT_MOUNTED{

            @Override
            public String getFormatString() {
                return "The project %1$s is not directly mounted on project %2$s";
            }
        };


        public abstract String getFormatString();
    }
}

