/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.spi.decomposition.AttachmentSet;
import com.nomagic.ci.persistence.spi.decomposition.CombinedProjectStructure;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.spi.decomposition.IUsageRemoveRegistry;
import com.nomagic.ci.persistence.util.MultiValueHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DecompositionUtil {
    public static Set<IAttachedProject> collectAllChildren(IPrimaryProject iPrimaryProject) {
        HashSet<IAttachedProject> hashSet = new HashSet<IAttachedProject>();
        IProjectDecompositionManager iProjectDecompositionManager = iPrimaryProject.getServiceOrFail(IProjectDecompositionManager.class);
        for (IProject iProject : iProjectDecompositionManager.getAvailableAttachedProjects()) {
            if (!(iProject instanceof IAttachedProject) || hashSet.contains(iProject)) continue;
            IAttachedProject iAttachedProject = (IAttachedProject)iProject;
            DecompositionUtil.collectChildren(iAttachedProject, hashSet);
        }
        return hashSet;
    }

    public static Set<IAttachedProject> calcProjectsToRemove(Map<IProject, Set<IProject>> map) {
        HashSet<IAttachedProject> hashSet = new HashSet<IAttachedProject>();
        for (IProject object2 : map.keySet()) {
            if (!(object2 instanceof IAttachedProject)) continue;
            DecompositionUtil.collectChildren((IAttachedProject)object2, hashSet);
        }
        UsageRemoveRegistry usageRemoveRegistry = new UsageRemoveRegistry(map, true);
        CombinedProjectStructure combinedProjectStructure = new CombinedProjectStructure(usageRemoveRegistry);
        HashSet<IAttachedProject> hashSet2 = new HashSet<IAttachedProject>();
        for (IAttachedProject iAttachedProject : hashSet) {
            Set<IProject> set;
            if (hashSet2.contains(iAttachedProject) || (set = combinedProjectStructure.getAttachingProjects(iAttachedProject)).isEmpty() || hashSet.containsAll(set)) continue;
            combinedProjectStructure.collectChildren(iAttachedProject, hashSet2);
        }
        hashSet.removeAll(hashSet2);
        return hashSet;
    }

    public static Map<IProject, Set<IProject>> toReverseUsageMap(AttachmentSet attachmentSet) {
        Map<IProject, Set<IProject>> map = DecompositionUtil.toUsageMap(attachmentSet);
        return DecompositionUtil.invertMap(map);
    }

    public static void collectChildren(IAttachedProject iAttachedProject, Collection<IAttachedProject> collection) {
        collection.add(iAttachedProject);
        IProjectDecompositionManager iProjectDecompositionManager = iAttachedProject.getServiceOrFail(IProjectDecompositionManager.class);
        for (IProject iProject : iProjectDecompositionManager.getAvailableAttachedProjects()) {
            if (!(iProject instanceof IAttachedProject) || collection.contains(iProject)) continue;
            IAttachedProject iAttachedProject2 = (IAttachedProject)iProject;
            DecompositionUtil.collectChildren(iAttachedProject2, collection);
        }
    }

    public static Map<IProject, Set<IProject>> toUsageMap(AttachmentSet attachmentSet) {
        HashMap<IProject, Set<IProject>> hashMap = new HashMap<IProject, Set<IProject>>();
        for (IProject iProject : attachmentSet.getAttachingProjects()) {
            Set<IProject> set = attachmentSet.getAttachedProjects(iProject);
            hashMap.put(iProject, new HashSet<IProject>(set));
        }
        return hashMap;
    }

    public static <K> Map<K, Set<K>> invertMap(Map<K, Set<K>> map) {
        MultiValueHashMap<K, K> multiValueHashMap = new MultiValueHashMap<K, K>();
        for (Map.Entry<K, Set<K>> entry : map.entrySet()) {
            K k = entry.getKey();
            for (K k2 : entry.getValue()) {
                multiValueHashMap.append(k2, k);
            }
        }
        return multiValueHashMap;
    }

    static class UsageRemoveRegistry
    implements IUsageRemoveRegistry {
        private final Map<IProject, Set<IProject>> usageMap;
        private final Map<IProject, Set<IProject>> reverseUsageMap;

        UsageRemoveRegistry(Map<IProject, Set<IProject>> map, boolean bl) {
            this.usageMap = bl ? DecompositionUtil.invertMap(map) : map;
            this.reverseUsageMap = bl ? map : DecompositionUtil.invertMap(map);
        }

        @Override
        public Set<IProject> getRemoveFrom() {
            return this.usageMap.keySet();
        }

        @Override
        public Set<IProject> getRemoveFrom(IProject iProject) {
            return this.reverseUsageMap.get(iProject);
        }

        @Override
        public Set<IProject> getRemoveTo() {
            return this.reverseUsageMap.keySet();
        }

        @Override
        public Set<IProject> getRemoveTo(IProject iProject) {
            return this.usageMap.get(iProject);
        }
    }
}

