/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.decomposition;

import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.spi.decomposition.IUsageRemoveRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CombinedProjectStructure {
    private final IUsageRemoveRegistry registry;

    public CombinedProjectStructure(IUsageRemoveRegistry iUsageRemoveRegistry) {
        this.registry = iUsageRemoveRegistry;
    }

    public Set<IProject> getAttachingProjects(IProject iProject) {
        IProjectDecompositionManager iProjectDecompositionManager = iProject.getServiceOrFail(IProjectDecompositionManager.class);
        Set<IProject> set = iProjectDecompositionManager.getAttachingProjectSet();
        Set<IProject> set2 = this.registry.getRemoveFrom(iProject);
        if (set2 != null) {
            set.removeAll(set2);
        }
        return set;
    }

    public Set<IProject> getAttachedProjects(IProject iProject) {
        IProjectDecompositionManager iProjectDecompositionManager = iProject.getServiceOrFail(IProjectDecompositionManager.class);
        HashSet<IProject> hashSet = new HashSet<IProject>(iProjectDecompositionManager.getAvailableAttachedProjects());
        Set<IProject> set = this.registry.getRemoveTo(iProject);
        if (set != null) {
            hashSet.removeAll(set);
        }
        return hashSet;
    }

    public void collectChildren(IAttachedProject iAttachedProject, Collection<IAttachedProject> collection) {
        collection.add(iAttachedProject);
        Set<IProject> set = this.getAttachedProjects(iAttachedProject);
        for (IProject iProject : set) {
            if (!(iProject instanceof IAttachedProject) || collection.contains(iProject)) continue;
            IAttachedProject iAttachedProject2 = (IAttachedProject)iProject;
            this.collectChildren(iAttachedProject2, collection);
        }
    }
}

