/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.decomposition;

import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class AttachmentSet {
    public static final AttachmentSet EMPTY_ATTACHMENT_SET = new AttachmentSet(){

        @Override
        public void addAttachment(IProject iProject, IProject iProject2) {
            throw new UnsupportedOperationException("EMPTY_ATTACHMENT_SET");
        }
    };
    private Map<IProject, Set<IProject>> usageMap = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAttachment(IProject iProject, IProject iProject2) {
        Set<IProject> set;
        if (iProject == null || iProject2 == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (iProject == iProject2) {
            throw new IllegalArgumentException("attachingProject is same as attached project");
        }
        if (this.usageMap == null) {
            this.usageMap = new LinkedHashMap<IProject, Set<IProject>>();
        }
        if ((set = this.usageMap.get(iProject)) == null) {
            set = new LinkedHashSet<IProject>();
            this.usageMap.put(iProject, set);
        }
        set.add(iProject2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsAttachment(IProject iProject, IProject iProject2) {
        if (this.usageMap == null) {
            return false;
        }
        Set<IProject> set = this.usageMap.get(iProject);
        return set != null && set.contains(iProject2);
    }

    public Set<IProject> getAttachingProjects() {
        Set<IProject> set = this.usageMap != null ? Collections.unmodifiableSet(this.usageMap.keySet()) : Collections.emptySet();
        return set;
    }

    public Set<IProject> getAttachedProjects(IProject iProject) {
        Set<IProject> set = this.usageMap != null ? this.usageMap.get(iProject) : null;
        Set<IProject> set2 = set;
        Set<IProject> set3 = set2 != null ? Collections.unmodifiableSet(set2) : Collections.emptySet();
        return set3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttachmentSet createCopy() {
        AttachmentSet attachmentSet = new AttachmentSet();
        for (IProject iProject : this.getAttachingProjects()) {
            for (IProject iProject2 : this.getAttachedProjects(iProject)) {
                attachmentSet.addAttachment(iProject, iProject2);
            }
        }
        return attachmentSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEmpty() {
        return this.usageMap == null || this.usageMap.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        if (!this.isEmpty()) {
            Iterator<Map.Entry<IProject, Set<IProject>>> iterator = this.usageMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<IProject, Set<IProject>> entry = iterator.next();
                IProject iProject = entry.getKey();
                stringBuilder.append(this.projectToString(iProject));
                stringBuilder.append(" -> {");
                Set<IProject> set = entry.getValue();
                this.printProjectsList(stringBuilder, set);
                stringBuilder.append('}');
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void printProjectsList(StringBuilder stringBuilder, Set<IProject> set) {
        if (set != null && !set.isEmpty()) {
            Iterator<IProject> iterator = set.iterator();
            while (iterator.hasNext()) {
                IProject iProject = iterator.next();
                stringBuilder.append(this.projectToString(iProject));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
    }

    private String projectToString(IProject iProject) {
        String string = iProject.getName();
        if (iProject instanceof IPrimaryProject) {
            string = String.valueOf(string) + " (primary)";
        }
        return string;
    }
}

