/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.decomposition;

import com.nomagic.ci.metamodel.project.AbstractProjectUsage;
import com.nomagic.ci.persistence.IAttachedProject;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IProjectEventFire;
import com.nomagic.ci.persistence.PersistenceException;
import com.nomagic.ci.persistence.ProjectEventType;
import com.nomagic.ci.persistence.decomposition.IAttachedProjectRemoverCallback;
import com.nomagic.ci.persistence.spi.decomposition.AttachmentSet;
import com.nomagic.ci.persistence.spi.decomposition.BulkDetachEventImpl;
import com.nomagic.ci.persistence.spi.decomposition.DecompositionUtil;
import com.nomagic.ci.persistence.spi.decomposition.IAttachedProjectRemover;
import com.nomagic.ci.persistence.spi.decomposition.IProjectDecompositionManager;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageRemover;
import com.nomagic.ci.persistence.spi.decomposition.MultiProjectEventImpl;
import com.nomagic.ci.persistence.util.MultiValueHashMap;
import com.nomagic.ci.persistence.util.ProjectUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AttachedProjectRemoveService
implements IAttachedProjectRemover {
    public final IPrimaryProject primary;

    public AttachedProjectRemoveService(IPrimaryProject iPrimaryProject) {
        this.primary = iPrimaryProject;
    }

    @Override
    public IProject getProject() {
        return this.primary;
    }

    private IProjectEventFire getFireEvents() {
        return (IProjectEventFire)((Object)this.getProject());
    }

    protected void checkInputProject(IProject iProject) {
        if (iProject == null) {
            throw new IllegalArgumentException("Given project is null");
        }
        if (ProjectUtil.getPrimaryProject(iProject) != this.primary) {
            throw new IllegalArgumentException("Given project belongs to other primary project");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeProjects(final Set<IAttachedProject> set, IAttachedProjectRemoverCallback iAttachedProjectRemoverCallback, IProgressMonitor iProgressMonitor) throws PersistenceException {
        if (set == null) {
            throw new IllegalArgumentException();
        }
        for (Object object : set) {
            this.checkInputProject((IProject)object);
        }
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        try {
            Object object;
            iProgressMonitor.beginTask("Removing projects", 2000);
            object = AttachedProjectRemoveService.calcUsagesToDiscard(set);
            EventDeliveryDelegate eventDeliveryDelegate = new EventDeliveryDelegate(){

                @Override
                public void firePreEvents(IProgressMonitor iProgressMonitor) {
                    AttachedProjectRemoveService.this.firePreRemove(set, iProgressMonitor);
                }

                @Override
                public void firePostEvents(IProgressMonitor iProgressMonitor) {
                    AttachedProjectRemoveService.this.firePostRemove(set, true, iProgressMonitor);
                }

                @Override
                public void fireFailedEvents(IProgressMonitor iProgressMonitor) {
                    AttachedProjectRemoveService.this.firePostRemove(set, false, iProgressMonitor);
                }
            };
            iProgressMonitor.worked(50);
            this.removeAttachments((Map<IProject, Set<IProject>>)object, iAttachedProjectRemoverCallback, eventDeliveryDelegate, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1950));
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void bulkDetach(AttachmentSet var1_1, IAttachedProjectRemoverCallback var2_2, IProgressMonitor var3_3) throws PersistenceException {
        if (var1_1 == null) throw new IllegalArgumentException("no attachments provided");
        if (var1_1.isEmpty()) {
            throw new IllegalArgumentException("no attachments provided");
        }
        this.checkIsAttached(var1_1);
        if (var3_3 == null) {
            var3_3 = new NullProgressMonitor();
        }
        try {
            block11: {
                block10: {
                    var3_3.beginTask("Detaching projects", 2000);
                    var4_4 = DecompositionUtil.toReverseUsageMap(var1_1);
                    var5_5 = DecompositionUtil.calcProjectsToRemove(var4_4);
                    if (var5_5.isEmpty()) break block10;
                    var7_6 = new AttachmentSet();
                    var9_7 = var1_1.getAttachingProjects().iterator();
                    if (true) ** GOTO lbl23
                }
                var6_11 = var1_1;
                break block11;
                do {
                    if (var5_5.contains(var8_8 = var9_7.next())) continue;
                    for (IProject var10_9 : var1_1.getAttachedProjects(var8_8)) {
                        var7_6.addAttachment(var8_8, var10_9);
                    }
lbl23:
                    // 3 sources

                } while (var9_7.hasNext());
                var6_11 = var7_6;
                var4_4 = DecompositionUtil.toReverseUsageMap((AttachmentSet)var6_11);
            }
            var7_6 = new EventDeliveryDelegate((AttachmentSet)var6_11){
                private final /* synthetic */ AttachmentSet val$finalAttachments;
                {
                    this.val$finalAttachments = attachmentSet;
                }

                @Override
                public void firePreEvents(IProgressMonitor iProgressMonitor) {
                    AttachedProjectRemoveService.this.getFireEvents().fireEvent(BulkDetachEventImpl.createPre(AttachedProjectRemoveService.this.primary, this.val$finalAttachments), iProgressMonitor);
                }

                @Override
                public void firePostEvents(IProgressMonitor iProgressMonitor) {
                    AttachedProjectRemoveService.this.getFireEvents().fireEvent(BulkDetachEventImpl.createPost(AttachedProjectRemoveService.this.primary, this.val$finalAttachments), iProgressMonitor);
                }

                @Override
                public void fireFailedEvents(IProgressMonitor iProgressMonitor) {
                    AttachedProjectRemoveService.this.getFireEvents().fireEvent(BulkDetachEventImpl.createFailed(AttachedProjectRemoveService.this.primary, this.val$finalAttachments), iProgressMonitor);
                }
            };
            var3_3.worked(50);
            this.removeAttachments(var4_4, var2_2, (EventDeliveryDelegate)var7_6, (IProgressMonitor)new SubProgressMonitor(var3_3, 1950));
            return;
        }
        finally {
            var3_3.done();
        }
    }

    protected void interceptRemoveUsages(Map<IProject, Set<IProject>> map) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeAttachments(Map<IProject, Set<IProject>> map, IAttachedProjectRemoverCallback iAttachedProjectRemoverCallback, EventDeliveryDelegate eventDeliveryDelegate, IProgressMonitor iProgressMonitor) throws PersistenceException {
        try {
            iProgressMonitor.beginTask("", 2000);
            Map<IProject, Set<IProject>> map2 = DecompositionUtil.invertMap(map);
            Set<IAttachedProject> set = DecompositionUtil.calcProjectsToRemove(map);
            iProgressMonitor.worked(100);
            if (iAttachedProjectRemoverCallback != null) {
                if (!iAttachedProjectRemoverCallback.confirmRemove(set, map2.keySet())) return;
            }
            this.doRemoveAttachments(map2, set, eventDeliveryDelegate, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1900));
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void doRemoveAttachments(Map<IProject, Set<IProject>> map, Set<IAttachedProject> set, EventDeliveryDelegate eventDeliveryDelegate, IProgressMonitor iProgressMonitor) throws PersistenceException {
        try {
            iProgressMonitor.beginTask("", 1900);
            this.checkDetached(map);
            boolean bl = false;
            try {
                boolean bl2 = false;
                try {
                    eventDeliveryDelegate.firePreEvents((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                    this.interceptRemoveUsages(map);
                    this.doDetach(map, set, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1600));
                    bl2 = true;
                }
                finally {
                    this.updateProjectStructureIfNeeded(iProgressMonitor, bl2);
                }
                eventDeliveryDelegate.firePostEvents((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                bl = true;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    eventDeliveryDelegate.fireFailedEvents((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
                }
                throw throwable;
            }
            if (!bl) {
                eventDeliveryDelegate.fireFailedEvents((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 100));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void updateProjectStructureIfNeeded(IProgressMonitor iProgressMonitor, boolean bl) throws PersistenceException {
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDetach(Map<IProject, Set<IProject>> var1_1, Set<IAttachedProject> var2_2, IProgressMonitor var3_3) {
        block16: {
            var3_3.beginTask("", 10000);
            if (var1_1.isEmpty()) break block16;
            var4_4 = 10000 / var1_1.size();
            var5_5 = this.getProjectUsageRemover(var2_2);
            var7_6 = var1_1.entrySet().iterator();
            if (true) ** GOTO lbl41
        }
        var3_3.worked(10000);
        return;
        finally {
            var3_3.done();
        }
        do {
            block17: {
                var6_7 = var7_6.next();
                var8_8 = var6_7.getKey();
                var9_9 = var6_7.getValue();
                if (var9_9 == null || var9_9.isEmpty()) break block17;
                var10_10 = var4_4 / var9_9.size();
                var11_11 = var8_8.getServiceOrFail(IProjectUsageManager.class);
                var13_13 = var9_9.iterator();
                if (true) ** GOTO lbl40
            }
            var3_3.worked(var4_4);
            continue;
            do {
                if ((var14_14 = var11_11.getProjectUsage(var12_12 = var13_13.next())) != null) {
                    var15_15 = false;
                    try {
                        this.preDetach(var8_8, var12_12, (IProgressMonitor)new SubProgressMonitor(var3_3, (int)((double)var10_10 * 0.1)));
                        var5_5.removeUsage((AbstractProjectUsage)var14_14);
                        this.postDetach(var8_8, var12_12, true, (IProgressMonitor)new SubProgressMonitor(var3_3, (int)((double)var10_10 * 0.1)));
                        var15_15 = true;
                    }
                    finally {
                        if (!var15_15) {
                            this.postDetach(var8_8, var12_12, false, (IProgressMonitor)new SubProgressMonitor(var3_3, (int)((double)var10_10 * 0.1)));
                        }
                    }
                } else {
                    var3_3.worked(var10_10);
                }
lbl40:
                // 3 sources

            } while (var13_13.hasNext());
lbl41:
            // 3 sources

        } while (var7_6.hasNext());
        var5_5.finish();
    }

    protected abstract IProjectUsageRemover getProjectUsageRemover(Set<IAttachedProject> var1);

    private void firePreRemove(Set<IAttachedProject> set, IProgressMonitor iProgressMonitor) {
        Set<IProject> set2 = this.createRemovedIProjectsSet(set);
        this.getFireEvents().fireEvent(new MultiProjectEventImpl(ProjectEventType.PRE_REMOVE_PROJECTS, this.primary, set2), iProgressMonitor);
    }

    private void firePostRemove(Set<IAttachedProject> set, boolean bl, IProgressMonitor iProgressMonitor) {
        Set<IProject> set2 = this.createRemovedIProjectsSet(set);
        ProjectEventType projectEventType = bl ? ProjectEventType.POST_REMOVE_PROJECTS : ProjectEventType.FAILED_REMOVE_PROJECTS;
        ProjectEventType projectEventType2 = projectEventType;
        this.getFireEvents().fireEvent(new MultiProjectEventImpl(projectEventType2, this.primary, set2), iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<IProject> createRemovedIProjectsSet(Set<IAttachedProject> set) {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        for (IAttachedProject iAttachedProject : set) {
            hashSet.add(iAttachedProject);
        }
        return hashSet;
    }

    protected abstract void checkDetached(Map<IProject, Set<IProject>> var1) throws PersistenceException;

    protected abstract void preDetach(IProject var1, IProject var2, IProgressMonitor var3);

    protected abstract void postDetach(IProject var1, IProject var2, boolean var3, IProgressMonitor var4);

    protected abstract void checkIsAttached(AttachmentSet var1) throws PersistenceException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <K> int coutValues(Map<K, Set<K>> map) {
        int n = 0;
        for (Set<K> set : map.values()) {
            Iterator<K> iterator = set.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
        }
        return n;
    }

    public static Map<IProject, Set<IProject>> calcUsagesToDiscard(Set<IAttachedProject> set) {
        return AttachedProjectRemoveService.calcUsagesToDiscard(set, AttachmentSet.EMPTY_ATTACHMENT_SET, Collections.emptySet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<IProject, Set<IProject>> calcUsagesToDiscard(Set<IAttachedProject> set, AttachmentSet attachmentSet, Set<IAttachedProject> set2) {
        Object object;
        Object object2;
        Object object3;
        MultiValueHashMap<IProject, IProject> multiValueHashMap = new MultiValueHashMap<IProject, IProject>();
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<IAttachedProject> linkedList = new LinkedList<IAttachedProject>(set);
        while (!linkedList.isEmpty()) {
            object3 = linkedList.remove();
            if (hashSet.contains(object3)) continue;
            hashSet.add(object3);
            object2 = object3.getServiceOrFail(IProjectDecompositionManager.class);
            Object object4 = object2.getAttachingProjectSet();
            object = object4.iterator();
            while (object.hasNext()) {
                IProject iProject = (IProject)object.next();
                if (set2.contains(iProject) || attachmentSet.containsAttachment(iProject, (IProject)object3)) continue;
                if (iProject instanceof IAttachedProject) {
                    IProject iProject2 = (IAttachedProject)iProject;
                    if (iProject2.isReadOnly()) {
                        linkedList.add((IAttachedProject)iProject2);
                        continue;
                    }
                    multiValueHashMap.append((IProject)object3, iProject);
                    continue;
                }
                multiValueHashMap.append((IProject)object3, iProject);
            }
        }
        object3 = DecompositionUtil.calcProjectsToRemove(multiValueHashMap);
        object2 = new MultiValueHashMap();
        for (Object object4 : multiValueHashMap.entrySet()) {
            object = (IProject)object4.getKey();
            for (IProject iProject2 : (Set)object4.getValue()) {
                if (object3.contains(iProject2)) continue;
                ((MultiValueHashMap)object2).append(object, iProject2);
            }
        }
        return object2;
    }

    protected static interface EventDeliveryDelegate {
        public void firePreEvents(IProgressMonitor var1);

        public void firePostEvents(IProgressMonitor var1);

        public void fireFailedEvents(IProgressMonitor var1);
    }
}

