/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.decomposition;

import com.nomagic.annotation.OpenApi;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.spi.decomposition.AttachmentType;
import com.nomagic.ci.persistence.versioning.IVersionDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.eclipse.emf.common.util.URI;

@OpenApi
public class AbstractProjectAttachmentConfiguration
implements Cloneable {
    protected boolean readOnly;
    protected URI attachedProjectURI;
    protected IVersionDescriptor stickyVersion;
    protected Map<String, String> customOptions;
    protected IProject attachedProject;
    protected AttachmentType attachmentType = AttachmentType.MANUAL;

    protected AbstractProjectAttachmentConfiguration(URI uRI, boolean bl, @CheckForNull IVersionDescriptor iVersionDescriptor, AttachmentType attachmentType) {
        if (uRI == null) {
            throw new IllegalArgumentException("project URI can not be null");
        }
        this.attachedProjectURI = uRI;
        this.readOnly = bl;
        this.stickyVersion = iVersionDescriptor;
        this.customOptions = new HashMap<String, String>();
        this.attachmentType = attachmentType;
    }

    public URI getAttachedProjectURI() {
        return this.attachedProjectURI;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public IVersionDescriptor getStickyVersion() {
        return this.stickyVersion;
    }

    public void setStickyVersion(IVersionDescriptor iVersionDescriptor) {
        this.stickyVersion = iVersionDescriptor;
    }

    public Set<String> getCustomOptionNames() {
        return this.customOptions.keySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCustomOptionValue(String string) {
        if (string != null && !string.isEmpty()) {
            return this.customOptions.get(string);
        }
        throw new IllegalArgumentException("key is empty");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCustomOptionValue(String string, String string2) {
        if (string != null && !string.isEmpty()) {
            this.customOptions.put(string, string2);
            return;
        }
        throw new IllegalArgumentException("key is empty");
    }

    @CheckForNull
    public IProject getAttachedProject() {
        return this.attachedProject;
    }

    public AttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public void setAttachmentType(AttachmentType attachmentType) {
        if (attachmentType == null) {
            throw new IllegalArgumentException("Null not permitted");
        }
        this.attachmentType = attachmentType;
    }
}

