/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.spi.binary;

import com.nomagic.ci.metamodel.binary.AbstractStreamIdentityBinaryObject;
import com.nomagic.ci.metamodel.binary.IBinaryObjectRuntime;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.spi.binary.IBinaryObjectRuntimeService;
import com.nomagic.ci.persistence.util.ProjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class BinaryObjectRuntime
implements IBinaryObjectRuntime {
    private static final Logger LOGGER = Logger.getLogger((String)"BinaryObjectRuntime");
    private final AbstractStreamIdentityBinaryObject binaryObject;

    public BinaryObjectRuntime(AbstractStreamIdentityBinaryObject abstractStreamIdentityBinaryObject) {
        this.binaryObject = abstractStreamIdentityBinaryObject;
    }

    public OutputStream getOutputStream() throws IOException {
        IProject iProject = ProjectUtil.getProject((EObject)this.binaryObject);
        if (iProject == null) {
            throw new IOException("Binary object is not contained by a resource that is managed by a project.");
        }
        IPrimaryProject iPrimaryProject = ProjectUtil.getPrimaryProject(iProject);
        if (iPrimaryProject == null) {
            throw new IOException("Binary object is contained by a project that is not attached to a primary project");
        }
        IBinaryObjectRuntimeService iBinaryObjectRuntimeService = iPrimaryProject.getServiceOrFail(IBinaryObjectRuntimeService.class);
        return iBinaryObjectRuntimeService.getOutputStream(iProject, this.binaryObject);
    }

    public InputStream getInputStream() throws IOException {
        IPrimaryProject iPrimaryProject;
        IProject iProject = ProjectUtil.getProject((EObject)this.binaryObject);
        if (iProject != null && (iPrimaryProject = ProjectUtil.getPrimaryProject(iProject)) != null) {
            IBinaryObjectRuntimeService iBinaryObjectRuntimeService = iPrimaryProject.getServiceOrFail(IBinaryObjectRuntimeService.class);
            return iBinaryObjectRuntimeService.getInputStream(iProject, this.binaryObject);
        }
        LOGGER.warn((Object)"Binary without project.", (Throwable)new Exception());
        return null;
    }

    public boolean isInputStreamAvailable() {
        IPrimaryProject iPrimaryProject;
        IProject iProject = ProjectUtil.getProject((EObject)this.binaryObject);
        if (iProject != null && (iPrimaryProject = ProjectUtil.getPrimaryProject(iProject)) != null) {
            IBinaryObjectRuntimeService iBinaryObjectRuntimeService = iPrimaryProject.getServiceOrFail(IBinaryObjectRuntimeService.class);
            return iBinaryObjectRuntimeService.isInputStreamAvailable(iProject, this.binaryObject);
        }
        return false;
    }
}

