/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.resources;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IResourceDescriptor;
import com.nomagic.ci.persistence.resources.FeatureResourceConfigurator;

public interface FeatureResourceFilter {
    public static final FeatureResourceFilter PERSONAL_FILTER = new FeatureResourceFilter(){

        @Override
        public boolean accept(IProject iProject, IResourceDescriptor iResourceDescriptor) {
            return iResourceDescriptor.isPersonal();
        }

        @Override
        public void configure(IProject iProject, FeatureResourceConfigurator featureResourceConfigurator) {
            featureResourceConfigurator.setPersonal(true);
        }
    };
    public static final FeatureResourceFilter COMMON_FILTER = new FeatureResourceFilter(){

        @Override
        public boolean accept(IProject iProject, IResourceDescriptor iResourceDescriptor) {
            return !iResourceDescriptor.isPersonal();
        }

        @Override
        public void configure(IProject iProject, FeatureResourceConfigurator featureResourceConfigurator) {
            featureResourceConfigurator.setPersonal(false);
        }
    };

    public boolean accept(IProject var1, IResourceDescriptor var2);

    public void configure(IProject var1, FeatureResourceConfigurator var2);
}

