/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.migration;

import com.nomagic.ci.persistence.migration.IDataTransferer;
import com.nomagic.ci.persistence.migration.ITransferedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DataMover
implements IDataTransferer {
    private final Map<Resource, Set<EObject>> transfered = new HashMap<Resource, Set<EObject>>();
    private final MovedData data = new MovedData();

    @Override
    public String getJobTitle() {
        return "Moving";
    }

    @Override
    public void transfer(Collection<EObject> collection, Resource resource) {
        collection = new ArrayList<EObject>(collection);
        this.remeberMoved(collection, resource);
        for (EObject eObject : collection) {
            Resource resource2 = eObject.eResource();
            if (resource2 != null && resource2.getContents().contains((Object)eObject)) {
                resource2.getContents().remove((Object)eObject);
            }
            if (eObject.eResource() == resource) continue;
            resource.getContents().add((Object)eObject);
        }
    }

    @Override
    public void transferSelected(Collection<EObject> collection, Resource resource) {
        collection = new ArrayList<EObject>(collection);
        this.remeberMoved(collection, resource);
        for (EObject eObject : collection) {
            Resource resource2 = eObject.eResource();
            if (resource2 != null && resource2.getContents().contains((Object)eObject)) {
                resource2.getContents().remove((Object)eObject);
            }
            if (eObject.eResource() != resource) {
                resource.getContents().add((Object)eObject);
            }
            if (resource2 == null) continue;
            for (EObject eObject2 : eObject.eContents()) {
                Resource resource3;
                if (collection.contains(eObject2) || (resource3 = eObject2.eResource()) != resource) continue;
                resource2.getContents().add((Object)eObject2);
            }
        }
    }

    private void remeberMoved(Collection<EObject> collection, Resource resource) {
        Set<EObject> set = this.transfered.get(resource);
        if (set == null) {
            set = new HashSet<EObject>();
            this.transfered.put(resource, set);
        }
        set.addAll(collection);
    }

    @Override
    public void finish() {
    }

    @Override
    public ITransferedData getTransferedData() {
        return this.data;
    }

    private class MovedData
    implements ITransferedData {
        private MovedData() {
        }

        @Override
        public EObject getTransfered(EObject eObject) {
            Resource resource = eObject.eResource();
            Set set = (Set)DataMover.this.transfered.get(resource);
            return set != null && EcoreUtil.isAncestor((Collection)set, (EObject)eObject) ? eObject : null;
        }
    }
}

