/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.decomposition;

import com.nomagic.annotation.OpenApi;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.spi.decomposition.AbstractProjectAttachmentConfiguration;
import com.nomagic.ci.persistence.spi.decomposition.AttachmentType;
import com.nomagic.ci.persistence.versioning.IVersionDescriptor;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.emf.common.util.URI;

@OpenApi
public class ProjectAttachmentConfiguration
extends AbstractProjectAttachmentConfiguration {
    private Map<String, Map<String, String>> mountOptions;
    private boolean loadedAutomatically;
    private String preferredProjectRepositoryType;

    @OpenApi
    public ProjectAttachmentConfiguration(URI uRI) {
        this(uRI, null, true, null, null, true);
    }

    @OpenApi
    public ProjectAttachmentConfiguration(@Nonnull IProject iProject) {
        this(iProject.getLocationURI(), null, true, null, null, true);
        this.attachedProject = iProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProjectAttachmentConfiguration(URI uRI, ProjectAttachmentConfiguration projectAttachmentConfiguration) {
        this(uRI, projectAttachmentConfiguration.getPreferredProjectRepositoryType(), projectAttachmentConfiguration.isReadOnly(), projectAttachmentConfiguration.getStickyVersion(), null, projectAttachmentConfiguration.getMountOptions(), projectAttachmentConfiguration.isLoadedAutomatically());
        for (String string : projectAttachmentConfiguration.getCustomOptionNames()) {
            this.setCustomOptionValue(string, projectAttachmentConfiguration.getCustomOptionValue(string));
        }
    }

    @Deprecated
    public ProjectAttachmentConfiguration(URI uRI, String string, boolean bl, IVersionDescriptor iVersionDescriptor, @CheckForNull URI uRI2, Map<String, Map<String, String>> map, boolean bl2) {
        this(uRI, string, bl, iVersionDescriptor, map, bl2);
    }

    public ProjectAttachmentConfiguration(URI uRI, @CheckForNull String string, boolean bl, @CheckForNull IVersionDescriptor iVersionDescriptor, @CheckForNull Map<String, Map<String, String>> map, boolean bl2) {
        this(uRI, string, bl, iVersionDescriptor, map, bl2, AttachmentType.MANUAL);
    }

    public ProjectAttachmentConfiguration(URI uRI, @CheckForNull String string, boolean bl, @CheckForNull IVersionDescriptor iVersionDescriptor, @CheckForNull Map<String, Map<String, String>> map, boolean bl2, AttachmentType attachmentType) {
        super(uRI, bl, iVersionDescriptor, attachmentType);
        if (attachmentType == null) {
            throw new IllegalArgumentException("attachmentType can not be null");
        }
        this.preferredProjectRepositoryType = string;
        this.mountOptions = map;
        this.loadedAutomatically = bl2;
    }

    public Map<String, Map<String, String>> getMountOptions() {
        return this.mountOptions;
    }

    public void setMountOptions(Map<String, Map<String, String>> map) {
        this.mountOptions = map;
    }

    public boolean isLoadedAutomatically() {
        return this.loadedAutomatically;
    }

    public void setLoadAutomatically(boolean bl) {
        this.loadedAutomatically = bl;
    }

    public String getPreferredProjectRepositoryType() {
        return this.preferredProjectRepositoryType;
    }

    public void setPreferredProjectRepositoryType(String string) {
        this.preferredProjectRepositoryType = string;
    }

    public Object clone() {
        ProjectAttachmentConfiguration projectAttachmentConfiguration = new ProjectAttachmentConfiguration(this.attachedProjectURI, this.preferredProjectRepositoryType, this.readOnly, this.stickyVersion, this.mountOptions, this.loadedAutomatically);
        projectAttachmentConfiguration.customOptions = this.customOptions;
        projectAttachmentConfiguration.attachmentType = this.getAttachmentType();
        return projectAttachmentConfiguration;
    }
}

