/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence;

import com.nomagic.annotation.OpenApi;
import com.nomagic.ci.persistence.ProjectDescriptor;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@OpenApi
public class DecompositionDescriptor {
    protected String id;
    protected Map<String, String> properties;
    protected Collection<? extends ProjectFeatureDescriptor> features;
    protected ProjectDescriptor projectDescriptor;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DecompositionDescriptor(ProjectDescriptor projectDescriptor, String string, Map<String, String> map, Collection<ProjectFeatureDescriptor> collection) {
        if (projectDescriptor == null) throw new IllegalArgumentException();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.projectDescriptor = projectDescriptor;
        this.id = string;
        DecompositionDescriptor decompositionDescriptor = this;
        Map<String, String> map2 = map != null ? map : Collections.emptyMap();
        decompositionDescriptor.properties = map2;
        DecompositionDescriptor decompositionDescriptor2 = this;
        Collection<ProjectFeatureDescriptor> collection2 = collection != null ? collection : Collections.emptyList();
        decompositionDescriptor2.features = collection2;
    }

    public ProjectDescriptor getProjectDescriptor() {
        return this.projectDescriptor;
    }

    public Collection<? extends ProjectFeatureDescriptor> getFeatures() {
        return Collections.unmodifiableCollection(this.features);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getId() {
        return this.id;
    }

    public static class DataSetDescriptor {
        protected String name;
        protected Map<String, String> options;

        public DataSetDescriptor(String string, Map<String, String> map) {
            this.name = string;
            this.options = map;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getOptions() {
            return this.options;
        }

        public String toString() {
            return String.format("[%s,%s]", this.name, this.options);
        }
    }

    public static class ProjectFeatureDescriptor
    implements IProjectFeatureDescriptor {
        protected String name;
        protected String namespace;
        protected String version;
        protected int internalVersion;
        protected Collection<? extends DataSetDescriptor> dataSets;

        public ProjectFeatureDescriptor(String string, String string2, String string3, int n, Collection<DataSetDescriptor> collection) {
            this.name = string;
            this.namespace = string2;
            this.version = string3;
            this.internalVersion = n;
            this.dataSets = collection != null ? collection : Collections.emptyList();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public int getInternalVersion() {
            return this.internalVersion;
        }

        public Collection<? extends DataSetDescriptor> getDataSets() {
            return Collections.unmodifiableCollection(this.dataSets);
        }

        public String toString() {
            return String.format("[%s,%s,%s]", this.name, this.namespace, this.version);
        }
    }
}

