/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence;

import com.nomagic.ci.event.AbstractEventSupport;
import com.nomagic.ci.persistence.IProjectRepository;
import com.nomagic.ci.persistence.IProjectRepositoryType;
import com.nomagic.ci.persistence.ProjectRepositoryTypeListener;

public abstract class AbstractProjectRepositoryType
implements IProjectRepositoryType {
    protected final AbstractEventSupport<ProjectRepositoryTypeListener, ListenerNotifier> eventSupport = new AbstractEventSupport<ProjectRepositoryTypeListener, ListenerNotifier>(){

        protected void notify(ProjectRepositoryTypeListener projectRepositoryTypeListener, ListenerNotifier listenerNotifier) {
            listenerNotifier.notify(projectRepositoryTypeListener);
        }
    };

    protected final IProjectRepository createRepositoryAndNotifyListeners() {
        final IProjectRepository iProjectRepository = this.doCreateProjectRepository();
        this.eventSupport.fireEvent((Object)new ListenerNotifier(){

            @Override
            public void notify(ProjectRepositoryTypeListener projectRepositoryTypeListener) {
                projectRepositoryTypeListener.projectRepositoryCreated(iProjectRepository);
            }
        });
        return iProjectRepository;
    }

    protected abstract IProjectRepository doCreateProjectRepository();

    @Override
    public void addListener(ProjectRepositoryTypeListener projectRepositoryTypeListener) {
        this.eventSupport.addListener((Object)projectRepositoryTypeListener);
    }

    @Override
    public void removeListener(ProjectRepositoryTypeListener projectRepositoryTypeListener) {
        this.eventSupport.removeListener((Object)projectRepositoryTypeListener);
    }

    public static interface ListenerNotifier {
        public void notify(ProjectRepositoryTypeListener var1);
    }
}

