/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.status.AtomicCounter;

public class AgentInvoker
implements AutoCloseable {
    private boolean isClosed = false;
    private boolean isStarted = false;
    private boolean isRunning = false;
    private final AtomicCounter errorCounter;
    private final ErrorHandler errorHandler;
    private final Agent agent;

    public AgentInvoker(ErrorHandler errorHandler, AtomicCounter errorCounter, Agent agent) {
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(agent, "agent");
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
        this.agent = agent;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Agent agent() {
        return this.agent;
    }

    public void start() {
        try {
            if (!this.isStarted) {
                this.isStarted = true;
                this.agent.onStart();
                this.isRunning = true;
            }
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
            this.close();
        }
    }

    public int invoke() {
        int workCount = 0;
        if (this.isRunning) {
            try {
                workCount = this.agent.doWork();
            }
            catch (InterruptedException | ClosedByInterruptException ignore) {
                this.close();
                Thread.currentThread().interrupt();
            }
            catch (AgentTerminationException ex) {
                this.handleError(ex);
                this.close();
            }
            catch (Throwable throwable) {
                this.handleError(throwable);
            }
        }
        return workCount;
    }

    @Override
    public final void close() {
        try {
            if (!this.isClosed) {
                this.isRunning = false;
                this.isClosed = true;
                this.agent.onClose();
            }
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
    }

    private void handleError(Throwable throwable) {
        if (null != this.errorCounter) {
            this.errorCounter.increment();
        }
        this.errorHandler.onError(throwable);
    }
}

