/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongIterator;

public final class LongHashSet
extends AbstractSet<Long>
implements Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final long MISSING_VALUE = -1L;
    private final boolean shouldCacheIterator;
    private boolean containsMissingValue;
    private final float loadFactor;
    private int resizeThreshold;
    private int sizeOfArrayValues;
    private long[] values;
    private LongHashSetIterator iterator;

    public LongHashSet() {
        this(8);
    }

    public LongHashSet(int proposedCapacity) {
        this(proposedCapacity, 0.55f, true);
    }

    public LongHashSet(int proposedCapacity, float loadFactor) {
        this(proposedCapacity, loadFactor, true);
    }

    public LongHashSet(int proposedCapacity, float loadFactor, boolean shouldCacheIterator) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.shouldCacheIterator = shouldCacheIterator;
        this.loadFactor = loadFactor;
        this.sizeOfArrayValues = 0;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, proposedCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.values = new long[capacity];
        Arrays.fill(this.values, -1L);
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public boolean add(Long value) {
        return this.add((long)value);
    }

    @Override
    public boolean add(long value) {
        if (value == -1L) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = true;
            return !previousContainsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1L) {
            if (values[index] == value) {
                return false;
            }
            index = LongHashSet.next(index, mask);
        }
        values[index] = value;
        ++this.sizeOfArrayValues;
        if (this.sizeOfArrayValues > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return true;
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length * 2;
        if (newCapacity < 0) {
            throw new IllegalStateException("Max capacity reached at size=" + this.size());
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int capacity = newCapacity;
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        long[] tempValues = new long[capacity];
        Arrays.fill(tempValues, -1L);
        for (long value : this.values) {
            if (value == -1L) continue;
            int newHash = Hashing.hash(value, mask);
            while (tempValues[newHash] != -1L) {
                ++newHash;
                newHash &= mask;
            }
            tempValues[newHash] = value;
        }
        this.values = tempValues;
    }

    @Override
    public boolean remove(Object value) {
        return value instanceof Long && this.remove((Long)value);
    }

    public boolean remove(long value) {
        if (value == -1L) {
            boolean previousContainsMissingValue = this.containsMissingValue;
            this.containsMissingValue = false;
            return previousContainsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1L) {
            if (values[index] == value) {
                values[index] = -1L;
                this.compactChain(index);
                --this.sizeOfArrayValues;
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    private static int next(int index, int mask) {
        return index + 1 & mask;
    }

    void compactChain(int deleteIndex) {
        long[] values = this.values;
        int mask = values.length - 1;
        int index = deleteIndex;
        while (values[index = LongHashSet.next(index, mask)] != -1L) {
            int hash = Hashing.hash(values[index], mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            values[deleteIndex] = values[index];
            values[index] = -1L;
            deleteIndex = index;
        }
        return;
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public boolean contains(Object value) {
        return value instanceof Long && this.contains((Long)value);
    }

    public boolean contains(long value) {
        if (value == -1L) {
            return this.containsMissingValue;
        }
        long[] values = this.values;
        int mask = values.length - 1;
        int index = Hashing.hash(value, mask);
        while (values[index] != -1L) {
            if (values[index] == value) {
                return true;
            }
            index = LongHashSet.next(index, mask);
        }
        return false;
    }

    @Override
    public int size() {
        return this.sizeOfArrayValues + (this.containsMissingValue ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, -1L);
        this.sizeOfArrayValues = 0;
        this.containsMissingValue = false;
    }

    @Override
    public boolean addAll(Collection<? extends Long> coll) {
        boolean added = false;
        for (Long l : coll) {
            added |= this.add(l);
        }
        return added;
    }

    public boolean addAll(LongHashSet coll) {
        boolean acc = false;
        for (long value : coll.values) {
            if (value == -1L) continue;
            acc |= this.add(value);
        }
        if (coll.containsMissingValue) {
            acc |= this.add(-1L);
        }
        return acc;
    }

    public boolean containsAll(LongHashSet other) {
        for (long value : other.values) {
            if (value == -1L || this.contains(value)) continue;
            return false;
        }
        return !other.containsMissingValue || this.containsMissingValue;
    }

    public LongHashSet difference(LongHashSet other) {
        LongHashSet difference = null;
        for (long value : this.values) {
            if (value == -1L || other.contains(value)) continue;
            if (difference == null) {
                difference = new LongHashSet();
            }
            difference.add(value);
        }
        if (other.containsMissingValue && !this.containsMissingValue) {
            if (difference == null) {
                difference = new LongHashSet();
            }
            difference.add(-1L);
        }
        return difference;
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        boolean removed = false;
        for (Object value : coll) {
            removed |= this.remove(value);
        }
        return removed;
    }

    public boolean removeAll(LongHashSet coll) {
        boolean acc = false;
        for (long value : coll.values) {
            if (value == -1L) continue;
            acc |= this.remove(value);
        }
        if (coll.containsMissingValue) {
            acc |= this.remove(-1L);
        }
        return acc;
    }

    public LongIterator iterator() {
        LongHashSetIterator iterator = this.iterator;
        if (null == iterator) {
            iterator = new LongHashSetIterator();
            if (this.shouldCacheIterator) {
                this.iterator = iterator;
            }
        }
        iterator.reset(this.values, this.containsMissingValue, this.size());
        return iterator;
    }

    public void copy(LongHashSet that) {
        if (this.values.length != that.values.length) {
            throw new IllegalArgumentException("Cannot copy object: masks not equal");
        }
        System.arraycopy(that.values, 0, this.values, 0, this.values.length);
        this.sizeOfArrayValues = that.sizeOfArrayValues;
        this.containsMissingValue = that.containsMissingValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (long value : this.values) {
            if (value == -1L) continue;
            sb.append(value);
            sb.append(", ");
        }
        if (this.containsMissingValue) {
            sb.append(-1L);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public <T> T[] toArray(T[] longo) {
        Class<Long> componentType = longo.getClass().getComponentType();
        if (!componentType.isAssignableFrom(Long.class)) {
            throw new ArrayStoreException("Cannot store Longs in array of type " + componentType);
        }
        int size = this.size();
        Object[] arrayCopy = longo.length >= size ? longo : (Object[])Array.newInstance(componentType, size);
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    @Override
    public Object[] toArray() {
        Object[] arrayCopy = new Object[this.size()];
        this.copyValues(arrayCopy);
        return arrayCopy;
    }

    private void copyValues(Object[] arrayCopy) {
        long[] values;
        int i = 0;
        for (long value : values = this.values) {
            if (-1L == value) continue;
            arrayCopy[i++] = value;
        }
        if (this.containsMissingValue) {
            arrayCopy[this.sizeOfArrayValues] = -1L;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof LongHashSet) {
            LongHashSet otherSet = (LongHashSet)other;
            return otherSet.containsMissingValue == this.containsMissingValue && otherSet.sizeOfArrayValues == this.sizeOfArrayValues && this.containsAll(otherSet);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (long value : this.values) {
            if (value == -1L) continue;
            hashCode += Long.hashCode(value);
        }
        if (this.containsMissingValue) {
            hashCode += Long.hashCode(-1L);
        }
        return hashCode;
    }

    public final class LongHashSetIterator
    extends LongIterator {
        @Override
        public void remove() {
            if (this.isPositionValid) {
                if (this.remaining() == 1 && LongHashSet.this.containsMissingValue) {
                    LongHashSet.this.containsMissingValue = false;
                } else {
                    int position = this.position();
                    ((LongHashSet)LongHashSet.this).values[position] = -1L;
                    --LongHashSet.this.sizeOfArrayValues;
                    LongHashSet.this.compactChain(position);
                }
            } else {
                throw new IllegalStateException();
            }
            this.isPositionValid = false;
        }
    }
}

