/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Long2ObjectCache<V>
implements Map<Long, V>,
Serializable {
    private long cachePuts = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private int size;
    private final int capacity;
    private final int setSize;
    private final int mask;
    private final long[] keys;
    private final Object[] values;
    private final Consumer<V> evictionConsumer;
    private ValueCollection<V> valueCollection;
    private KeySet keySet;
    private EntrySet<V> entrySet;

    public Long2ObjectCache(int numSets, int setSize, Consumer<V> evictionConsumer) {
        CollectionUtil.validatePositivePowerOfTwo(numSets);
        Objects.requireNonNull(evictionConsumer, "Null values are not permitted");
        if ((long)numSets * (long)setSize > 0x7FFFFFFFFFFFFFF7L) {
            throw new IllegalArgumentException("Total capacity must be <= max array size: numSets=" + numSets + " setSize=" + setSize);
        }
        this.setSize = setSize;
        this.capacity = numSets * setSize;
        this.mask = numSets - 1;
        this.keys = new long[this.capacity];
        this.values = new Object[this.capacity];
        this.evictionConsumer = evictionConsumer;
    }

    public long cacheHits() {
        return this.cacheHits;
    }

    public long cacheMisses() {
        return this.cacheMisses;
    }

    public long cachePuts() {
        return this.cachePuts;
    }

    public void resetCounters() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cachePuts = 0L;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    public boolean containsKey(long key) {
        int setBeginIndex;
        boolean found = false;
        int setNumber = Hashing.hash(key, this.mask);
        int setEndIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber * this.setSize; i < setEndIndex && null != this.values[i]; ++i) {
            if (key != this.keys[i]) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        if (null != value) {
            for (Object v : this.values) {
                if (!value.equals(v)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Long)key);
    }

    public V get(long key) {
        int setBeginIndex;
        Object value = null;
        int setNumber = Hashing.hash(key, this.mask);
        int setEndIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber * this.setSize; i < setEndIndex && null != this.values[i]; ++i) {
            if (key != this.keys[i]) continue;
            value = this.values[i];
            break;
        }
        if (null == value) {
            ++this.cacheMisses;
        } else {
            ++this.cacheHits;
        }
        return (V)value;
    }

    public V computeIfAbsent(long key, LongFunction<? extends V> mappingFunction) {
        V value = this.get(key);
        if (value == null && (value = mappingFunction.apply(key)) != null) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public V put(Long key, V value) {
        return this.put((long)key, value);
    }

    @Override
    public V put(long key, V value) {
        int setBeginIndex;
        Objects.requireNonNull(value, "null values are not supported");
        Object evictedValue = null;
        int setNumber = Hashing.hash(key, this.mask);
        int nextSetIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber * this.setSize; i < nextSetIndex && null != this.values[i]; ++i) {
            if (key != this.keys[i]) continue;
            evictedValue = this.values[i];
            this.shuffleUp(i, nextSetIndex - 1);
            break;
        }
        if (null == evictedValue) {
            evictedValue = this.values[setBeginIndex + (this.setSize - 1)];
        }
        this.shuffleDown(setBeginIndex);
        this.keys[setBeginIndex] = key;
        this.values[setBeginIndex] = value;
        ++this.cachePuts;
        if (null != evictedValue) {
            this.evictionConsumer.accept(evictedValue);
        } else {
            ++this.size;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Long)key);
    }

    public V remove(long key) {
        int setBeginIndex;
        Object value = null;
        int setNumber = Hashing.hash(key, this.mask);
        int nextSetIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber * this.setSize; i < nextSetIndex && null != this.values[i]; ++i) {
            if (key != this.keys[i]) continue;
            value = this.values[i];
            this.shuffleUp(i, nextSetIndex - 1);
            --this.size;
            this.evictionConsumer.accept(value);
            break;
        }
        return (V)value;
    }

    private void shuffleUp(int fromIndex, int toIndex) {
        this.values[toIndex] = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            this.values[i] = this.values[i + 1];
            this.keys[i] = this.keys[i + 1];
        }
    }

    private void shuffleDown(int setBeginIndex) {
        for (int i = setBeginIndex + (this.setSize - 1); i > setBeginIndex; --i) {
            this.values[i] = this.values[i - 1];
            this.keys[i] = this.keys[i - 1];
        }
        this.values[setBeginIndex] = null;
    }

    @Override
    public void clear() {
        for (Object value : this.values) {
            if (null == value) continue;
            this.values[i] = null;
            --this.size;
            this.evictionConsumer.accept(value);
        }
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            sb.append(this.keys[i]);
            sb.append('=');
            sb.append(value);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object thatValue;
            Object thisValue = this.values[i];
            if (null == thisValue || null != (thatValue = that.get(this.keys[i])) && thisValue.equals(thatValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            Object value = this.values[i];
            if (null == value) continue;
            result += Long.hashCode(this.keys[i]) ^ value.hashCode();
        }
        return result;
    }

    public class EntryIterator<T>
    extends AbstractIterator<Map.Entry<Long, T>>
    implements Map.Entry<Long, T> {
        @Override
        public Map.Entry<Long, T> next() {
            this.findNext();
            return this;
        }

        @Override
        public Long getKey() {
            return Long2ObjectCache.this.keys[this.position()];
        }

        @Override
        public T getValue() {
            return (T)Long2ObjectCache.this.values[this.position()];
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException("Cannot set on this iterator");
        }
    }

    public class KeyIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return Long2ObjectCache.this.keys[this.position()];
        }
    }

    public class ValueIterator<T>
    extends AbstractIterator<T> {
        @Override
        public T next() {
            this.findNext();
            return (T)Long2ObjectCache.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int remaining;
        private int position = -1;

        AbstractIterator() {
        }

        protected int position() {
            return this.position;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected void findNext() {
            boolean found = false;
            for (int i = this.position + 1; i < Long2ObjectCache.this.capacity; ++i) {
                if (null == Long2ObjectCache.this.values[i]) continue;
                found = true;
                this.position = i;
                --this.remaining;
                break;
            }
            if (!found) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported on Iterator");
        }

        void reset() {
            this.remaining = Long2ObjectCache.this.size;
            this.position = -1;
        }
    }

    class EntrySet<T>
    extends AbstractSet<Map.Entry<Long, T>> {
        private final EntryIterator<T> iterator;

        EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Long2ObjectCache.this.size();
        }

        @Override
        public Iterator<Map.Entry<Long, T>> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectCache.this.clear();
        }
    }

    class ValueCollection<T>
    extends AbstractCollection<T> {
        private final ValueIterator<T> iterator;

        ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Long2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectCache.this.containsValue(o);
        }

        @Override
        public ValueIterator<T> iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Long2ObjectCache.this.clear();
        }
    }

    public class KeySet
    extends AbstractSet<Long> {
        private final KeyIterator iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Long2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Long2ObjectCache.this.containsKey(o);
        }

        public boolean contains(long key) {
            return Long2ObjectCache.this.containsKey(key);
        }

        public KeyIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Cannot remove on iterator");
        }

        @Override
        public void clear() {
            Long2ObjectCache.this.clear();
        }
    }
}

