/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;

public class DeadlineTimerWheel {
    private static final int INITIAL_TICK_ALLOCATION = 16;
    private static final long NULL_TIMER = Long.MAX_VALUE;
    private final long[][] wheel;
    private final long startTime;
    private final int tickResolution;
    private final int wheelMask;
    private final int resolutionBitsToShift;
    private final TimeUnit timeUnit;
    private long timerCount;
    private int currentTick;
    private int pollIndex;

    public DeadlineTimerWheel(TimeUnit timeUnit, long startTime, int tickResolution, int ticksPerWheel) {
        this(timeUnit, startTime, tickResolution, ticksPerWheel, 16);
    }

    public DeadlineTimerWheel(TimeUnit timeUnit, long startTime, int tickResolution, int ticksPerWheel, int initialTickAllocation) {
        DeadlineTimerWheel.checkTicksPerWheel(ticksPerWheel);
        DeadlineTimerWheel.checkResolution(tickResolution);
        this.timeUnit = timeUnit;
        this.wheelMask = ticksPerWheel - 1;
        this.tickResolution = tickResolution;
        this.resolutionBitsToShift = Integer.numberOfTrailingZeros(tickResolution);
        this.startTime = startTime;
        this.timerCount = 0L;
        this.pollIndex = 0;
        this.wheel = new long[ticksPerWheel][];
        for (int i = 0; i < this.wheel.length; ++i) {
            this.wheel[i] = new long[initialTickAllocation];
            for (int j = 0; j < this.wheel[i].length; ++j) {
                this.wheel[i][j] = Long.MAX_VALUE;
            }
        }
    }

    public TimeUnit timeUnit() {
        return this.timeUnit;
    }

    public long tickResolution() {
        return this.tickResolution;
    }

    public long currentTickTime() {
        return ((long)this.currentTick + 1L << this.resolutionBitsToShift) + this.startTime;
    }

    public long timerCount() {
        return this.timerCount;
    }

    public long scheduleTimer(long deadline) {
        long ticks = Math.max(deadline - this.startTime >> this.resolutionBitsToShift, (long)this.currentTick);
        int wheelIndex = (int)(ticks & (long)this.wheelMask);
        long[] array = this.wheel[wheelIndex];
        for (int i = 0; i < array.length; ++i) {
            if (Long.MAX_VALUE != array[i]) continue;
            array[i] = deadline;
            ++this.timerCount;
            return DeadlineTimerWheel.timerIdForSlot(wheelIndex, i);
        }
        long[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = deadline;
        this.wheel[wheelIndex] = newArray;
        ++this.timerCount;
        return DeadlineTimerWheel.timerIdForSlot(wheelIndex, array.length);
    }

    public void cancelTimer(long timerId) {
        int arrayIndex;
        int wheelIndex = DeadlineTimerWheel.tickForTimerId(timerId);
        long[] array = this.wheel[wheelIndex];
        if (array[arrayIndex = DeadlineTimerWheel.indexInTickArray(timerId)] != Long.MAX_VALUE) {
            array[arrayIndex] = Long.MAX_VALUE;
            --this.timerCount;
        }
    }

    public int poll(long now, TimerHandler handler, int maxTimersToExpire) {
        int timersExpired = 0;
        if (this.timerCount > 0L) {
            long[] array = this.wheel[this.currentTick & this.wheelMask];
            int length = array.length;
            for (int i = 0; i < length && maxTimersToExpire > timersExpired; ++i) {
                long deadline = array[this.pollIndex];
                if (deadline <= now) {
                    array[this.pollIndex] = Long.MAX_VALUE;
                    --this.timerCount;
                    ++timersExpired;
                    if (!handler.onTimerExpiry(this.timeUnit, now, DeadlineTimerWheel.timerIdForSlot(this.currentTick & this.wheelMask, this.pollIndex))) {
                        array[this.pollIndex] = deadline;
                        ++this.timerCount;
                        return timersExpired;
                    }
                }
                this.pollIndex = this.pollIndex + 1 >= length ? 0 : this.pollIndex + 1;
            }
            if (maxTimersToExpire > timersExpired && this.currentTickTime() <= now) {
                ++this.currentTick;
                this.pollIndex = 0;
            } else if (this.pollIndex >= array.length) {
                this.pollIndex = 0;
            }
        }
        return timersExpired;
    }

    public void forEach(TimerConsumer consumer) {
        long numTimersLeft = this.timerCount;
        int end = this.currentTick + this.wheel.length;
        for (int j = this.currentTick; j <= end; ++j) {
            long[] array = this.wheel[j & this.wheelMask];
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                long deadline = array[i];
                if (deadline == Long.MAX_VALUE) continue;
                consumer.accept(deadline, DeadlineTimerWheel.timerIdForSlot(j & this.wheelMask, i));
                if (--numTimersLeft != 0L) continue;
                return;
            }
        }
    }

    private static long timerIdForSlot(int tickOnWheel, int tickArrayIndex) {
        return (long)tickOnWheel << 32 | (long)tickArrayIndex;
    }

    private static int tickForTimerId(long timerId) {
        return (int)(timerId >> 32);
    }

    private static int indexInTickArray(long timerId) {
        return (int)timerId;
    }

    private static void checkTicksPerWheel(int ticksPerWheel) {
        if (!BitUtil.isPowerOfTwo(ticksPerWheel)) {
            throw new IllegalArgumentException("ticks per wheel must be a power of 2: " + ticksPerWheel);
        }
    }

    private static void checkResolution(int tickResolution) {
        if (!BitUtil.isPowerOfTwo(tickResolution)) {
            throw new IllegalArgumentException(" tick resolution must be a power of 2: " + tickResolution);
        }
    }

    @FunctionalInterface
    public static interface TimerConsumer {
        public void accept(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TimerHandler {
        public boolean onTimerExpiry(TimeUnit var1, long var2, long var4);
    }
}

