/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.ce.core.rt.options;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AttributeCreationType implements Enumerator
{
    ATTRIBUTE(0, "ATTRIBUTE", "ATTRIBUTE"),
    ASSOCIATION(1, "ASSOCIATION", "ASSOCIATION"),
    RULES(2, "RULES", "RULES");

    public static final int ATTRIBUTE_VALUE = 0;
    public static final int ASSOCIATION_VALUE = 1;
    public static final int RULES_VALUE = 2;
    private static final AttributeCreationType[] VALUES_ARRAY;
    public static final List<AttributeCreationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttributeCreationType[]{ATTRIBUTE, ASSOCIATION, RULES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttributeCreationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeCreationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeCreationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeCreationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeCreationType get(int value) {
        switch (value) {
            case 0: {
                return ATTRIBUTE;
            }
            case 1: {
                return ASSOCIATION;
            }
            case 2: {
                return RULES;
            }
        }
        return null;
    }

    private AttributeCreationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

