/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.metamodel.project.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class EListUtil {
    public static <I, O extends I> void collectListItems(EList<I> eList, ItemFilter<I> itemFilter, EList<O> eList2) {
        for (Object e : eList) {
            if (!itemFilter.isAcceptable(e)) continue;
            eList2.add(e);
        }
    }

    public static <T> EList<T> getListItems(EList<T> eList, ItemFilter<T> itemFilter) {
        BasicEList basicEList = new BasicEList();
        EListUtil.collectListItems(eList, itemFilter, basicEList);
        return basicEList;
    }

    public static <I, O extends I> EList<O> getListItemsByType(EList<I> eList, Class<O> clazz) {
        BasicEList basicEList = new BasicEList();
        EListUtil.collectListItems(eList, new TypeFilter<O>(clazz), basicEList);
        return basicEList;
    }

    public static <E> InternalEList<E> createInternalList(Class<E> clazz, EList<E> eList) {
        if (eList instanceof InternalEList) {
            return (InternalEList)eList;
        }
        return new BasicInternalEList(clazz, eList);
    }

    public static <T> int indexOf(List<T> list, ItemFilter<T> itemFilter) {
        int n = 0;
        while (n < list.size()) {
            T t = list.get(n);
            if (itemFilter.isAcceptable(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static <I, O extends I> O find(List<I> list, Class<O> clazz) {
        int n = EListUtil.indexOf(list, new TypeFilter<O>(clazz));
        return n < 0 ? null : (O)list.get(n);
    }

    public static <T> T find(List<T> list, ItemFilter<T> itemFilter) {
        int n = EListUtil.indexOf(list, itemFilter);
        return n >= 0 ? (T)list.get(n) : null;
    }

    public static <T> boolean contains(List<T> list, ItemFilter<T> itemFilter) {
        return EListUtil.indexOf(list, itemFilter) >= 0;
    }

    public static <T> List<T> findAll(List<T> list, ItemFilter<T> itemFilter) {
        List list2 = Collections.emptyList();
        for (T t : list) {
            if (!itemFilter.isAcceptable(t)) continue;
            if (list2.isEmpty()) {
                list2 = new ArrayList();
            }
            list2.add(t);
        }
        return list2;
    }

    public static <T> void setContents(List<T> list, EList<T> eList) {
        int n = 0;
        while (n < list.size()) {
            T t = list.get(n);
            int n2 = n + eList.subList(n, eList.size()).indexOf(t);
            if (n2 < n) {
                eList.add(n, t);
            } else if (n2 > n) {
                eList.move(n, n2);
            }
            ++n;
        }
        if (eList.size() > list.size()) {
            eList.subList(list.size(), eList.size()).clear();
        }
    }

    public static class CompositeFilter<T>
    implements ItemFilter<T> {
        boolean matchAll;
        private ItemFilter<T>[] filters;

        public CompositeFilter(boolean bl, ItemFilter<T> ... itemFilterArray) {
            this.matchAll = bl;
            this.filters = itemFilterArray;
        }

        @Override
        public boolean isAcceptable(T t) {
            if (this.filters == null || this.filters.length == 0) {
                return false;
            }
            ItemFilter<T>[] itemFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                ItemFilter<T> itemFilter = itemFilterArray[n2];
                boolean bl = itemFilter.isAcceptable(t);
                if (this.matchAll && !bl) {
                    return false;
                }
                if (!this.matchAll && bl) {
                    return true;
                }
                ++n2;
            }
            return this.matchAll;
        }
    }

    public static interface ItemFilter<T> {
        public boolean isAcceptable(T var1);
    }

    public static class TypeFilter<T>
    implements ItemFilter<T> {
        private Class<? extends T> type;

        public TypeFilter(Class<? extends T> clazz) {
            this.type = clazz;
        }

        @Override
        public boolean isAcceptable(T t) {
            return this.type.isInstance(t);
        }
    }
}

