/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.metamodel.project.personalization;

import com.nomagic.ci.metamodel.project.DataSection;
import com.nomagic.ci.metamodel.project.ProjectFeature;
import com.nomagic.ci.metamodel.project.personalization.PersonalSectionsFilter;
import com.nomagic.ci.metamodel.project.util.CastUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractFilteredSectionsUtil<F extends ProjectFeature, D extends DataSection> {
    Class<D> dataSectionType;

    public AbstractFilteredSectionsUtil(Class<D> clazz) {
        this.dataSectionType = clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<D> getAccessibleSections(F f) {
        HashSet<D> hashSet = new HashSet<D>(this.getPersonalSections(f));
        ArrayList<DataSection> arrayList = new ArrayList<DataSection>();
        for (DataSection dataSection : f.getSections()) {
            if (dataSection.getBelongsTo() != null && !hashSet.contains(dataSection)) continue;
            arrayList.add((DataSection)CastUtil.castOrFail(this.dataSectionType, dataSection));
        }
        return arrayList;
    }

    public List<D> getPersonalSections(F f) {
        PersonalSectionsFilter<F, D> personalSectionsFilter = this.getFilter();
        if (personalSectionsFilter == null) {
            throw new RuntimeException("PersonalSectionsFilter not available");
        }
        return personalSectionsFilter.getPersonalSections(f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<D> getCommonSections(F f) {
        ArrayList<DataSection> arrayList = new ArrayList<DataSection>();
        for (DataSection dataSection : f.getSections()) {
            if (dataSection.getBelongsTo() != null) continue;
            arrayList.add((DataSection)CastUtil.castOrFail(this.dataSectionType, dataSection));
        }
        return arrayList;
    }

    protected abstract PersonalSectionsFilter<F, D> getFilter();
}

